/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.DerbyLegacySqlAstTranslator;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.function.CaseLeastGreatestEmulation;
import org.hibernate.dialect.function.CastingConcatFunction;
import org.hibernate.dialect.function.ChrLiteralEmulation;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.DerbyLpadEmulation;
import org.hibernate.dialect.function.DerbyRpadEmulation;
import org.hibernate.dialect.function.InsertSubstringOverlayEmulation;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.DerbyLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DerbySequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorDerbyDatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.BigDecimalJavaType;
import org.hibernate.type.descriptor.jdbc.DecimalJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullResolvingJdbcType;
import org.hibernate.type.descriptor.jdbc.SmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class DerbyLegacyDialect
extends Dialect {
    private final LimitHandler limitHandler = this.getVersion().isBefore(10, 5) ? AbstractLimitHandler.NO_LIMIT : new DerbyLimitHandler(this.getVersion().isSameOrAfter(10, 6));

    public DerbyLegacyDialect() {
        this(DatabaseVersion.make((Integer)10, (Integer)0));
    }

    public DerbyLegacyDialect(DatabaseVersion version) {
        super(version);
    }

    public DerbyLegacyDialect(DialectResolutionInfo info) {
        super(info);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return this.getVersion().isBefore(10, 7) ? "smallint" : super.columnType(sqlTypeCode);
            }
            case -6: {
                return "smallint";
            }
            case 2: {
                return this.columnType(3);
            }
            case -3: {
                return "varchar($l) for bit data";
            }
            case -15: {
                return this.columnType(1);
            }
            case -9: {
                return this.columnType(12);
            }
            case 2004: {
                return "blob";
            }
            case 2005: 
            case 2011: {
                return "clob";
            }
            case 92: 
            case 2013: {
                return "time";
            }
            case 93: 
            case 2014: {
                return "timestamp";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        int varcharDdlTypeCapacity = 32672;
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)-3, (CapacityDependentDdlType.LobKind)(this.isLob(4003) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE), (String)this.columnType(4003), (String)this.columnType(-3), (Dialect)this).withTypeCapacity((long)varcharDdlTypeCapacity, this.columnType(-3)).build());
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)12, (CapacityDependentDdlType.LobKind)(this.isLob(4001) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE), (String)this.columnType(4001), (String)this.columnType(12), (Dialect)this).withTypeCapacity((long)varcharDdlTypeCapacity, this.columnType(12)).build());
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)-9, (CapacityDependentDdlType.LobKind)(this.isLob(4002) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE), (String)this.columnType(4001), (String)this.columnType(-9), (Dialect)this).withTypeCapacity((long)varcharDdlTypeCapacity, this.columnType(-9)).build());
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)-2, (CapacityDependentDdlType.LobKind)(this.isLob(4003) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE), (String)this.columnType(4003), (String)this.columnType(-3), (Dialect)this).withTypeCapacity(254L, "char($l) for bit data").withTypeCapacity((long)varcharDdlTypeCapacity, this.columnType(-3)).build());
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)1, (CapacityDependentDdlType.LobKind)(this.isLob(4001) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE), (String)this.columnType(4001), (String)this.columnType(1), (Dialect)this).withTypeCapacity(254L, this.columnType(1)).withTypeCapacity((long)this.getMaxVarcharLength(), this.columnType(12)).build());
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)-15, (CapacityDependentDdlType.LobKind)(this.isLob(4002) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE), (String)this.columnType(4002), (String)this.columnType(-15), (Dialect)this).withTypeCapacity(254L, this.columnType(-15)).withTypeCapacity((long)this.getMaxVarcharLength(), this.columnType(-9)).build());
    }

    public int getMaxVarcharLength() {
        return 32672;
    }

    public int getMaxVarcharCapacity() {
        return 32700;
    }

    public int getDefaultDecimalPrecision() {
        return 31;
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return this.getVersion().isBefore(10, 7) ? 5 : 16;
    }

    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public int getFloatPrecision() {
        return 23;
    }

    public int getDoublePrecision() {
        return 52;
    }

    public int getDefaultTimestampPrecision() {
        return 9;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        BasicType stringType = basicTypeRegistry.resolve(StandardBasicTypes.STRING);
        DdlTypeRegistry ddlTypeRegistry = functionContributions.getTypeConfiguration().getDdlTypeRegistry();
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.aggregates((Dialect)this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionContributions.getFunctionRegistry().register("count", (SqmFunctionDescriptor)new CountFunction((Dialect)this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, "||", ddlTypeRegistry.getDescriptor(12).getCastTypeName(Size.nil(), (SqlExpressible)stringType, ddlTypeRegistry), true));
        functionFactory.avg_castingNonDoubleArguments((Dialect)this, SqlAstNodeRenderingMode.DEFAULT);
        functionContributions.getFunctionRegistry().register("chr", (SqmFunctionDescriptor)new ChrLiteralEmulation(functionContributions.getTypeConfiguration()));
        functionFactory.concat_pipeOperator();
        functionFactory.cot();
        functionFactory.degrees();
        functionFactory.radians();
        functionFactory.log10();
        functionFactory.sinh();
        functionFactory.cosh();
        functionFactory.tanh();
        functionFactory.pi();
        functionFactory.rand();
        functionFactory.trim1();
        functionFactory.hourMinuteSecond();
        functionFactory.yearMonthDay();
        functionFactory.varPopSamp();
        functionFactory.stddevPopSamp();
        functionFactory.substring_substr();
        functionFactory.leftRight_substrLength();
        functionFactory.characterLength_length(SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.power_expLn();
        functionFactory.round_floor();
        functionFactory.trunc_floor();
        functionFactory.octetLength_pattern("length(?1)", SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.bitLength_pattern("length(?1)*8", SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionContributions.getFunctionRegistry().register("concat", (SqmFunctionDescriptor)new CastingConcatFunction((Dialect)this, "||", true, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("lpad", (SqmFunctionDescriptor)new DerbyLpadEmulation(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("rpad", (SqmFunctionDescriptor)new DerbyRpadEmulation(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("least", (SqmFunctionDescriptor)new CaseLeastGreatestEmulation(true));
        functionContributions.getFunctionRegistry().register("greatest", (SqmFunctionDescriptor)new CaseLeastGreatestEmulation(false));
        functionContributions.getFunctionRegistry().register("overlay", (SqmFunctionDescriptor)new InsertSubstringOverlayEmulation(functionContributions.getTypeConfiguration(), true));
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DerbyLegacySqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day(?2)";
            }
            case DAY_OF_YEAR: {
                return "({fn timestampdiff(sql_tsi_day,date(char(year(?2),4)||'-01-01'),?2)}+1)";
            }
            case DAY_OF_WEEK: {
                return "(mod(mod({fn timestampdiff(sql_tsi_day,{d '1970-01-01'},?2)}+4,7)+7,7)+1)";
            }
            case WEEK: {
                return "(({fn timestampdiff(sql_tsi_day,date(char(year(?2),4)||'-01-01'),{fn timestampadd(sql_tsi_day,{fn timestampdiff(sql_tsi_day,{d '1753-01-01'},?2)}/7*7,{d '1753-01-04'})})}+7)/7)";
            }
            case QUARTER: {
                return "((month(?2)+2)/3)";
            }
            case EPOCH: {
                return "{fn timestampdiff(sql_tsi_second,{ts '1970-01-01 00:00:00'},?2)}";
            }
        }
        return "?1(?2)";
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_YEAR: 
            case DAY_OF_WEEK: 
            case WEEK: {
                throw new UnsupportedOperationException("field type not supported on Derby: " + unit);
            }
            case DAY_OF_MONTH: {
                return "day";
            }
        }
        return super.translateExtractField(unit);
    }

    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case FLOAT: {
                return "cast(double(?1) as real)";
            }
            case DOUBLE: {
                return "double(?1)";
            }
            case STRING: {
                switch (from) {
                    case FLOAT: 
                    case DOUBLE: {
                        return "cast(trim(cast(cast(?1 as decimal(" + this.getDefaultDecimalPrecision() + "," + BigDecimalJavaType.INSTANCE.getDefaultSqlScale((Dialect)this, null) + ")) as char(254))) as ?2)";
                    }
                    case INTEGER: 
                    case LONG: 
                    case FIXED: {
                        return "cast(trim(cast(?1 as char(254))) as ?2)";
                    }
                    case DATE: {
                        return "cast(?1 as varchar(10))";
                    }
                    case TIME: {
                        return "cast(?1 as varchar(8))";
                    }
                    case TIMESTAMP: {
                        return "cast(?1 as varchar(30))";
                    }
                }
            }
        }
        return super.castPattern(from, to);
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "{fn timestampadd(sql_tsi_frac_second,mod(bigint(?2),1000000000),{fn timestampadd(sql_tsi_second,bigint((?2)/1000000000),?3)})}";
            }
        }
        return "{fn timestampadd(sql_tsi_?1,bigint(?2),?3)}";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "{fn timestampdiff(sql_tsi_frac_second,?2,?3)}";
            }
        }
        return "{fn timestampdiff(sql_tsi_?1,?2,?3)}";
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        if (this.getVersion().isBefore(10, 7)) {
            appender.appendSql(bool ? (char)'1' : '0');
        } else {
            appender.appendSql(bool);
        }
    }

    public SequenceSupport getSequenceSupport() {
        return this.getVersion().isBefore(10, 6) ? super.getSequenceSupport() : DerbySequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return this.getVersion().isBefore(10, 6) ? null : "select sys.sysschemas.schemaname as sequence_schema,sys.syssequences.* from sys.syssequences left join sys.sysschemas on sys.syssequences.schemaid=sys.sysschemas.schemaid";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getVersion().isBefore(10, 6) ? SequenceInformationExtractorNoOpImpl.INSTANCE : SequenceInformationExtractorDerbyDatabaseImpl.INSTANCE;
    }

    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{"drop schema " + schemaName + " restrict"};
    }

    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return DB2Dialect.selectNullString((int)sqlType);
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.NONE;
    }

    public RowLockStrategy getReadRowLockStrategy() {
        return RowLockStrategy.NONE;
    }

    public String getForUpdateString() {
        return " for update with rs";
    }

    public String getWriteLockString(int timeout) {
        return " for update with rs";
    }

    public String getReadLockString(int timeout) {
        return " for read only with rs";
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }

    public boolean supportsLockTimeouts() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "values current timestamp";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return DB2IdentityColumnSupport.INSTANCE;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public boolean supportsOrderByInSubquery() {
        return this.getVersion().isSameOrAfter(10, 5);
    }

    public boolean requiresCastForConcatenatingNonStrings() {
        return true;
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (this.getVersion().isBefore(10, 7)) {
            jdbcTypeRegistry.addDescriptor(16, (JdbcType)SmallIntJdbcType.INSTANCE);
        }
        jdbcTypeRegistry.addDescriptor(2, (JdbcType)DecimalJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(2014, (JdbcType)TimestampJdbcType.INSTANCE);
        typeContributions.contributeJdbcType((JdbcType)ObjectNullResolvingJdbcType.INSTANCE);
        typeContributions.contributeType((BasicType)new JavaObjectType((JdbcType)ObjectNullResolvingJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(Object.class)));
    }

    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return new TemplatedViolatedConstraintNameExtractor(sqle -> {
            String sqlState = JdbcExceptionHelper.extractSqlState((SQLException)sqle);
            if (sqlState != null) {
                switch (sqlState) {
                    case "23505": {
                        return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"'", (String)"'", (String)sqle.getMessage());
                    }
                }
            }
            return null;
        });
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState((SQLException)sqlException);
            if (sqlState != null) {
                switch (sqlState) {
                    case "23505": {
                        String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                        return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, constraintName);
                    }
                    case "40XL1": 
                    case "40XL2": {
                        return new LockTimeoutException(message, sqlException, sql);
                    }
                }
            }
            return null;
        };
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        throw new UnsupportedOperationException("format() function not supported on Derby");
    }

    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("ADD");
        this.registerKeyword("ALL");
        this.registerKeyword("ALLOCATE");
        this.registerKeyword("ALTER");
        this.registerKeyword("AND");
        this.registerKeyword("ANY");
        this.registerKeyword("ARE");
        this.registerKeyword("AS");
        this.registerKeyword("ASC");
        this.registerKeyword("ASSERTION");
        this.registerKeyword("AT");
        this.registerKeyword("AUTHORIZATION");
        this.registerKeyword("AVG");
        this.registerKeyword("BEGIN");
        this.registerKeyword("BETWEEN");
        this.registerKeyword("BIT");
        this.registerKeyword("BOOLEAN");
        this.registerKeyword("BOTH");
        this.registerKeyword("BY");
        this.registerKeyword("CALL");
        this.registerKeyword("CASCADE");
        this.registerKeyword("CASCADED");
        this.registerKeyword("CASE");
        this.registerKeyword("CAST");
        this.registerKeyword("CHAR");
        this.registerKeyword("CHARACTER");
        this.registerKeyword("CHECK");
        this.registerKeyword("CLOSE");
        this.registerKeyword("COLLATE");
        this.registerKeyword("COLLATION");
        this.registerKeyword("COLUMN");
        this.registerKeyword("COMMIT");
        this.registerKeyword("CONNECT");
        this.registerKeyword("CONNECTION");
        this.registerKeyword("CONSTRAINT");
        this.registerKeyword("CONSTRAINTS");
        this.registerKeyword("CONTINUE");
        this.registerKeyword("CONVERT");
        this.registerKeyword("CORRESPONDING");
        this.registerKeyword("COUNT");
        this.registerKeyword("CREATE");
        this.registerKeyword("CURRENT");
        this.registerKeyword("CURRENT_DATE");
        this.registerKeyword("CURRENT_TIME");
        this.registerKeyword("CURRENT_TIMESTAMP");
        this.registerKeyword("CURRENT_USER");
        this.registerKeyword("CURSOR");
        this.registerKeyword("DEALLOCATE");
        this.registerKeyword("DEC");
        this.registerKeyword("DECIMAL");
        this.registerKeyword("DECLARE");
        this.registerKeyword("DEFERRABLE");
        this.registerKeyword("DEFERRED");
        this.registerKeyword("DELETE");
        this.registerKeyword("DESC");
        this.registerKeyword("DESCRIBE");
        this.registerKeyword("DIAGNOSTICS");
        this.registerKeyword("DISCONNECT");
        this.registerKeyword("DISTINCT");
        this.registerKeyword("DOUBLE");
        this.registerKeyword("DROP");
        this.registerKeyword("ELSE");
        this.registerKeyword("END");
        this.registerKeyword("ENDEXEC");
        this.registerKeyword("ESCAPE");
        this.registerKeyword("EXCEPT");
        this.registerKeyword("EXCEPTION");
        this.registerKeyword("EXEC");
        this.registerKeyword("EXECUTE");
        this.registerKeyword("EXISTS");
        this.registerKeyword("EXPLAIN");
        this.registerKeyword("EXTERNAL");
        this.registerKeyword("FALSE");
        this.registerKeyword("FETCH");
        this.registerKeyword("FIRST");
        this.registerKeyword("FLOAT");
        this.registerKeyword("FOR");
        this.registerKeyword("FOREIGN");
        this.registerKeyword("FOUND");
        this.registerKeyword("FROM");
        this.registerKeyword("FULL");
        this.registerKeyword("FUNCTION");
        this.registerKeyword("GET");
        this.registerKeyword("GET_CURRENT_CONNECTION");
        this.registerKeyword("GLOBAL");
        this.registerKeyword("GO");
        this.registerKeyword("GOTO");
        this.registerKeyword("GRANT");
        this.registerKeyword("GROUP");
        this.registerKeyword("HAVING");
        this.registerKeyword("HOUR");
        this.registerKeyword("IDENTITY");
        this.registerKeyword("IMMEDIATE");
        this.registerKeyword("IN");
        this.registerKeyword("INDICATOR");
        this.registerKeyword("INITIALLY");
        this.registerKeyword("INNER");
        this.registerKeyword("INOUT");
        this.registerKeyword("INPUT");
        this.registerKeyword("INSENSITIVE");
        this.registerKeyword("INSERT");
        this.registerKeyword("INT");
        this.registerKeyword("INTEGER");
        this.registerKeyword("INTERSECT");
        this.registerKeyword("INTO");
        this.registerKeyword("IS");
        this.registerKeyword("ISOLATION");
        this.registerKeyword("JOIN");
        this.registerKeyword("KEY");
        this.registerKeyword("LAST");
        this.registerKeyword("LEFT");
        this.registerKeyword("LIKE");
        this.registerKeyword("LONGINT");
        this.registerKeyword("LOWER");
        this.registerKeyword("LTRIM");
        this.registerKeyword("MATCH");
        this.registerKeyword("MAX");
        this.registerKeyword("MIN");
        this.registerKeyword("MINUTE");
        this.registerKeyword("NATIONAL");
        this.registerKeyword("NATURAL");
        this.registerKeyword("NCHAR");
        this.registerKeyword("NVARCHAR");
        this.registerKeyword("NEXT");
        this.registerKeyword("NO");
        this.registerKeyword("NOT");
        this.registerKeyword("NULL");
        this.registerKeyword("NULLIF");
        this.registerKeyword("NUMERIC");
        this.registerKeyword("OF");
        this.registerKeyword("ON");
        this.registerKeyword("ONLY");
        this.registerKeyword("OPEN");
        this.registerKeyword("OPTION");
        this.registerKeyword("OR");
        this.registerKeyword("ORDER");
        this.registerKeyword("OUT");
        this.registerKeyword("OUTER");
        this.registerKeyword("OUTPUT");
        this.registerKeyword("OVERLAPS");
        this.registerKeyword("PAD");
        this.registerKeyword("PARTIAL");
        this.registerKeyword("PREPARE");
        this.registerKeyword("PRESERVE");
        this.registerKeyword("PRIMARY");
        this.registerKeyword("PRIOR");
        this.registerKeyword("PRIVILEGES");
        this.registerKeyword("PROCEDURE");
        this.registerKeyword("PUBLIC");
        this.registerKeyword("READ");
        this.registerKeyword("REAL");
        this.registerKeyword("REFERENCES");
        this.registerKeyword("RELATIVE");
        this.registerKeyword("RESTRICT");
        this.registerKeyword("REVOKE");
        this.registerKeyword("RIGHT");
        this.registerKeyword("ROLLBACK");
        this.registerKeyword("ROWS");
        this.registerKeyword("RTRIM");
        this.registerKeyword("SCHEMA");
        this.registerKeyword("SCROLL");
        this.registerKeyword("SECOND");
        this.registerKeyword("SELECT");
        this.registerKeyword("SESSION_USER");
        this.registerKeyword("SET");
        this.registerKeyword("SMALLINT");
        this.registerKeyword("SOME");
        this.registerKeyword("SPACE");
        this.registerKeyword("SQL");
        this.registerKeyword("SQLCODE");
        this.registerKeyword("SQLERROR");
        this.registerKeyword("SQLSTATE");
        this.registerKeyword("SUBSTR");
        this.registerKeyword("SUBSTRING");
        this.registerKeyword("SUM");
        this.registerKeyword("SYSTEM_USER");
        this.registerKeyword("TABLE");
        this.registerKeyword("TEMPORARY");
        this.registerKeyword("TIMEZONE_HOUR");
        this.registerKeyword("TIMEZONE_MINUTE");
        this.registerKeyword("TO");
        this.registerKeyword("TRAILING");
        this.registerKeyword("TRANSACTION");
        this.registerKeyword("TRANSLATE");
        this.registerKeyword("TRANSLATION");
        this.registerKeyword("TRUE");
        this.registerKeyword("UNION");
        this.registerKeyword("UNIQUE");
        this.registerKeyword("UNKNOWN");
        this.registerKeyword("UPDATE");
        this.registerKeyword("UPPER");
        this.registerKeyword("USER");
        this.registerKeyword("USING");
        this.registerKeyword("VALUES");
        this.registerKeyword("VARCHAR");
        this.registerKeyword("VARYING");
        this.registerKeyword("VIEW");
        this.registerKeyword("WHENEVER");
        this.registerKeyword("WHERE");
        this.registerKeyword("WITH");
        this.registerKeyword("WORK");
        this.registerKeyword("WRITE");
        this.registerKeyword("XML");
        this.registerKeyword("XMLEXISTS");
        this.registerKeyword("XMLPARSE");
        this.registerKeyword("XMLSERIALIZE");
        this.registerKeyword("YEAR");
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable((EntityMappingType)rootEntityDescriptor, basename -> "session.HT_" + basename, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable((EntityMappingType)rootEntityDescriptor, name -> "session.HTE_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    public String getTemporaryTableCreateOptions() {
        return "not logged";
    }

    public boolean supportsTemporaryTablePrimaryKey() {
        return false;
    }

    public String getTemporaryTableCreateCommand() {
        return "declare global temporary table";
    }

    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    public boolean supportsPartitionBy() {
        return false;
    }

    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(10, 4);
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteInitialUnderscore(true);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }
}

