/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.util.Collections;
import java.util.List;
import org.hibernate.models.internal.ArrayTypeDetailsImpl;
import org.hibernate.models.internal.ParameterizedTypeDetailsImpl;
import org.hibernate.models.internal.PrimitiveKind;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.ArrayTypeDetails;
import org.hibernate.models.spi.ClassBasedTypeDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ParameterizedTypeDetails;
import org.hibernate.models.spi.PrimitiveTypeDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.TypeVariableReferenceDetails;
import org.hibernate.models.spi.TypeVariableScope;
import org.hibernate.models.spi.WildcardTypeDetails;

public class TypeDetailsHelper {
    public static TypeDetails resolveRelativeType(TypeDetails type, TypeVariableScope container) {
        switch (type.getTypeKind()) {
            case CLASS: 
            case PRIMITIVE: 
            case VOID: 
            case WILDCARD_TYPE: {
                return type;
            }
            case ARRAY: {
                ArrayTypeDetails arrayType = type.asArrayType();
                return new ArrayTypeDetailsImpl(arrayType.getArrayClassDetails(), arrayType.getConstituentType().determineRelativeType(container));
            }
            case PARAMETERIZED_TYPE: {
                List<TypeDetails> resolvedArguments;
                ParameterizedTypeDetails parameterizedType = type.asParameterizedType();
                if (parameterizedType.getArguments().isEmpty()) {
                    resolvedArguments = Collections.emptyList();
                } else {
                    resolvedArguments = CollectionHelper.arrayList(parameterizedType.getArguments().size());
                    for (TypeDetails argument : parameterizedType.getArguments()) {
                        resolvedArguments.add(argument.determineRelativeType(container));
                    }
                }
                return new ParameterizedTypeDetailsImpl(parameterizedType.getRawClassDetails(), resolvedArguments, container);
            }
            case TYPE_VARIABLE: {
                TypeVariableDetails typeVariable = type.asTypeVariable();
                return container.resolveTypeVariable(typeVariable);
            }
            case TYPE_VARIABLE_REFERENCE: {
                throw new UnsupportedOperationException("TypeVariableReferenceDetails not supported for concrete type resolution");
            }
        }
        throw new UnsupportedOperationException("Unknown TypeDetails kind - " + type.getTypeKind());
    }

    public static TypeVariableDetails findTypeVariableDetails(String identifier, List<TypeVariableDetails> typeParameters) {
        if (CollectionHelper.isNotEmpty(typeParameters)) {
            for (TypeVariableDetails typeParameter : typeParameters) {
                if (!typeParameter.getIdentifier().equals(identifier)) continue;
                return typeParameter;
            }
        }
        return null;
    }

    public static ClassBasedTypeDetails resolveRelativeClassType(TypeDetails memberType, TypeVariableScope containerType) {
        switch (memberType.getTypeKind()) {
            case CLASS: 
            case PRIMITIVE: 
            case VOID: 
            case ARRAY: {
                return (ClassBasedTypeDetails)memberType;
            }
            case TYPE_VARIABLE: {
                TypeVariableDetails typeVariable = memberType.asTypeVariable();
                TypeDetails typeDetails = containerType.resolveTypeVariable(typeVariable);
                if (typeDetails.getTypeKind() == TypeDetails.Kind.CLASS) {
                    return typeDetails.asClassType();
                }
                if (typeDetails.getTypeKind() == TypeDetails.Kind.TYPE_VARIABLE) {
                    TypeVariableDetails resolvedTypeVariable = typeDetails.asTypeVariable();
                    if (CollectionHelper.size(resolvedTypeVariable.getBounds()) == 1) {
                        return resolvedTypeVariable.getBounds().get(0).asClassType();
                    }
                    return ClassBasedTypeDetails.OBJECT_TYPE_DETAILS;
                }
                ParameterizedTypeDetails parameterizedType = typeDetails.asParameterizedType();
                if (CollectionHelper.size(parameterizedType.getArguments()) == 1) {
                    return parameterizedType.getArguments().get(0).asClassType();
                }
                return ClassBasedTypeDetails.OBJECT_TYPE_DETAILS;
            }
            case TYPE_VARIABLE_REFERENCE: {
                throw new UnsupportedOperationException("TypeVariableReferenceDetails not supported for relative class resolution");
            }
            case WILDCARD_TYPE: 
            case PARAMETERIZED_TYPE: {
                return TypeDetailsHelper.resolveRelativeType(memberType, containerType).asClassType();
            }
        }
        throw new UnsupportedOperationException("Unknown TypeDetails kind - " + memberType.getTypeKind());
    }

    public static ClassDetails resolveRawClass(TypeDetails typeDetails) {
        switch (typeDetails.getTypeKind()) {
            case CLASS: 
            case PRIMITIVE: 
            case VOID: 
            case ARRAY: {
                return ((ClassBasedTypeDetails)typeDetails).getClassDetails();
            }
            case TYPE_VARIABLE: {
                TypeVariableDetails resolvedTypeVariable = typeDetails.asTypeVariable();
                if (CollectionHelper.size(resolvedTypeVariable.getBounds()) == 1) {
                    return resolvedTypeVariable.getBounds().get(0).determineRawClass();
                }
                return ClassDetails.OBJECT_CLASS_DETAILS;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedTypeDetails parameterizedType = typeDetails.asParameterizedType();
                return parameterizedType.getRawClassDetails();
            }
            case WILDCARD_TYPE: {
                WildcardTypeDetails wildcardType = typeDetails.asWildcardType();
                if (wildcardType.getBound() != null) {
                    return wildcardType.getBound().determineRawClass();
                }
                return ClassDetails.OBJECT_CLASS_DETAILS;
            }
            case TYPE_VARIABLE_REFERENCE: {
                TypeVariableReferenceDetails typeVariableReference = typeDetails.asTypeVariableReference();
                TypeDetails identifiedTypeDetails = typeDetails.resolveTypeVariable(typeVariableReference.getTarget());
                return identifiedTypeDetails.determineRawClass();
            }
        }
        return ClassDetails.OBJECT_CLASS_DETAILS;
    }

    public static TypeDetails resolveTypeVariableFromParameterizedType(ParameterizedTypeDetails parameterizedType, TypeVariableDetails typeVariable) {
        ClassDetails classDetails = parameterizedType.getRawClassDetails();
        TypeDetails typeArgument = TypeDetailsHelper.findMatchingTypeArgument(classDetails.getTypeParameters(), parameterizedType.getArguments(), typeVariable.getIdentifier());
        if (typeArgument == null || classDetails != typeVariable.getDeclaringType()) {
            TypeDetails resolvedType;
            TypeDetails genericSuper = classDetails.getGenericSuperType();
            TypeDetails typeDetails = resolvedType = genericSuper != null ? genericSuper.resolveTypeVariable(typeVariable) : null;
            if (typeArgument == null || resolvedType != null && resolvedType.getTypeKind() != TypeDetails.Kind.TYPE_VARIABLE) {
                return resolvedType;
            }
        }
        return typeArgument;
    }

    private static TypeDetails findMatchingTypeArgument(List<TypeVariableDetails> typeParameters, List<TypeDetails> typeArguments, String identifier) {
        assert (typeParameters.size() == typeArguments.size());
        for (int i = 0; i < typeParameters.size(); ++i) {
            TypeVariableDetails typeParameter = typeParameters.get(i);
            if (!typeParameter.getIdentifier().equals(identifier)) continue;
            return typeArguments.get(i);
        }
        return null;
    }

    public static ArrayTypeDetails arrayOf(TypeDetails constituentType, SourceModelBuildingContext buildingContext) {
        ClassDetails arrayClassDetails;
        if (constituentType.getTypeKind() == TypeDetails.Kind.PRIMITIVE) {
            PrimitiveTypeDetails primitiveType = constituentType.asPrimitiveType();
            PrimitiveKind primitiveKind = primitiveType.getPrimitiveKind();
            arrayClassDetails = buildingContext.getClassDetailsRegistry().resolveClassDetails("[" + primitiveKind.getJavaTypeChar());
        } else {
            ClassDetails rawComponentType = constituentType.determineRawClass();
            String arrayClassName = "[L" + rawComponentType.getName().replace('.', '/') + ";";
            arrayClassDetails = buildingContext.getClassDetailsRegistry().resolveClassDetails(arrayClassName);
        }
        return new ArrayTypeDetailsImpl(arrayClassDetails, constituentType);
    }
}

