/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.UnknownAnnotationAttributeException;
import org.hibernate.models.internal.AnnotationProxy;
import org.hibernate.models.serial.internal.SerialAnnotationDescriptorImpl;
import org.hibernate.models.serial.spi.SerialAnnotationDescriptor;
import org.hibernate.models.serial.spi.Storable;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

public interface AnnotationDescriptor<A extends Annotation>
extends AnnotationTarget,
Storable<AnnotationDescriptor<A>, SerialAnnotationDescriptor<A>> {
    @Override
    default public AnnotationTarget.Kind getKind() {
        return AnnotationTarget.Kind.ANNOTATION;
    }

    public Class<A> getAnnotationType();

    default public <S> S as(Class<S> type) {
        return (S)type;
    }

    @Override
    default public ClassDetails getContainer(SourceModelBuildingContext modelBuildingContext) {
        ClassDetails annotationClassDetails = modelBuildingContext.getClassDetailsRegistry().resolveClassDetails(this.getAnnotationType().getName());
        return annotationClassDetails.getContainer(modelBuildingContext);
    }

    public A createUsage(SourceModelBuildingContext var1);

    public A createUsage(A var1, SourceModelBuildingContext var2);

    default public A createUsage(Map<String, Object> attributeValues, SourceModelBuildingContext context) {
        return AnnotationProxy.makeProxy(this, attributeValues);
    }

    public EnumSet<AnnotationTarget.Kind> getAllowableTargets();

    public boolean isInherited();

    default public boolean isRepeatable() {
        return this.getRepeatableContainer() != null;
    }

    public AnnotationDescriptor<?> getRepeatableContainer();

    public List<AttributeDescriptor<?>> getAttributes();

    default public <V> AttributeDescriptor<V> findAttribute(String name) {
        List<AttributeDescriptor<?>> attributeDescriptors = this.getAttributes();
        for (AttributeDescriptor<?> attributeDescriptor : attributeDescriptors) {
            if (!attributeDescriptor.getName().equals(name)) continue;
            return attributeDescriptor;
        }
        return null;
    }

    default public <V> AttributeDescriptor<V> getAttribute(String name) {
        AttributeDescriptor<V> attribute = this.findAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        throw new UnknownAnnotationAttributeException(this.getAnnotationType(), name);
    }

    default public <X extends Annotation> AnnotationDescriptor<X> asAnnotationDescriptor() {
        return this;
    }

    @Override
    default public ClassDetails asClassDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to a ClassDetails");
    }

    @Override
    default public MemberDetails asMemberDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to a MemberDetails");
    }

    @Override
    default public FieldDetails asFieldDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to a FieldDetails");
    }

    @Override
    default public MethodDetails asMethodDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to a MethodDetails");
    }

    @Override
    default public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to a RecordComponentDetails");
    }

    @Override
    default public SerialAnnotationDescriptor<A> toStorableForm() {
        return new SerialAnnotationDescriptorImpl<A>(this.getAnnotationType());
    }
}

