/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.serial.internal;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.serial.internal.RestoredModelContext;
import org.hibernate.models.serial.spi.SerialAnnotationDescriptor;
import org.hibernate.models.serial.spi.SerialClassDetails;
import org.hibernate.models.serial.spi.StorableContext;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.SourceModelContext;

public class StorableContextImpl
implements StorableContext {
    private final LinkedHashMap<String, SerialClassDetails> serialClassDetailsMap;
    private final LinkedHashMap<Class<? extends Annotation>, SerialAnnotationDescriptor<? extends Annotation>> serialAnnotationDescriptorMap;

    public StorableContextImpl(Map<String, ClassDetails> classDetailsMap, Map<Class<? extends Annotation>, AnnotationDescriptor<? extends Annotation>> annotationDescriptorMap) {
        this.serialClassDetailsMap = CollectionHelper.linkedMapOfSize(classDetailsMap.size());
        this.serialAnnotationDescriptorMap = CollectionHelper.linkedMapOfSize(annotationDescriptorMap.size());
        for (Map.Entry<String, ClassDetails> entry : classDetailsMap.entrySet()) {
            this.serialClassDetailsMap.put(entry.getKey(), (SerialClassDetails)entry.getValue().toStorableForm());
        }
        for (Map.Entry<Object, AnnotationTarget> entry : annotationDescriptorMap.entrySet()) {
            this.serialAnnotationDescriptorMap.put((Class)entry.getKey(), (SerialAnnotationDescriptor<? extends Annotation>)((AnnotationDescriptor)entry.getValue()).toStorableForm());
        }
    }

    @Override
    public SourceModelContext fromStorableForm(ClassLoading classLoading) {
        return new RestoredModelContext(this, classLoading);
    }

    public LinkedHashMap<String, SerialClassDetails> getSerialClassDetailsMap() {
        return this.serialClassDetailsMap;
    }

    public LinkedHashMap<Class<? extends Annotation>, SerialAnnotationDescriptor<? extends Annotation>> getSerialAnnotationDescriptorMap() {
        return this.serialAnnotationDescriptorMap;
    }
}

