/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.serial.internal;

import java.util.Map;
import org.hibernate.models.internal.AnnotationDescriptorRegistryStandard;
import org.hibernate.models.internal.ClassDetailsRegistryStandard;
import org.hibernate.models.internal.MutableAnnotationDescriptorRegistry;
import org.hibernate.models.internal.MutableClassDetailsRegistry;
import org.hibernate.models.serial.internal.ClassDetailsBuilderImpl;
import org.hibernate.models.serial.internal.StorableContextImpl;
import org.hibernate.models.serial.spi.SerialAnnotationDescriptor;
import org.hibernate.models.serial.spi.SerialClassDetails;
import org.hibernate.models.serial.spi.StorableContext;
import org.hibernate.models.serial.spi.StorableForm;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class RestoredModelContext
implements SourceModelBuildingContext {
    private final MutableAnnotationDescriptorRegistry annotationDescriptorRegistry;
    private final MutableClassDetailsRegistry classDetailsRegistry;
    private ClassLoading classLoading;

    public RestoredModelContext(StorableContextImpl serialContext, ClassLoading classLoading) {
        this.classLoading = classLoading;
        ClassDetailsBuilderImpl classDetailsBuilder = new ClassDetailsBuilderImpl(serialContext, classLoading);
        this.annotationDescriptorRegistry = new AnnotationDescriptorRegistryStandard(this);
        this.classDetailsRegistry = new ClassDetailsRegistryStandard(classDetailsBuilder, this);
        for (Map.Entry<String, SerialClassDetails> entry : serialContext.getSerialClassDetailsMap().entrySet()) {
            this.classDetailsRegistry.resolveClassDetails(entry.getKey());
        }
        for (Map.Entry<Object, StorableForm<ClassDetails>> entry : serialContext.getSerialAnnotationDescriptorMap().entrySet()) {
            SerialAnnotationDescriptor serialDescriptor = (SerialAnnotationDescriptor)entry.getValue();
            this.annotationDescriptorRegistry.register((AnnotationDescriptor)serialDescriptor.fromStorableForm(this));
        }
        classLoading = null;
        classDetailsBuilder.invalidate();
    }

    @Override
    public ClassLoading getClassLoading() {
        return this.classLoading;
    }

    @Override
    public AnnotationDescriptorRegistry getAnnotationDescriptorRegistry() {
        return this.annotationDescriptorRegistry;
    }

    @Override
    public ClassDetailsRegistry getClassDetailsRegistry() {
        return this.classDetailsRegistry;
    }

    @Override
    public StorableContext toStorableForm() {
        throw new UnsupportedOperationException();
    }
}

