/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import org.hibernate.models.spi.JdkValueConverter;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueTypeDescriptor;

public class JdkArrayValueConverter<V>
implements JdkValueConverter<V[]> {
    private final ValueTypeDescriptor<V> elementTypeDescriptor;

    public JdkArrayValueConverter(ValueTypeDescriptor<V> elementTypeDescriptor) {
        this.elementTypeDescriptor = elementTypeDescriptor;
    }

    @Override
    public V[] convert(V[] rawValue, SourceModelBuildingContext modelContext) {
        V[] result = this.elementTypeDescriptor.makeArray(rawValue.length, modelContext);
        JdkValueConverter<V> elementWrapper = this.elementTypeDescriptor.createJdkValueConverter(modelContext);
        for (int i = 0; i < rawValue.length; ++i) {
            result[i] = elementWrapper.convert(rawValue[i], modelContext);
        }
        return result;
    }
}

