/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.models.internal.AbstractAnnotationDescriptor;
import org.hibernate.models.internal.AnnotationDescriptorBuilding;
import org.hibernate.models.internal.AnnotationHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class StandardAnnotationDescriptor<A extends Annotation>
extends AbstractAnnotationDescriptor<A> {
    private final List<AttributeDescriptor<?>> attributeDescriptors;
    private final SourceModelBuildingContext buildingContext;
    private Map<Class<? extends Annotation>, ? extends Annotation> usagesMap;

    public StandardAnnotationDescriptor(Class<A> annotationType, SourceModelBuildingContext buildingContext) {
        this(annotationType, null, buildingContext);
    }

    public StandardAnnotationDescriptor(Class<A> annotationType, AnnotationDescriptor<?> repeatableContainer, SourceModelBuildingContext buildingContext) {
        super(annotationType, AnnotationHelper.extractTargets(annotationType), AnnotationHelper.isInherited(annotationType), repeatableContainer);
        this.buildingContext = buildingContext;
        this.attributeDescriptors = AnnotationDescriptorBuilding.extractAttributeDescriptors(annotationType);
    }

    @Override
    public Map<Class<? extends Annotation>, ? extends Annotation> getUsageMap() {
        if (this.usagesMap == null) {
            this.usagesMap = StandardAnnotationDescriptor.buildUsagesMap(this.getAnnotationType(), this.buildingContext);
        }
        return this.usagesMap;
    }

    @Override
    public A createUsage(A jdkAnnotation, SourceModelBuildingContext context) {
        return jdkAnnotation;
    }

    @Override
    public A createUsage(SourceModelBuildingContext context) {
        throw new UnsupportedOperationException("Creating empty annotation usage mot supported from StandardAnnotationDescriptor : " + this.getAnnotationType().getName());
    }

    @Override
    public List<AttributeDescriptor<?>> getAttributes() {
        return this.attributeDescriptors;
    }

    private static <A extends Annotation> Map<Class<? extends Annotation>, ? extends Annotation> buildUsagesMap(Class<A> annotationType, SourceModelBuildingContext buildingContext) {
        HashMap<Class<? extends Annotation>, Annotation> result = new HashMap<Class<? extends Annotation>, Annotation>();
        AnnotationDescriptorRegistry annotationDescriptorRegistry = buildingContext.getAnnotationDescriptorRegistry();
        Annotation[] annotationTypeAnnotations = annotationType.getAnnotations();
        for (int i = 0; i < annotationTypeAnnotations.length; ++i) {
            Annotation annotationTypeAnnotation = annotationTypeAnnotations[i];
            Class<? extends Annotation> annotationTypeAnnotationType = annotationTypeAnnotation.annotationType();
            if (annotationTypeAnnotationType == Repeatable.class || annotationTypeAnnotationType == Target.class || annotationTypeAnnotationType == Retention.class || annotationTypeAnnotationType == Documented.class) continue;
            AnnotationDescriptor<? extends Annotation> annotationDescriptor = annotationDescriptorRegistry.getDescriptor(annotationTypeAnnotationType);
            Annotation annotationTypeAnnotationUsage = annotationDescriptor.createUsage(annotationTypeAnnotation, buildingContext);
            result.put(annotationTypeAnnotationType, annotationTypeAnnotationUsage);
        }
        return result;
    }
}

