/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import org.hibernate.models.spi.ClassDetails;

public enum PrimitiveKind {
    BOOLEAN('Z', Boolean.TYPE),
    BYTE('B', Byte.TYPE),
    CHAR('C', Character.TYPE),
    SHORT('S', Short.TYPE),
    INT('I', Integer.TYPE),
    LONG('J', Long.TYPE),
    DOUBLE('D', Double.TYPE),
    FLOAT('F', Float.TYPE);

    private final char javaTypeChar;
    private final Class<?> javaType;

    private PrimitiveKind(char javaTypeChar, Class<?> javaType) {
        this.javaTypeChar = javaTypeChar;
        this.javaType = javaType;
    }

    public char getJavaTypeChar() {
        return this.javaTypeChar;
    }

    public String getTypeName() {
        return this.javaType.getName();
    }

    public static PrimitiveKind resolveFromTypeChar(char javaTypeChar) {
        for (PrimitiveKind primitiveKind : PrimitiveKind.values()) {
            if (primitiveKind.javaTypeChar != javaTypeChar) continue;
            return primitiveKind;
        }
        throw new IllegalArgumentException("Unknown primitive Java type character - " + javaTypeChar);
    }

    public static PrimitiveKind resolveFromClassDetails(ClassDetails classDetails) {
        for (PrimitiveKind primitiveKind : PrimitiveKind.values()) {
            if (!primitiveKind.javaType.equals(classDetails.toJavaClass())) continue;
            return primitiveKind;
        }
        throw new IllegalArgumentException("Unknown primitive class - " + classDetails);
    }
}

