/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.models.internal.AnnotationUsageHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

public interface AnnotationTargetSupport
extends MutableAnnotationTarget {
    public Map<Class<? extends Annotation>, ? extends Annotation> getUsageMap();

    @Override
    default public void clearAnnotationUsages() {
        this.getUsageMap().clear();
    }

    @Override
    default public <X extends Annotation> void addAnnotationUsage(X annotationUsage) {
        this.getUsageMap().put(annotationUsage.annotationType(), annotationUsage);
    }

    @Override
    default public <X extends Annotation> void removeAnnotationUsage(AnnotationDescriptor<X> annotationType) {
        this.getUsageMap().remove(annotationType.getAnnotationType());
    }

    @Override
    default public Collection<? extends Annotation> getDirectAnnotationUsages() {
        return this.getUsageMap().values();
    }

    @Override
    default public <A extends Annotation> A getDirectAnnotationUsage(AnnotationDescriptor<A> descriptor) {
        return this.getDirectAnnotationUsage(descriptor.getAnnotationType());
    }

    @Override
    default public <A extends Annotation> A getDirectAnnotationUsage(Class<A> type) {
        return (A)this.getUsageMap().get(type);
    }

    @Override
    default public <A extends Annotation> boolean hasDirectAnnotationUsage(Class<A> type) {
        return this.getUsageMap().containsKey(type);
    }

    default public <X extends Annotation> boolean hasAnnotationUsage(Class<X> type, SourceModelBuildingContext modelContext) {
        boolean containsDirectly = this.getUsageMap().containsKey(type);
        if (containsDirectly) {
            return true;
        }
        AnnotationDescriptor<X> descriptor = modelContext.getAnnotationDescriptorRegistry().getDescriptor(type);
        if (descriptor.isRepeatable()) {
            return this.getUsageMap().containsKey(descriptor.getRepeatableContainer().getAnnotationType());
        }
        return false;
    }

    @Override
    default public <A extends Annotation> A getAnnotationUsage(AnnotationDescriptor<A> descriptor, SourceModelBuildingContext modelContext) {
        return AnnotationUsageHelper.getUsage(descriptor, this.getUsageMap(), modelContext);
    }

    @Override
    default public <A extends Annotation> A getAnnotationUsage(Class<A> annotationType, SourceModelBuildingContext modelContext) {
        return AnnotationUsageHelper.getUsage(annotationType, this.getUsageMap(), modelContext);
    }

    @Override
    default public <A extends Annotation> A[] getRepeatedAnnotationUsages(AnnotationDescriptor<A> type, SourceModelBuildingContext modelContext) {
        return AnnotationUsageHelper.getRepeatedUsages(type, this.getUsageMap(), (SourceModelBuildingContext)modelContext);
    }

    @Override
    default public <A extends Annotation, C extends Annotation> void forEachRepeatedAnnotationUsages(Class<A> repeatableType, Class<C> containerType, SourceModelBuildingContext modelContext, Consumer<A> consumer) {
        AnnotationUsageHelper.forEachRepeatedAnnotationUsages(repeatableType, containerType, consumer, this.getUsageMap(), modelContext);
    }

    @Override
    default public <A extends Annotation, C extends Annotation> void forEachRepeatedAnnotationUsages(AnnotationDescriptor<A> repeatableDescriptor, SourceModelBuildingContext modelContext, Consumer<A> consumer) {
        AnnotationUsageHelper.forEachRepeatedAnnotationUsages(repeatableDescriptor, consumer, this.getUsageMap(), modelContext);
    }

    @Override
    default public <A extends Annotation> A locateAnnotationUsage(Class<A> annotationType, SourceModelBuildingContext modelContext) {
        A localUsage = this.getAnnotationUsage(annotationType, modelContext);
        if (localUsage != null) {
            return localUsage;
        }
        Map<Class<? extends Annotation>, ? extends Annotation> localUsageMap = this.getUsageMap();
        for (Map.Entry<Class<? extends Annotation>, ? extends Annotation> usageEntry : localUsageMap.entrySet()) {
            AnnotationDescriptor<? extends Annotation> usageDescriptor;
            A metaAnnotation;
            Annotation usage = usageEntry.getValue();
            if (annotationType.equals(usage.annotationType()) || (metaAnnotation = (usageDescriptor = modelContext.getAnnotationDescriptorRegistry().getDescriptor(usage.annotationType())).getDirectAnnotationUsage(annotationType)) == null) continue;
            return metaAnnotation;
        }
        return null;
    }

    @Override
    default public <A extends Annotation> List<? extends Annotation> getMetaAnnotated(Class<A> metaAnnotationType, SourceModelBuildingContext modelContext) {
        ArrayList usages = new ArrayList();
        this.forEachDirectAnnotationUsage(usage -> {
            Object metaUsage = usage.annotationType().getAnnotation(metaAnnotationType);
            if (metaUsage != null) {
                usages.add(usage);
            }
        });
        return usages;
    }

    @Override
    default public <X extends Annotation> X getNamedAnnotationUsage(Class<X> type, String matchName, SourceModelBuildingContext modelContext) {
        return this.getNamedAnnotationUsage(modelContext.getAnnotationDescriptorRegistry().getDescriptor(type), matchName, modelContext);
    }

    @Override
    default public <X extends Annotation> X getNamedAnnotationUsage(AnnotationDescriptor<X> type, String matchName, String attributeToMatch, SourceModelBuildingContext modelContext) {
        return AnnotationUsageHelper.getNamedUsage(type, matchName, attributeToMatch, this.getUsageMap(), modelContext);
    }

    @Override
    default public <X extends Annotation> X getNamedAnnotationUsage(Class<X> type, String matchName, String attributeToMatch, SourceModelBuildingContext modelContext) {
        return this.getNamedAnnotationUsage(modelContext.getAnnotationDescriptorRegistry().getDescriptor(type), matchName, attributeToMatch, modelContext);
    }

    @Override
    default public <S extends Annotation, P extends Annotation> P replaceAnnotationUsage(AnnotationDescriptor<S> repeatableType, AnnotationDescriptor<P> containerType, SourceModelBuildingContext modelContext) {
        if (!1.$assertionsDisabled && !repeatableType.isRepeatable()) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && repeatableType.getRepeatableContainer() != containerType) {
            throw new AssertionError();
        }
        P containerTypeUsage = containerType.createUsage(modelContext);
        this.getUsageMap().put((Class<? extends Annotation>)containerType.getAnnotationType(), (Annotation)containerTypeUsage);
        this.getUsageMap().remove(repeatableType.getAnnotationType());
        return containerTypeUsage;
    }

    @Override
    default public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        return null;
    }

    @Override
    public FieldDetails asFieldDetails();

    @Override
    public MethodDetails asMethodDetails();

    @Override
    public RecordComponentDetails asRecordComponentDetails();

    @Override
    public MutableClassDetails asClassDetails();

    @Override
    public MutableMemberDetails asMemberDetails();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

