/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.models.internal.MissingPackageInfoDetails;
import org.hibernate.models.internal.MutableClassDetailsRegistry;
import org.hibernate.models.internal.jdk.JdkClassDetails;
import org.hibernate.models.internal.util.StringHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class AnnotationTargetHelper {
    public static ClassDetails resolvePackageInfo(ClassDetails classDetails, SourceModelBuildingContext modelBuildingContext) {
        if (classDetails.getClassName() == null) {
            return null;
        }
        String containingPackageName = AnnotationTargetHelper.determineContainingPackageName(classDetails);
        if (containingPackageName == null) {
            return null;
        }
        String packageInfoClassName = containingPackageName + ".package-info";
        return modelBuildingContext.getClassDetailsRegistry().as(MutableClassDetailsRegistry.class).resolveClassDetails(packageInfoClassName, name -> {
            Class packageInfoClass = modelBuildingContext.getClassLoading().findClassForName(packageInfoClassName);
            if (packageInfoClass == null) {
                return new MissingPackageInfoDetails(containingPackageName, packageInfoClassName);
            }
            return new JdkClassDetails(packageInfoClass, modelBuildingContext);
        });
    }

    public static String determineContainingPackageName(ClassDetails classDetails) {
        String className = classDetails.getClassName();
        assert (className != null);
        String classNameNamespace = StringHelper.qualifier(className);
        if (className.endsWith("package-info")) {
            return classNameNamespace.indexOf(46) > 1 ? StringHelper.qualifier(classNameNamespace) : null;
        }
        return classNameNamespace;
    }

    private AnnotationTargetHelper() {
    }

    public static void walkContainers(AnnotationTarget annotationTarget, boolean crossPackageBoundaries, SourceModelBuildingContext modelContext, Consumer<ClassDetails> consumer) {
        if (AnnotationTargetHelper.isPackage(annotationTarget) && !crossPackageBoundaries) {
            return;
        }
        ClassDetails container = annotationTarget.getContainer(modelContext);
        if (container == null) {
            return;
        }
        consumer.accept(container);
        container.walkContainers(crossPackageBoundaries, modelContext, consumer);
    }

    private static boolean isPackage(AnnotationTarget annotationTarget) {
        if (annotationTarget.getKind() == AnnotationTarget.Kind.PACKAGE) {
            return true;
        }
        return annotationTarget.getKind() == AnnotationTarget.Kind.CLASS && annotationTarget.getName().endsWith(".package-info");
    }

    public static void walkSelfAndContainers(AnnotationTarget self, boolean crossPackageBoundaries, SourceModelBuildingContext modelContext, Consumer<AnnotationTarget> consumer) {
        if (self == null) {
            return;
        }
        consumer.accept(self);
        self.walkContainers(crossPackageBoundaries, modelContext, consumer::accept);
    }

    public static <T> T fromContainers(AnnotationTarget annotationTarget, boolean crossPackageBoundaries, SourceModelBuildingContext modelContext, Function<ClassDetails, T> matchingExtractor) {
        if (AnnotationTargetHelper.isPackage(annotationTarget) && !crossPackageBoundaries) {
            return null;
        }
        ClassDetails container = annotationTarget.getContainer(modelContext);
        T matchedExtraction = matchingExtractor.apply(container);
        if (matchedExtraction != null) {
            return matchedExtraction;
        }
        return container.fromContainers(crossPackageBoundaries, modelContext, matchingExtractor);
    }

    public static <T> T fromSelfAndContainers(AnnotationTarget self, boolean crossPackageBoundaries, SourceModelBuildingContext modelContext, Function<AnnotationTarget, T> matchingExtractor) {
        if (self == null) {
            return null;
        }
        T fromSelf = matchingExtractor.apply(self);
        if (fromSelf != null) {
            return fromSelf;
        }
        return (T)self.fromContainers(crossPackageBoundaries, modelContext, matchingExtractor::apply);
    }
}

