/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import org.hibernate.models.internal.BaseLineJavaTypes;
import org.hibernate.models.internal.MutableAnnotationDescriptorRegistry;
import org.hibernate.models.internal.MutableClassDetailsRegistry;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.RegistryPrimer;
import org.hibernate.models.spi.SourceModelBuildingContext;

public abstract class AbstractModelBuildingContext
implements SourceModelBuildingContext {
    private final ClassLoading classLoadingAccess;

    public AbstractModelBuildingContext(ClassLoading classLoadingAccess) {
        this.classLoadingAccess = classLoadingAccess;
    }

    @Override
    public abstract MutableAnnotationDescriptorRegistry getAnnotationDescriptorRegistry();

    @Override
    public abstract MutableClassDetailsRegistry getClassDetailsRegistry();

    @Override
    public ClassLoading getClassLoading() {
        return this.classLoadingAccess;
    }

    protected void primeRegistries(RegistryPrimer registryPrimer) {
        BaseLineJavaTypes.forEachJavaType(this::primeClassDetails);
        if (registryPrimer != null) {
            registryPrimer.primeRegistries(new RegistryContributions(), this);
        }
    }

    private void primeClassDetails(Class<?> javaType) {
        this.getClassDetailsRegistry().resolveClassDetails(javaType.getName());
    }

    private <A extends Annotation> void primeAnnotation(AnnotationDescriptor<A> descriptor) {
        this.getAnnotationDescriptorRegistry().register(descriptor);
        this.primeClassDetails(descriptor.getAnnotationType());
    }

    private class RegistryContributions
    implements RegistryPrimer.Contributions {
        private RegistryContributions() {
        }

        @Override
        public <A extends Annotation> void registerAnnotation(AnnotationDescriptor<A> descriptor) {
            AbstractModelBuildingContext.this.primeAnnotation(descriptor);
        }

        @Override
        public void registerClass(ClassDetails details) {
            AbstractModelBuildingContext.this.getClassDetailsRegistry().addClassDetails(details);
        }
    }
}

