/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.EnumSet;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.internal.AbstractAnnotationTarget;
import org.hibernate.models.internal.AnnotationUsageHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

public abstract class AbstractAnnotationDescriptor<A extends Annotation>
extends AbstractAnnotationTarget
implements AnnotationDescriptor<A> {
    private final Class<A> annotationType;
    private final EnumSet<AnnotationTarget.Kind> allowableTargets;
    private final boolean inherited;
    private final AnnotationDescriptor<?> repeatableContainer;

    public AbstractAnnotationDescriptor(Class<A> annotationType, EnumSet<AnnotationTarget.Kind> allowableTargets, boolean inherited, AnnotationDescriptor<?> repeatableContainer) {
        this.annotationType = annotationType;
        this.allowableTargets = allowableTargets;
        this.inherited = inherited;
        this.repeatableContainer = repeatableContainer;
    }

    @Override
    public Class<A> getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public String getName() {
        return this.annotationType.getName();
    }

    @Override
    public EnumSet<AnnotationTarget.Kind> getAllowableTargets() {
        return this.allowableTargets;
    }

    @Override
    public boolean isInherited() {
        return this.inherited;
    }

    @Override
    public AnnotationDescriptor<?> getRepeatableContainer() {
        return this.repeatableContainer;
    }

    @Override
    public Collection<? extends Annotation> getDirectAnnotationUsages() {
        return this.getUsageMap().values();
    }

    public <X extends Annotation> X[] getRepeatedAnnotationUsages(AnnotationDescriptor<X> type, SourceModelBuildingContext modelContext) {
        return AnnotationUsageHelper.getRepeatedUsages(type, this.getUsageMap(), (SourceModelBuildingContext)modelContext);
    }

    public <X extends Annotation> X[] getRepeatedAnnotationUsages(Class<X> type, SourceModelBuildingContext modelContext) {
        return this.getRepeatedAnnotationUsages(modelContext.getAnnotationDescriptorRegistry().getDescriptor(type), modelContext);
    }

    @Override
    public <X extends Annotation> AnnotationDescriptor<X> asAnnotationDescriptor() {
        return this;
    }

    @Override
    public MutableClassDetails asClassDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to ClassDetails");
    }

    @Override
    public MutableMemberDetails asMemberDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to MemberDetails");
    }

    @Override
    public FieldDetails asFieldDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to FieldDetails");
    }

    @Override
    public MethodDetails asMethodDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to MethodDetails");
    }

    @Override
    public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to RecordComponentDetails");
    }
}

