/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.hbase.async.Bytes;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.RegionClient;
import org.hbase.async.RegionInfo;
import org.hbase.async.RpcTimedOutException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.CharsetUtil;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HBaseRpc {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseRpc.class);
    private boolean trace_rpc;
    static final byte RPC_SUCCESS = 0;
    static final byte RPC_ERROR = 1;
    static final byte RPC_FRAMED = 2;
    static final byte RPC_FATAL = -1;
    private Deferred<Object> deferred;
    final byte[] table;
    final byte[] key;
    RegionInfo region;
    byte attempt;
    private int timeout = -1;
    Timeout timeout_handle;
    private TimerTask timeout_task;
    private boolean has_timedout;
    boolean failfast = false;
    int rpc_id;
    private RegionClient region_client;
    boolean probe = false;
    private boolean suspended_probe = false;
    static final long MAX_BYTE_ARRAY_MASK = -268435456L;

    public boolean isTraceRPC() {
        return this.trace_rpc;
    }

    public void setTraceRPC(boolean trace_rpc) {
        this.trace_rpc = trace_rpc;
    }

    abstract ChannelBuffer serialize(byte var1);

    abstract Object deserialize(ChannelBuffer var1, int var2);

    static void ensureNoCell(int cell_size) {
        if (cell_size != 0) {
            throw new InvalidResponseException("Should not have gotten any cell blocks, yet there are " + cell_size + " bytes that follow the protobuf response." + "  This should never happen." + "  Are you using an incompatible version of HBase?", null);
        }
    }

    public final boolean setFailfast(boolean failfast) {
        this.failfast = failfast;
        return this.failfast;
    }

    public final boolean failfast() {
        return this.failfast;
    }

    public boolean isProbe() {
        return this.probe;
    }

    public void setProbe(boolean probe) {
        this.probe = probe;
    }

    boolean isSuspendedProbe() {
        return this.suspended_probe;
    }

    void setSuspendedProbe(boolean suspended_probe) {
        this.suspended_probe = suspended_probe;
    }

    HBaseRpc() {
        this.table = null;
        this.key = null;
    }

    HBaseRpc(byte[] table, byte[] key) {
        KeyValue.checkTable(table);
        KeyValue.checkKey(key);
        this.table = table;
        this.key = key;
    }

    public void setTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("The timeout cannot be negative");
        }
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    abstract byte[] method(byte var1);

    final void setRegion(RegionInfo region) {
        if (this.table == null) {
            throw new AssertionError((Object)"Can't use setRegion if no table was given.");
        }
        this.region = region;
    }

    final RegionInfo getRegion() {
        return this.region;
    }

    final Deferred<Object> getDeferred() {
        if (this.deferred == null) {
            this.deferred = new Deferred();
        }
        return this.deferred;
    }

    void enqueueTimeout(RegionClient region_client) {
        if (this.has_timedout) {
            throw new IllegalStateException("This RPC has already timed out " + this);
        }
        if (this.timeout == -1) {
            this.timeout = region_client.getHBaseClient().getDefaultRpcTimeout();
        }
        if (this.timeout > 0) {
            this.region_client = region_client;
            if (this.timeout_task == null) {
                this.timeout_task = new TimeoutTask();
            }
            try {
                if (this.timeout_handle != null) {
                    LOG.warn("RPC " + this + " had a previous timeout task");
                }
                this.timeout_handle = region_client.getHBaseClient().getRpcTimeoutTimer().newTimeout(this.timeout_task, (long)this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (IllegalStateException e) {
                LOG.warn("Failed to schedule RPC timeout: " + this + "  Ignore this if we're shutting down.", (Throwable)e);
                this.timeout_handle = null;
            }
        }
    }

    final synchronized boolean hasTimedOut() {
        return this.has_timedout;
    }

    final void callback(Object result) {
        Deferred<Object> d;
        if (this.timeout_handle != null) {
            this.timeout_handle.cancel();
            this.timeout_task = null;
            this.timeout_handle = null;
        }
        if ((d = this.deferred) == null) {
            return;
        }
        this.deferred = null;
        this.attempt = 0;
        d.callback(result);
    }

    final boolean hasDeferred() {
        return this.deferred != null;
    }

    public String toString() {
        String method = new String(this.method((byte)0));
        StringBuilder buf = new StringBuilder(16 + method.length() + 2 + 8 + (this.table == null ? 4 : this.table.length + 2) + 6 + (this.key == null ? 4 : this.key.length * 2) + 9 + (this.region == null ? 4 : this.region.stringSizeHint()) + 10 + 1 + 1);
        buf.append("HBaseRpc(method=");
        buf.append(method);
        buf.append(", table=");
        Bytes.pretty(buf, this.table);
        buf.append(", key=");
        Bytes.pretty(buf, this.key);
        buf.append(", region=");
        if (this.region == null) {
            buf.append("null");
        } else {
            this.region.toStringbuf(buf);
        }
        buf.append(", attempt=").append(this.attempt).append(", timeout=").append(this.timeout).append(", hasTimedout=").append(this.has_timedout);
        buf.append(')');
        return buf.toString();
    }

    final String toStringWithQualifiers(String classname, byte[] family, byte[][] qualifiers) {
        return this.toStringWithQualifiers(classname, family, qualifiers, null, "");
    }

    final String toStringWithQualifiers(String classname, byte[] family, byte[][] qualifiers, byte[][] values, String fields) {
        StringBuilder buf = new StringBuilder(256 + fields.length());
        buf.append(classname).append("(table=");
        Bytes.pretty(buf, this.table);
        buf.append(", key=");
        Bytes.pretty(buf, this.key);
        buf.append(", family=");
        Bytes.pretty(buf, family);
        buf.append(", qualifiers=");
        Bytes.pretty(buf, qualifiers);
        if (values != null) {
            buf.append(", values=");
            Bytes.pretty(buf, values);
        }
        buf.append(fields);
        buf.append(", attempt=").append(this.attempt).append(", region=");
        if (this.region == null) {
            buf.append("null");
        } else {
            this.region.toStringbuf(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    final String toStringWithQualifier(String classname, byte[] family, byte[] qualifier, String fields) {
        StringBuilder buf = new StringBuilder(256 + fields.length());
        buf.append(classname).append("(table=");
        Bytes.pretty(buf, this.table);
        buf.append(", key=");
        Bytes.pretty(buf, this.key);
        buf.append(", family=");
        Bytes.pretty(buf, family);
        buf.append(", qualifier=");
        Bytes.pretty(buf, qualifier);
        buf.append(fields);
        buf.append(", attempt=").append(this.attempt).append(", region=");
        if (this.region == null) {
            buf.append("null");
        } else {
            this.region.toStringbuf(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    final ChannelBuffer newBuffer(byte server_version, int max_payload_size) {
        int header = 10 + this.method(server_version).length + (server_version < 29 ? 0 : 13);
        ChannelBuffer buf = ChannelBuffers.buffer((int)(header + max_payload_size));
        buf.setIndex(0, header);
        return buf;
    }

    static final ChannelBuffer toChannelBuffer(byte[] method, AbstractMessageLite pb) {
        int pblen = pb.getSerializedSize();
        int vlen = CodedOutputStream.computeRawVarint32Size((int)pblen);
        byte[] buf = new byte[23 + method.length + vlen + pblen];
        try {
            CodedOutputStream out = CodedOutputStream.newInstance((byte[])buf, (int)(23 + method.length), (int)(vlen + pblen));
            out.writeRawVarint32(pblen);
            pb.writeTo(out);
            out.checkNoSpaceLeft();
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen", e);
        }
        return ChannelBuffers.wrappedBuffer((byte[])buf);
    }

    static void writeHBaseBool(ChannelBuffer buf, boolean b) {
        buf.writeByte(1);
        buf.writeByte(b ? 1 : 0);
    }

    static void writeHBaseInt(ChannelBuffer buf, int v) {
        buf.writeByte(5);
        buf.writeInt(v);
    }

    static void writeHBaseLong(ChannelBuffer buf, long v) {
        buf.writeByte(6);
        buf.writeLong(v);
    }

    static void writeHBaseString(ChannelBuffer buf, String s) {
        buf.writeByte(10);
        byte[] b = s.getBytes(CharsetUtil.UTF_8);
        HBaseRpc.writeVLong(buf, b.length);
        buf.writeBytes(b);
    }

    static void writeHBaseByteArray(ChannelBuffer buf, byte[] b) {
        buf.writeByte(11);
        HBaseRpc.writeByteArray(buf, b);
    }

    static void writeByteArray(ChannelBuffer buf, byte[] b) {
        HBaseRpc.writeVLong(buf, b.length);
        buf.writeBytes(b);
    }

    static void writeHBaseNull(ChannelBuffer buf) {
        buf.writeByte(14);
        buf.writeByte(17);
        buf.writeByte(14);
    }

    static void checkArrayLength(ChannelBuffer buf, long length) {
        if ((length & 0xFFFFFFFFF0000000L) != 0L) {
            if (length < 0L) {
                throw new IllegalArgumentException("Read negative byte array length: " + length + " in buf=" + buf + '=' + Bytes.pretty(buf));
            }
            throw new IllegalArgumentException("Read byte array length that's too large: " + length + " > " + 0xFFFFFFFL + " in buf=" + buf + '=' + Bytes.pretty(buf));
        }
    }

    static void checkArrayLength(byte[] array) {
        if (((long)array.length & 0xFFFFFFFFF0000000L) != 0L) {
            if (array.length < 0) {
                throw new AssertionError((Object)("Negative byte array length: " + array.length + ' ' + Bytes.pretty(array)));
            }
            throw new IllegalArgumentException("Byte array length too big: " + array.length + " > " + 0xFFFFFFFL);
        }
    }

    static void checkNonEmptyArrayLength(ChannelBuffer buf, long length) {
        if (length == 0L) {
            throw new IllegalArgumentException("Read zero-length byte array  in buf=" + buf + '=' + Bytes.pretty(buf));
        }
        HBaseRpc.checkArrayLength(buf, length);
    }

    static byte[] readByteArray(ChannelBuffer buf) {
        long length = HBaseRpc.readVLong(buf);
        HBaseRpc.checkArrayLength(buf, length);
        byte[] b = new byte[(int)length];
        buf.readBytes(b);
        return b;
    }

    static String readHadoopString(ChannelBuffer buf) {
        int length = buf.readInt();
        HBaseRpc.checkArrayLength(buf, length);
        byte[] s = new byte[length];
        buf.readBytes(s);
        return new String(s, CharsetUtil.UTF_8);
    }

    static <T> T readProtobuf(ChannelBuffer buf, Parser<T> parser) {
        int offset;
        byte[] payload;
        int length = HBaseRpc.readProtoBufVarint(buf);
        HBaseRpc.checkArrayLength(buf, length);
        if (buf.hasArray()) {
            payload = buf.array();
            offset = buf.arrayOffset() + buf.readerIndex();
            buf.readerIndex(buf.readerIndex() + length);
        } else {
            payload = new byte[length];
            buf.readBytes(payload);
            offset = 0;
        }
        try {
            return (T)parser.parseFrom(payload, offset, length);
        }
        catch (InvalidProtocolBufferException e) {
            String msg = "Invalid RPC response: length=" + length + ", payload=" + Bytes.pretty(payload);
            LOG.error("Invalid RPC from buffer: " + buf);
            throw new InvalidResponseException(msg, (Exception)((Object)e));
        }
    }

    static void writeVLong(ChannelBuffer buf, long n) {
        if (n >= -112L && n <= 127L) {
            buf.writeByte((int)((byte)n));
            return;
        }
        int b = -112;
        if (n < 0L) {
            n ^= 0xFFFFFFFFFFFFFFFFL;
            b = -120;
        }
        long tmp = n;
        do {
            b = (byte)(b - 1);
        } while ((tmp >>>= 8) != 0L);
        buf.writeByte(b);
        switch (b & 7) {
            case 0: {
                buf.writeLong(n);
                break;
            }
            case 1: {
                buf.writeInt((int)(n >>> 24));
                buf.writeMedium((int)n);
                break;
            }
            case 2: {
                buf.writeMedium((int)(n >>> 24));
                buf.writeMedium((int)n);
                break;
            }
            case 3: {
                buf.writeByte((int)((byte)(n >>> 32)));
            }
            case 4: {
                buf.writeInt((int)n);
                break;
            }
            case 5: {
                buf.writeMedium((int)n);
                break;
            }
            case 6: {
                buf.writeShort((int)((short)n));
                break;
            }
            case 7: {
                buf.writeByte((int)((byte)n));
            }
        }
    }

    static long readVLong(ChannelBuffer buf) {
        byte b = buf.readByte();
        if ((b & 0xF0) != 128) {
            return b;
        }
        boolean negate = (b & 8) == 0;
        long result = 0L;
        switch (b & 7) {
            case 0: {
                result = buf.readLong();
                break;
            }
            case 1: {
                result = buf.readUnsignedInt();
                result <<= 32;
                result |= (long)buf.readUnsignedMedium();
                break;
            }
            case 2: {
                result = buf.readUnsignedMedium();
                result <<= 24;
                result |= (long)buf.readUnsignedMedium();
                break;
            }
            case 3: {
                b = buf.readByte();
                result <<= 8;
                result |= (long)(b & 0xFF);
            }
            case 4: {
                result <<= 32;
                result |= buf.readUnsignedInt();
                break;
            }
            case 5: {
                result |= (long)buf.readUnsignedMedium();
                break;
            }
            case 6: {
                result |= (long)buf.readUnsignedShort();
                break;
            }
            case 7: {
                b = buf.readByte();
                result <<= 8;
                result |= (long)(b & 0xFF);
            }
        }
        return negate ? result ^ 0xFFFFFFFFFFFFFFFFL : result;
    }

    static int readProtoBufVarint(ChannelBuffer buf) {
        int result = buf.readByte();
        if (result >= 0) {
            return result;
        }
        result &= 0x7F;
        if ((result |= buf.readByte() << 7) >= 0) {
            return result;
        }
        result &= 0x3FFF;
        if ((result |= buf.readByte() << 14) >= 0) {
            return result;
        }
        result &= 0x1FFFFF;
        if ((result |= buf.readByte() << 21) >= 0) {
            return result;
        }
        result &= 0xFFFFFFF;
        byte b = buf.readByte();
        result |= b << 28;
        if (b >= 0) {
            return result;
        }
        throw new IllegalArgumentException("Not a 32 bit varint: " + result + " (5th byte: " + b + ")");
    }

    private final class TimeoutTask
    implements TimerTask {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Timeout time_out) throws Exception {
            HBaseRpc hBaseRpc = HBaseRpc.this;
            synchronized (hBaseRpc) {
                if (HBaseRpc.this.has_timedout) {
                    throw new IllegalStateException("This RPC has already timed out " + HBaseRpc.this);
                }
                HBaseRpc.this.has_timedout = true;
            }
            if (HBaseRpc.this.timeout_handle == null) {
                LOG.error("Received a timeout handle " + time_out + " but this RPC did not have one " + this);
            }
            if (time_out != HBaseRpc.this.timeout_handle) {
                LOG.error("Receieved a timeout handle " + time_out + " that doesn't match our own " + this);
            }
            if (HBaseRpc.this.region_client == null) {
                LOG.error("Somehow the region client was null when timing out RPC " + this);
            } else {
                HBaseRpc.this.region_client.removeRpc(HBaseRpc.this, true);
            }
            HBaseRpc.this.callback(new RpcTimedOutException("RPC ID [" + HBaseRpc.this.rpc_id + "] timed out waiting for response from HBase on region client [" + (Object)((Object)HBaseRpc.this.region_client) + " ] for over " + HBaseRpc.this.timeout + "ms"));
            HBaseRpc.this.timeout_task = null;
            HBaseRpc.this.timeout_handle = null;
        }
    }

    static interface IsEdit {
        public static final byte[] MUTATE = new byte[]{77, 117, 116, 97, 116, 101};
    }

    public static interface HasTimestamp {
        public long timestamp();
    }

    public static interface HasValues {
        public byte[][] values();
    }

    public static interface HasValue {
        public byte[] value();
    }

    public static interface HasQualifiers {
        public byte[][] qualifiers();
    }

    public static interface HasQualifier {
        public byte[] qualifier();
    }

    public static interface HasFamily {
        public byte[] family();
    }

    public static interface HasKey {
        public byte[] key();
    }

    public static interface HasTable {
        public byte[] table();
    }
}

