/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.EagerExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.backend.libffi.NativePointer;
import com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary;

@GeneratedBy(value=NativePointer.class)
public final class NativePointerGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NativePointerGen() {
    }

    private static void init() {
    }

    static {
        LibraryExport.register(NativePointer.class, (LibraryExport[])new LibraryExport[]{new BackendNativePointerLibraryExports()});
    }

    @GeneratedBy(value=NativePointer.class)
    private static final class BackendNativePointerLibraryExports
    extends LibraryExport<BackendNativePointerLibrary> {
        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private BackendNativePointerLibraryExports() {
            super(BackendNativePointerLibrary.class, NativePointer.class, false, true, 1);
        }

        protected BackendNativePointerLibrary createUncached(Object receiver) {
            assert (receiver instanceof NativePointer);
            Uncached uncached = UNCACHED;
            return uncached;
        }

        protected BackendNativePointerLibrary createCached(Object receiver) {
            assert (receiver instanceof NativePointer || receiver instanceof LibraryExport);
            return CACHE;
        }

        @GeneratedBy(value=NativePointer.class)
        @DenyReplace
        private static final class Uncached
        extends BackendNativePointerLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NativePointer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NativePointer;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).isPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).asPointer();
            }
        }

        @GeneratedBy(value=NativePointer.class)
        private static final class Cached
        extends BackendNativePointerLibrary {
            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NativePointer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NativePointer;
            }

            public boolean isAdoptable() {
                return false;
            }

            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).isPointer();
            }

            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).asPointer();
            }
        }
    }

    @GeneratedBy(value=NativePointer.class)
    public static final class BackendNativePointerLibraryEagerProvider
    implements EagerExportProvider {
        public void ensureRegistered() {
            NativePointerGen.init();
        }

        public String getLibraryClassName() {
            return "com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary";
        }
    }
}

