/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.CoreLocation;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.LocationImpl;
import java.lang.reflect.Field;
import java.util.Objects;
import sun.misc.Unsafe;

abstract class CoreLocations {
    static final int LONG_FIELD_SLOT_SIZE = 1;
    static final int LONG_ARRAY_SLOT_SIZE = 2;
    static final int OBJECT_SLOT_SIZE = 1;
    static final int MAX_DYNAMIC_FIELDS = 1000;
    static final SimpleObjectFieldLocation OBJECT_ARRAY_LOCATION;
    static final SimpleObjectFieldLocation PRIMITIVE_ARRAY_LOCATION;

    CoreLocations() {
    }

    public static LongLocation createLongLocation(LongLocation longLocation, boolean allowInt) {
        if (!allowInt && longLocation instanceof LongLocationDecorator || longLocation instanceof LongLocationDecorator && ((LongLocationDecorator)longLocation).allowInt == allowInt) {
            return longLocation;
        }
        return new LongLocationDecorator(longLocation, allowInt);
    }

    static long decodeLong(int lower, int upper) {
        return (long)lower & 0xFFFFFFFFL | (long)upper << 32;
    }

    static int lowerInt(long value) {
        return (int)value;
    }

    static int upperInt(long value) {
        return (int)(value >>> 32);
    }

    static int getLocationOrdinal(CoreLocation loc) {
        LocationImpl internal = loc.getInternalLocation();
        boolean isPrimitive = internal instanceof LongLocation;
        if (internal instanceof FieldLocation) {
            return (isPrimitive ? -2147483647 : 0) + ((FieldLocation)internal).getIndex();
        }
        if (internal instanceof ArrayLocation) {
            return (isPrimitive ? -2147483647 : 0) + 1000 + ((ArrayLocation)internal).getIndex();
        }
        throw new IllegalArgumentException(internal.getClass().getName());
    }

    static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }

    static {
        int index = 0;
        OBJECT_ARRAY_LOCATION = new SimpleObjectFieldLocation(index++){

            public Object[] get(DynamicObject store, boolean condition) {
                return LayoutImpl.ACCESS.getObjectArray(store);
            }

            @Override
            public void setInternal(DynamicObject store, Object value, boolean condition) {
                LayoutImpl.ACCESS.setObjectArray(store, (Object[])value);
            }

            @Override
            public Class<? extends DynamicObject> getDeclaringClass() {
                return DynamicObject.class;
            }
        };
        PRIMITIVE_ARRAY_LOCATION = new SimpleObjectFieldLocation(index++){

            public int[] get(DynamicObject store, boolean condition) {
                return LayoutImpl.ACCESS.getPrimitiveArray(store);
            }

            @Override
            public void setInternal(DynamicObject store, Object value, boolean condition) {
                LayoutImpl.ACCESS.setPrimitiveArray(store, (int[])value);
            }

            @Override
            public Class<? extends DynamicObject> getDeclaringClass() {
                return DynamicObject.class;
            }
        };
    }

    static final class DynamicLongFieldLocation
    extends SimpleLongFieldLocation {
        private final long offset;
        private final Class<? extends DynamicObject> tclass;
        private static final Unsafe UNSAFE = CoreLocations.getUnsafe();

        DynamicLongFieldLocation(int index, long offset, Class<? extends DynamicObject> declaringClass) {
            super(index);
            this.offset = offset;
            this.tclass = declaringClass;
            assert (offset % 8L == 0L);
        }

        @Override
        public long getLong(DynamicObject store, boolean condition) {
            this.receiverCheck(store);
            return UNSAFE.getLong(store, this.offset);
        }

        @Override
        public void setLong(DynamicObject store, long value, boolean condition) {
            this.receiverCheck(store);
            UNSAFE.putLong(store, this.offset, value);
        }

        @Override
        public Class<? extends DynamicObject> getDeclaringClass() {
            return this.tclass;
        }
    }

    static final class DynamicObjectFieldLocation
    extends SimpleObjectFieldLocation {
        private final long offset;
        private final Class<? extends DynamicObject> tclass;
        private static final Unsafe UNSAFE = CoreLocations.getUnsafe();

        private DynamicObjectFieldLocation(int index, long offset, Class<? extends DynamicObject> declaringClass) {
            super(index);
            this.offset = offset;
            this.tclass = declaringClass;
        }

        DynamicObjectFieldLocation(int index, Field objectField) {
            this(index, UNSAFE.objectFieldOffset(objectField), objectField.getDeclaringClass().asSubclass(DynamicObject.class));
            if (objectField.getType() != Object.class) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public Object get(DynamicObject store, boolean condition) {
            this.receiverCheck(store);
            return UNSAFE.getObject(store, this.offset);
        }

        @Override
        public void setInternal(DynamicObject store, Object value, boolean condition) {
            this.receiverCheck(store);
            UNSAFE.putObject(store, this.offset, value);
        }

        @Override
        public Class<? extends DynamicObject> getDeclaringClass() {
            return this.tclass;
        }
    }

    static class BooleanLocationDecorator
    extends PrimitiveLocationDecorator
    implements BooleanLocation {
        protected BooleanLocationDecorator(LongLocation longLocation) {
            super(longLocation);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getBoolean(store, condition);
        }

        @Override
        public boolean getBoolean(DynamicObject store, boolean condition) {
            return this.getLongInternal(store, condition) != 0L;
        }

        @Override
        public void setBoolean(DynamicObject store, boolean value, boolean condition) {
            this.setLongInternal(store, value ? 1L : 0L, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value, boolean condition) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw BooleanLocationDecorator.incompatibleLocation();
            }
            this.setBoolean(store, (boolean)((Boolean)value), condition);
        }

        @Override
        public final boolean getBoolean(DynamicObject store, Shape shape) {
            return this.getBoolean(store, BooleanLocationDecorator.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Boolean;
        }

        @Override
        public Class<Boolean> getType() {
            return Boolean.TYPE;
        }
    }

    static class DoubleLocationDecorator
    extends PrimitiveLocationDecorator
    implements DoubleLocation {
        private final boolean allowInt;

        protected DoubleLocationDecorator(LongLocation longLocation, boolean allowInt) {
            super(longLocation);
            this.allowInt = allowInt;
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getDouble(store, condition);
        }

        @Override
        public double getDouble(DynamicObject store, boolean condition) {
            return Double.longBitsToDouble(this.getLongInternal(store, condition));
        }

        @Override
        public void setDouble(DynamicObject store, double value, boolean condition) {
            this.setLongInternal(store, Double.doubleToRawLongBits(value), condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value, boolean condition) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw DoubleLocationDecorator.incompatibleLocation();
            }
            this.setDouble(store, this.doubleValue(value), condition);
        }

        private double doubleValue(Object value) {
            if (!this.allowInt || value instanceof Double) {
                return (Double)value;
            }
            return ((Integer)value).doubleValue();
        }

        @Override
        public final double getDouble(DynamicObject store, Shape shape) {
            return this.getDouble(store, DoubleLocationDecorator.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Double || this.allowInt && value instanceof Integer;
        }

        @Override
        public Class<Double> getType() {
            return Double.TYPE;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.allowInt == ((DoubleLocationDecorator)obj).allowInt;
        }

        @Override
        public boolean isImplicitCastIntToDouble() {
            return this.allowInt;
        }
    }

    static class IntLocationDecorator
    extends PrimitiveLocationDecorator
    implements IntLocation {
        protected IntLocationDecorator(LongLocation longLocation) {
            super(longLocation);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getInt(store, condition);
        }

        @Override
        public int getInt(DynamicObject store, boolean condition) {
            return (int)this.getLongInternal(store, condition);
        }

        @Override
        public void setInt(DynamicObject store, int value, boolean condition) {
            this.setLongInternal(store, value, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value, boolean condition) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw IntLocationDecorator.incompatibleLocation();
            }
            this.setLongInternal(store, ((Integer)value).intValue(), condition);
        }

        @Override
        public final int getInt(DynamicObject store, Shape shape) {
            return this.getInt(store, IntLocationDecorator.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Integer;
        }

        @Override
        public Class<Integer> getType() {
            return Integer.TYPE;
        }
    }

    public static abstract class PrimitiveLocationDecorator
    extends CoreLocation {
        private final LongLocation longLocation;

        protected PrimitiveLocationDecorator(LongLocation longLocation) {
            this.longLocation = longLocation;
        }

        public final long getLongInternal(DynamicObject store, boolean condition) {
            return this.longLocation.getLong(store, condition);
        }

        public final void setLongInternal(DynamicObject store, long value, boolean condition) {
            this.longLocation.setLong(store, value, condition);
        }

        public final LongLocation getInternalLongLocation() {
            return this.longLocation;
        }

        @Override
        protected final LocationImpl getInternalLocation() {
            return (LocationImpl)((Object)this.longLocation);
        }

        @Override
        public final int primitiveFieldCount() {
            return ((LocationImpl)((Object)this.longLocation)).primitiveFieldCount();
        }

        @Override
        public final int primitiveArrayCount() {
            return ((LocationImpl)((Object)this.longLocation)).primitiveArrayCount();
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            ((LocationImpl)((Object)this.longLocation)).accept(locationVisitor);
        }

        @Override
        public String getWhereString() {
            return ((LocationImpl)((Object)this.longLocation)).getWhereString();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.longLocation.equals(((PrimitiveLocationDecorator)obj).longLocation);
        }

        @Override
        public int hashCode() {
            return this.longLocation.hashCode();
        }
    }

    public static abstract class SimpleLongFieldLocation
    extends FieldLocation
    implements LongLocation {
        protected SimpleLongFieldLocation(int index) {
            super(index);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getLong(store, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value, boolean condition) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw SimpleLongFieldLocation.incompatibleLocation();
            }
            this.setLong(store, (long)((Long)value), condition);
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Long;
        }

        @Override
        public abstract long getLong(DynamicObject var1, boolean var2);

        @Override
        public final long getLong(DynamicObject store, Shape shape) {
            return this.getLong(store, SimpleLongFieldLocation.checkShape(store, shape));
        }

        @Override
        public abstract void setLong(DynamicObject var1, long var2, boolean var4);

        @Override
        public int primitiveFieldCount() {
            return 1;
        }

        @Override
        public final Class<Long> getType() {
            return Long.TYPE;
        }

        @Override
        public void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveField(this.getIndex(), 1);
        }

        @Override
        public boolean isImplicitCastIntToLong() {
            return false;
        }
    }

    static class LongLocationDecorator
    extends PrimitiveLocationDecorator
    implements LongLocation {
        protected final boolean allowInt;

        protected LongLocationDecorator(LongLocation longLocation, boolean allowInt) {
            super(longLocation);
            this.allowInt = allowInt;
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getLong(store, condition);
        }

        @Override
        public long getLong(DynamicObject store, boolean condition) {
            return super.getLongInternal(store, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value, boolean condition) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw LongLocationDecorator.incompatibleLocation();
            }
            this.setLong(store, this.longValue(value), condition);
        }

        @Override
        public void setLong(DynamicObject store, long value, boolean condition) {
            super.setLongInternal(store, value, condition);
        }

        private long longValue(Object value) {
            if (!this.allowInt || value instanceof Long) {
                return (Long)value;
            }
            return ((Integer)value).longValue();
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Long || this.allowInt && value instanceof Integer;
        }

        @Override
        public Class<Long> getType() {
            return Long.TYPE;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.allowInt == ((LongLocationDecorator)obj).allowInt;
        }

        @Override
        public boolean isImplicitCastIntToLong() {
            return this.allowInt;
        }
    }

    static class LongArrayLocation
    extends ArrayLocation
    implements LongLocation {
        private static final Unsafe UNSAFE = CoreLocations.getUnsafe();
        private static final int ALIGN = 1;
        private static final long ARRAY_INT_BASE_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
        private static final long ARRAY_INT_INDEX_SCALE = UNSAFE.arrayIndexScale(int[].class);
        protected final boolean allowInt;

        protected LongArrayLocation(int index, CoreLocation arrayLocation, boolean allowInt) {
            super(index, arrayLocation);
            this.allowInt = allowInt;
        }

        protected LongArrayLocation(int index, CoreLocation arrayLocation) {
            this(index, arrayLocation, false);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getLong(store, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value, boolean condition) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw LongArrayLocation.incompatibleLocation();
            }
            this.setLongInternal(store, this.longValue(value));
        }

        private long longValue(Object value) {
            if (!this.allowInt || value instanceof Long) {
                return (Long)value;
            }
            return ((Integer)value).longValue();
        }

        @Override
        public long getLong(DynamicObject store, boolean condition) {
            int[] array = (int[])this.getArray(store, condition);
            return UNSAFE.getLong(array, this.getOffset(array));
        }

        public final void setLongInternal(DynamicObject store, long value) {
            int[] array = (int[])this.getArray(store, false);
            long offset = this.getOffset(array);
            UNSAFE.putLong(array, offset, value);
        }

        @Override
        public void setLong(DynamicObject store, long value, boolean condition) {
            this.setLongInternal(store, value);
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Long || this.allowInt && value instanceof Integer;
        }

        @Override
        public final Class<Long> getType() {
            return Long.TYPE;
        }

        @Override
        public int primitiveArrayCount() {
            return 2;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveArray(this.getIndex(), 2);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.allowInt == ((LongArrayLocation)obj).allowInt;
        }

        @Override
        public boolean isImplicitCastIntToLong() {
            return this.allowInt;
        }

        protected final long getOffset(int[] array) {
            int idx = this.index;
            if (idx < 0 || idx >= array.length - 1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new ArrayIndexOutOfBoundsException(idx);
            }
            return ARRAY_INT_BASE_OFFSET + ARRAY_INT_INDEX_SCALE * (long)idx;
        }
    }

    public static abstract class SimpleObjectFieldLocation
    extends FieldLocation
    implements ObjectLocation {
        protected SimpleObjectFieldLocation(int index) {
            super(index);
        }

        @Override
        public abstract Object get(DynamicObject var1, boolean var2);

        @Override
        public abstract void setInternal(DynamicObject var1, Object var2, boolean var3);

        @Override
        public boolean canStore(Object value) {
            return true;
        }

        @Override
        public Class<? extends Object> getType() {
            return Object.class;
        }

        @Override
        public boolean isNonNull() {
            return false;
        }

        @Override
        protected void clear(DynamicObject store) {
            this.setInternal(store, null, false);
        }

        @Override
        public int objectFieldCount() {
            return 1;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitObjectField(this.getIndex(), 1);
        }
    }

    static class ObjectArrayLocation
    extends ArrayLocation
    implements ObjectLocation {
        protected ObjectArrayLocation(int index, CoreLocation arrayLocation) {
            super(index, arrayLocation);
        }

        @Override
        public Object get(DynamicObject store, boolean condition) {
            return ((Object[])this.getArray(store, condition))[this.index];
        }

        @Override
        public final void setInternal(DynamicObject store, Object value, boolean condition) {
            ((Object[])this.getArray((DynamicObject)store, (boolean)condition))[this.index] = value;
        }

        @Override
        public boolean canStore(Object value) {
            return true;
        }

        @Override
        public Class<? extends Object> getType() {
            return Object.class;
        }

        @Override
        public final boolean isNonNull() {
            return false;
        }

        @Override
        protected void clear(DynamicObject store) {
            this.setInternal(store, null, false);
        }

        @Override
        public int objectArrayCount() {
            return 1;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitObjectArray(this.index, 1);
        }
    }

    public static abstract class FieldLocation
    extends CoreLocation {
        private final int index;

        protected FieldLocation(int index) {
            this.index = index;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.index;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            FieldLocation other = (FieldLocation)obj;
            return this.index == other.index;
        }

        public final int getIndex() {
            return this.index;
        }

        @Override
        public String getWhereString() {
            return "@" + this.index;
        }

        public abstract Class<? extends DynamicObject> getDeclaringClass();

        protected final void receiverCheck(DynamicObject store) {
            if (!this.getDeclaringClass().isInstance(store)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw this.illegalReceiver(store);
            }
        }

        private IllegalArgumentException illegalReceiver(DynamicObject store) {
            CompilerAsserts.neverPartOfCompilation();
            return new IllegalArgumentException(String.format("Invalid receiver type (expected %s, was %s)", this.getDeclaringClass(), store == null ? null : store.getClass()));
        }
    }

    public static abstract class ArrayLocation
    extends CoreLocation {
        protected final int index;
        protected final CoreLocation arrayLocation;

        protected ArrayLocation(int index, CoreLocation arrayLocation) {
            this.index = index;
            this.arrayLocation = arrayLocation;
        }

        protected final Object getArray(DynamicObject store, boolean condition) {
            return this.arrayLocation.get(store, condition);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.index;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ArrayLocation other = (ArrayLocation)obj;
            return this.index == other.index;
        }

        public final int getIndex() {
            return this.index;
        }

        @Override
        public String getWhereString() {
            return "[" + this.index + "]";
        }
    }

    public static final class DeclaredLocation
    extends ValueLocation {
        DeclaredLocation(Object value) {
            super(value);
        }

        @Override
        public boolean isDeclared() {
            return true;
        }
    }

    public static final class ConstantLocation
    extends ValueLocation {
        ConstantLocation(Object value) {
            super(value);
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    public static abstract class ValueLocation
    extends CoreLocation {
        private final Object value;

        ValueLocation(Object value) {
            assert (!(value instanceof Location));
            this.value = value;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.value, ((ValueLocation)obj).value);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.value;
        }

        @Override
        public boolean canStore(Object val) {
            return ValueLocation.valueEquals(this.value, val);
        }

        @Override
        public final void set(DynamicObject store, Object value, boolean condition) throws IncompatibleLocationException, FinalLocationException {
            if (!this.canStore(value)) {
                throw ValueLocation.finalLocation();
            }
        }

        @Override
        public final void setInternal(DynamicObject store, Object value, boolean condition) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public String toString() {
            return "=" + String.valueOf(this.value);
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
        }

        @Override
        public final boolean isValue() {
            return true;
        }
    }

    public static interface BooleanLocation
    extends TypedLocation,
    com.oracle.truffle.api.object.BooleanLocation {
        @Override
        public boolean getBoolean(DynamicObject var1, boolean var2);

        public void setBoolean(DynamicObject var1, boolean var2, boolean var3);

        @Override
        default public Class<Boolean> getType() {
            return Boolean.TYPE;
        }

        @Override
        default public boolean getBoolean(DynamicObject store, Shape shape) {
            return this.getBoolean(store, store.getShape() == shape);
        }

        @Override
        default public void setBoolean(DynamicObject store, boolean value, Shape shape) throws FinalLocationException {
            this.setBoolean(store, value, store.getShape() == shape);
        }

        @Override
        default public void setBoolean(DynamicObject store, boolean value) throws FinalLocationException {
            this.setBoolean(store, value, false);
        }

        @Override
        default public void setBoolean(DynamicObject store, boolean value, Shape oldShape, Shape newShape) {
            LayoutImpl.ACCESS.grow(store, oldShape, newShape);
            this.setBoolean(store, value, false);
            LayoutImpl.ACCESS.setShapeWithStoreFence(store, newShape);
        }
    }

    public static interface DoubleLocation
    extends TypedLocation,
    com.oracle.truffle.api.object.DoubleLocation {
        @Override
        public double getDouble(DynamicObject var1, boolean var2);

        public void setDouble(DynamicObject var1, double var2, boolean var4);

        @Override
        default public Class<Double> getType() {
            return Double.TYPE;
        }

        public boolean isImplicitCastIntToDouble();

        @Override
        default public double getDouble(DynamicObject store, Shape shape) {
            return this.getDouble(store, store.getShape() == shape);
        }

        @Override
        default public void setDouble(DynamicObject store, double value, Shape shape) throws FinalLocationException {
            this.setDouble(store, value, store.getShape() == shape);
        }

        @Override
        default public void setDouble(DynamicObject store, double value) throws FinalLocationException {
            this.setDouble(store, value, false);
        }

        @Override
        default public void setDouble(DynamicObject store, double value, Shape oldShape, Shape newShape) {
            LayoutImpl.ACCESS.grow(store, oldShape, newShape);
            this.setDouble(store, value, false);
            LayoutImpl.ACCESS.setShapeWithStoreFence(store, newShape);
        }
    }

    public static interface LongLocation
    extends TypedLocation,
    com.oracle.truffle.api.object.LongLocation {
        @Override
        public long getLong(DynamicObject var1, boolean var2);

        public void setLong(DynamicObject var1, long var2, boolean var4);

        @Override
        default public Class<Long> getType() {
            return Long.TYPE;
        }

        public boolean isImplicitCastIntToLong();

        @Override
        default public long getLong(DynamicObject store, Shape shape) {
            return this.getLong(store, store.getShape() == shape);
        }

        @Override
        default public void setLong(DynamicObject store, long value, Shape shape) throws FinalLocationException {
            this.setLong(store, value, store.getShape() == shape);
        }

        @Override
        default public void setLong(DynamicObject store, long value) throws FinalLocationException {
            this.setLong(store, value, false);
        }

        @Override
        default public void setLong(DynamicObject store, long value, Shape oldShape, Shape newShape) {
            LayoutImpl.ACCESS.grow(store, oldShape, newShape);
            this.setLong(store, value, false);
            LayoutImpl.ACCESS.setShapeWithStoreFence(store, newShape);
        }
    }

    public static interface IntLocation
    extends TypedLocation,
    com.oracle.truffle.api.object.IntLocation {
        @Override
        public int getInt(DynamicObject var1, boolean var2);

        public void setInt(DynamicObject var1, int var2, boolean var3);

        @Override
        default public Class<Integer> getType() {
            return Integer.TYPE;
        }

        @Override
        default public int getInt(DynamicObject store, Shape shape) {
            return this.getInt(store, store.getShape() == shape);
        }

        @Override
        default public void setInt(DynamicObject store, int value, Shape shape) throws FinalLocationException {
            this.setInt(store, value, store.getShape() == shape);
        }

        @Override
        default public void setInt(DynamicObject store, int value) throws FinalLocationException {
            this.setInt(store, value, false);
        }

        @Override
        default public void setInt(DynamicObject store, int value, Shape oldShape, Shape newShape) {
            LayoutImpl.ACCESS.grow(store, oldShape, newShape);
            this.setInt(store, value, false);
            LayoutImpl.ACCESS.setShapeWithStoreFence(store, newShape);
        }
    }

    public static interface ObjectLocation
    extends TypedLocation,
    com.oracle.truffle.api.object.ObjectLocation {
        @Override
        public Class<? extends Object> getType();

        @Override
        public boolean isNonNull();
    }

    public static interface TypedLocation
    extends com.oracle.truffle.api.object.TypedLocation {
        @Override
        public Class<?> getType();
    }
}

