/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionType;

abstract class ProfilerCLI {
    static final OptionType<Object[]> WILDCARD_FILTER_TYPE = new OptionType("Expression", (Function)new Function<String, Object[]>(){

        @Override
        public Object[] apply(String filterWildcardExpression) {
            if (filterWildcardExpression == null) {
                return null;
            }
            String[] expressions = filterWildcardExpression.split(",");
            Object[] builtExpressions = new Object[expressions.length];
            for (int i = 0; i < expressions.length; ++i) {
                String expression = expressions[i];
                expression = expression.trim();
                Object result = expression;
                if (expression.contains("?") || expression.contains("*")) {
                    try {
                        result = Pattern.compile(ProfilerCLI.wildcardToRegex(expression));
                    }
                    catch (PatternSyntaxException e) {
                        throw new IllegalArgumentException(String.format("Invalid wildcard pattern %s.", expression), e);
                    }
                }
                builtExpressions[i] = result;
            }
            return builtExpressions;
        }
    }, (Consumer)new Consumer<Object[]>(){

        @Override
        public void accept(Object[] objects) {
        }
    });

    ProfilerCLI() {
    }

    static SourceSectionFilter buildFilter(boolean roots, boolean statements, boolean calls, final boolean internals, final Object[] filterRootName, final Object[] filterFile, final String filterMimeType, final String filterLanguage) {
        SourceSectionFilter.Builder builder = SourceSectionFilter.newBuilder();
        if (!internals || filterFile != null || filterMimeType != null || filterLanguage != null) {
            builder.sourceIs(new SourceSectionFilter.SourcePredicate(){

                public boolean test(Source source) {
                    boolean internal = internals || !source.isInternal();
                    boolean file = ProfilerCLI.testWildcardExpressions(source.getPath(), filterFile);
                    boolean mimeType = filterMimeType.equals("") || filterMimeType.equals(source.getMimeType());
                    boolean languageId = filterLanguage.equals("") || filterMimeType.equals(source.getLanguage());
                    return internal && file && mimeType && languageId;
                }
            });
        }
        ArrayList<Class<StandardTags.CallTag>> tags = new ArrayList<Class<StandardTags.CallTag>>();
        if (roots) {
            tags.add(StandardTags.RootTag.class);
        }
        if (statements) {
            tags.add(StandardTags.StatementTag.class);
        }
        if (calls) {
            tags.add(StandardTags.CallTag.class);
        }
        if (!(roots || statements || calls)) {
            throw new IllegalArgumentException("No elements specified. Either roots, statements or calls must remain enabled.");
        }
        builder.tagIs(tags.toArray(new Class[0]));
        builder.rootNameIs((Predicate)new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return ProfilerCLI.testWildcardExpressions(s, filterRootName);
            }
        });
        return builder.build();
    }

    static String repeat(String s, int times) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            b.append(s);
        }
        return b.toString();
    }

    static String getShortDescription(SourceSection sourceSection) {
        if (sourceSection.getSource() == null) {
            return "<Unknown>";
        }
        StringBuilder b = new StringBuilder();
        if (sourceSection.getSource().getPath() == null) {
            b.append(sourceSection.getSource().getName());
        } else {
            Path pathAbsolute = Paths.get(sourceSection.getSource().getPath(), new String[0]);
            Path pathBase = new File("").getAbsoluteFile().toPath();
            try {
                Path pathRelative = pathBase.relativize(pathAbsolute);
                b.append(pathRelative.toFile());
            }
            catch (IllegalArgumentException e) {
                b.append(sourceSection.getSource().getName());
            }
        }
        b.append("~").append(ProfilerCLI.formatIndices(sourceSection, true));
        return b.toString();
    }

    static String formatIndices(SourceSection sourceSection, boolean needsColumnSpecifier) {
        boolean singleLine;
        StringBuilder b = new StringBuilder();
        boolean bl = singleLine = sourceSection.getStartLine() == sourceSection.getEndLine();
        if (singleLine) {
            b.append(sourceSection.getStartLine());
        } else {
            b.append(sourceSection.getStartLine()).append("-").append(sourceSection.getEndLine());
        }
        if (needsColumnSpecifier) {
            b.append(":");
            if (sourceSection.getCharLength() <= 1) {
                b.append(sourceSection.getCharIndex());
            } else {
                b.append(sourceSection.getCharIndex()).append("-").append(sourceSection.getCharIndex() + sourceSection.getCharLength() - 1);
            }
        }
        return b.toString();
    }

    static boolean testWildcardExpressions(String value, Object[] fileFilters) {
        if (fileFilters == null || fileFilters.length == 0) {
            return true;
        }
        if (value == null) {
            return false;
        }
        for (Object filter : fileFilters) {
            if (filter instanceof Pattern) {
                if (!((Pattern)filter).matcher(value).matches()) continue;
                return true;
            }
            if (filter instanceof String) {
                if (!filter.equals(value)) continue;
                return true;
            }
            throw new AssertionError();
        }
        return false;
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append("\\S*");
                    continue block5;
                }
                case '?': {
                    s.append("\\S");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    static JSONObject sourceSectionToJSON(SourceSection sourceSection) {
        JSONObject sourceSectionJson = new JSONObject();
        if (sourceSection != null) {
            Source source = sourceSection.getSource();
            if (source != null) {
                String path;
                if (source.getLanguage() != null) {
                    sourceSectionJson.put("language", source.getLanguage().toString());
                }
                if ((path = source.getPath()) != null) {
                    sourceSectionJson.put("path", path);
                }
            }
            sourceSectionJson.put("source_name", sourceSection.getSource().getName());
            sourceSectionJson.put("start_line", sourceSection.getStartLine());
            sourceSectionJson.put("end_line", sourceSection.getEndLine());
            sourceSectionJson.put("start_column", sourceSection.getStartColumn());
            sourceSectionJson.put("end_column", sourceSection.getEndColumn());
        }
        return sourceSectionJson;
    }

    protected static PrintStream chooseOutputStream(TruffleInstrument.Env env, OptionKey<String> option) {
        try {
            if (option.hasBeenSet(env.getOptions())) {
                String outputPath = (String)option.getValue(env.getOptions());
                File file = new File(outputPath);
                if (file.exists()) {
                    throw new IllegalArgumentException("Cannot redirect output to an existing file!");
                }
                return new PrintStream(new FileOutputStream(file));
            }
            return new PrintStream(env.out());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Cannot redirect output to a directory");
        }
    }

    static class SourceLocation {
        private final SourceSection sourceSection;
        private final String rootName;

        SourceLocation(SourceSection sourceSection, String rootName) {
            this.sourceSection = sourceSection;
            this.rootName = rootName;
        }

        SourceSection getSourceSection() {
            return this.sourceSection;
        }

        public String getRootName() {
            return this.rootName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceLocation that = (SourceLocation)o;
            if (this.sourceSection != null ? !this.sourceSection.equals((Object)that.sourceSection) : that.sourceSection != null) {
                return false;
            }
            return this.rootName != null ? this.rootName.equals(that.rootName) : that.rootName == null;
        }

        public int hashCode() {
            int result = this.sourceSection != null ? this.sourceSection.hashCode() : 0;
            result = 31 * result + (this.rootName != null ? this.rootName.hashCode() : 0);
            return result;
        }
    }
}

