/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.profiler.CPUTracer;
import com.oracle.truffle.tools.profiler.impl.ProfilerCLI;
import com.oracle.truffle.tools.profiler.impl.WildcardFilter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Function;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

@Option.Group(value={"cputracer"})
class CPUTracerCLI
extends ProfilerCLI {
    static final OptionType<Output> CLI_OUTPUT_TYPE = new OptionType("Output", (Function)new Function<String, Output>(){

        @Override
        public Output apply(String s) {
            try {
                return Output.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Output can be: histogram or json");
            }
        }
    });
    @Option(name="", help="Enable the CPU tracer (default: false).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> ENABLED = new OptionKey((Object)false);
    @Option(name="TraceRoots", help="Capture roots when tracing (default: true).", usageSyntax="true|false", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> TRACE_ROOTS = new OptionKey((Object)true);
    @Option(name="TraceStatements", help="Capture statements when tracing (default: false).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> TRACE_STATEMENTS = new OptionKey((Object)false);
    @Option(name="TraceCalls", help="Capture calls when tracing (default: false).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> TRACE_CALLS = new OptionKey((Object)false);
    @Option(name="TraceInternal", help="Trace internal elements (default: false).", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TRACE_INTERNAL = new OptionKey((Object)false);
    @Option(name="FilterRootName", help="Wildcard filter for program roots. (eg. Math.*) (default: no filter).", usageSyntax="<filter>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<WildcardFilter> FILTER_ROOT = new OptionKey((Object)WildcardFilter.DEFAULT, WildcardFilter.WILDCARD_FILTER_TYPE);
    @Option(name="FilterFile", help="Wildcard filter for source file paths. (eg. *program*.sl) (default: no filter).", usageSyntax="<filter>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<WildcardFilter> FILTER_FILE = new OptionKey((Object)WildcardFilter.DEFAULT, WildcardFilter.WILDCARD_FILTER_TYPE);
    @Option(name="FilterMimeType", help="Only profile languages with mime-type. (eg. application/javascript) (default: no filter).", usageSyntax="<mime-type>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> FILTER_MIME_TYPE = new OptionKey((Object)"");
    @Option(name="FilterLanguage", help="Only profile languages with given ID. (eg. js) (default: no filter).", usageSyntax="<languageId>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> FILTER_LANGUAGE = new OptionKey((Object)"");
    @Option(name="Output", help="Print a 'histogram' or 'json' as output (default: histogram).", usageSyntax="histogram|json", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Output> OUTPUT = new OptionKey((Object)Output.HISTOGRAM, CLI_OUTPUT_TYPE);
    @Option(name="OutputFile", help="Save output to the given file. Output is printed to standard output stream by default.", usageSyntax="<path>", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> OUTPUT_FILE = new OptionKey((Object)"");

    CPUTracerCLI() {
    }

    public static void handleOutput(TruffleInstrument.Env env, CPUTracer tracer) {
        PrintStream out = CPUTracerCLI.chooseOutputStream(env, OUTPUT_FILE);
        switch ((Output)((Object)env.getOptions().get(OUTPUT))) {
            case HISTOGRAM: {
                CPUTracerCLI.printTracerHistogram(out, tracer);
                break;
            }
            case JSON: {
                CPUTracerCLI.printTracerJson(out, tracer);
            }
        }
    }

    private static void printTracerJson(PrintStream out, CPUTracer tracer) {
        JSONObject output = new JSONObject();
        output.put("tool", (Object)"cputracer");
        output.put("version", (Object)"0.3.0");
        ArrayList<CPUTracer.Payload> payloads = new ArrayList<CPUTracer.Payload>(tracer.getPayloads());
        JSONArray profile = new JSONArray();
        for (CPUTracer.Payload payload : payloads) {
            JSONObject entry = new JSONObject();
            entry.put("root_name", (Object)payload.getRootName());
            entry.put("source_section", (Object)CPUTracerCLI.sourceSectionToJSON(payload.getSourceSection()));
            entry.put("count", payload.getCount());
            entry.put("interpreted_count", payload.getCountInterpreted());
            entry.put("compiled_count", payload.getCountCompiled());
            profile.put((Object)entry);
        }
        output.put("profile", (Object)profile);
        out.println(output.toString());
    }

    static void printTracerHistogram(PrintStream out, CPUTracer tracer) {
        ArrayList<CPUTracer.Payload> payloads = new ArrayList<CPUTracer.Payload>(tracer.getPayloads());
        payloads.sort(new Comparator<CPUTracer.Payload>(){

            @Override
            public int compare(CPUTracer.Payload o1, CPUTracer.Payload o2) {
                return Long.compare(o2.getCount(), o1.getCount());
            }
        });
        int length = CPUTracerCLI.computeNameLength(payloads, 50);
        String format = " %-" + length + "s | %20s | %20s | %20s | %s";
        String title = CPUTracerCLI.format(format, "Name", "Total Count", "Interpreted Count", "Compiled Count", "Location");
        String sep = CPUTracerCLI.repeat("-", title.length());
        long totalCount = 0L;
        for (CPUTracer.Payload payload : payloads) {
            totalCount += payload.getCount();
        }
        out.println(sep);
        out.println(CPUTracerCLI.format("Tracing Histogram. Counted a total of %d element executions.", totalCount));
        out.println("  Total Count: Number of times the element was executed and percentage of total executions.");
        out.println("  Interpreted Count: Number of times the element was interpreted and percentage of total executions of this element.");
        out.println("  Compiled Count: Number of times the compiled element was executed and percentage of total executions of this element.");
        out.println(sep);
        out.println(title);
        out.println(sep);
        for (CPUTracer.Payload payload : payloads) {
            String total = CPUTracerCLI.format("%d %5.1f%%", payload.getCount(), (double)payload.getCount() * 100.0 / (double)totalCount);
            String interpreted = CPUTracerCLI.format("%d %5.1f%%", payload.getCountInterpreted(), (double)payload.getCountInterpreted() * 100.0 / (double)payload.getCount());
            String compiled = CPUTracerCLI.format("%d %5.1f%%", payload.getCountCompiled(), (double)payload.getCountCompiled() * 100.0 / (double)payload.getCount());
            out.println(CPUTracerCLI.format(format, payload.getRootName(), total, interpreted, compiled, CPUTracerCLI.getShortDescription(payload.getSourceSection())));
        }
        out.println(sep);
    }

    private static int computeNameLength(Collection<CPUTracer.Payload> payloads, int limit) {
        int maxLength = 6;
        for (CPUTracer.Payload payload : payloads) {
            int rootNameLength = payload.getRootName().length();
            maxLength = Math.max(rootNameLength + 2, maxLength);
            maxLength = Math.min(maxLength, limit);
        }
        return maxLength;
    }

    private static String format(String format, Object ... args) {
        return String.format(Locale.ENGLISH, format, args);
    }

    static enum Output {
        HISTOGRAM,
        JSON;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

