/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.api.debug.DebugStackTraceElement;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.ScriptsHandler;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;

public final class StackTrace {
    private final JSONObject jsonObject = new JSONObject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTrace(InspectorExecutionContext context, Iterable<DebugStackTraceElement> frames) {
        JSONArray callFrames = new JSONArray();
        for (DebugStackTraceElement frame : frames) {
            SourceSection sourceSection = frame.getSourceSection();
            if (sourceSection == null || !context.isInspectInternal() && frame.isInternal()) continue;
            Source source = sourceSection.getSource();
            if (!context.isInspectInternal() && source.isInternal()) continue;
            JSONObject callFrame = new JSONObject();
            callFrame.put("functionName", (Object)frame.getName());
            ScriptsHandler sch = context.acquireScriptsHandler();
            try {
                int scriptId = sch.assureLoaded(source);
                if (scriptId == -1) continue;
                callFrame.put("scriptId", (Object)Integer.toString(scriptId));
                callFrame.put("url", (Object)sch.getScript(scriptId).getUrl());
                callFrame.put("lineNumber", sourceSection.getStartLine() - 1);
                callFrame.put("columnNumber", sourceSection.getStartColumn() - 1);
                callFrames.put((Object)callFrame);
            }
            finally {
                context.releaseScriptsHandler();
            }
        }
        this.jsonObject.put("callFrames", (Object)callFrames);
    }

    public JSONObject toJSON() {
        return this.jsonObject;
    }
}

