/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.SuspendAnchor;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.chromeinspector.types.Location;
import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import com.oracle.truffle.tools.chromeinspector.types.Scope;
import com.oracle.truffle.tools.chromeinspector.types.Script;
import com.oracle.truffle.tools.utils.json.JSONObject;

public final class CallFrame {
    private final DebugStackFrame frame;
    private final int depth;
    private final Location location;
    private final Location functionLocation;
    private final String url;
    private final RemoteObject thisObject;
    private final RemoteObject returnObject;
    private final Scope[] scopes;

    public CallFrame(DebugStackFrame frame, int depth, Script script, SourceSection sourceSection, SuspendAnchor anchor, SourceSection functionSourceSection, RemoteObject thisObject, RemoteObject returnObject, Scope ... scopes) {
        this.frame = frame;
        this.depth = depth;
        this.location = anchor == SuspendAnchor.BEFORE ? new Location(script.getId(), sourceSection.getStartLine(), sourceSection.getStartColumn()) : new Location(script.getId(), sourceSection.getEndLine(), sourceSection.getEndColumn());
        this.functionLocation = functionSourceSection != null ? new Location(script.getId(), functionSourceSection.getStartLine(), functionSourceSection.getStartColumn()) : null;
        this.url = script.getUrl();
        this.thisObject = thisObject;
        this.returnObject = returnObject;
        this.scopes = scopes;
    }

    public DebugStackFrame getFrame() {
        return this.frame;
    }

    public String getFunctionName() {
        return this.frame.getName();
    }

    public Location getLocation() {
        return this.location;
    }

    public Scope[] getScopeChain() {
        return this.scopes;
    }

    public RemoteObject getThis() {
        return this.thisObject;
    }

    private JSONObject createJSON() {
        JSONObject json = new JSONObject();
        json.put("callFrameId", (Object)Integer.toString(this.depth));
        json.put("functionName", (Object)this.frame.getName());
        json.put("location", (Object)this.location.toJSON());
        json.putOpt("functionLocation", this.functionLocation != null ? this.functionLocation.toJSON() : null);
        json.put("url", (Object)this.url);
        json.put("scopeChain", (Object)Scope.createScopesJSON(this.scopes));
        json.put("this", (Object)this.thisObject.toJSON());
        if (this.returnObject != null) {
            json.put("returnValue", (Object)this.returnObject.toJSON());
        }
        return json;
    }

    public JSONObject toJSON() {
        return this.createJSON();
    }
}

