/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.expression.CallArithmeticRootNode;
import com.oracle.graal.python.nodes.expression.UnaryArithmeticFactory;
import com.oracle.graal.python.nodes.expression.UnaryOpNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.strings.TruffleString;

public enum UnaryArithmetic {
    Pos(UnaryArithmeticFactory.PosNodeGen::create),
    Neg(UnaryArithmeticFactory.NegNodeGen::create),
    Invert(UnaryArithmeticFactory.InvertNodeGen::create);

    private final CreateUnaryOp create;

    private UnaryArithmetic(CreateUnaryOp create) {
        this.create = create;
    }

    public UnaryOpNode create() {
        return this.create.create();
    }

    public RootNode createRootNode(PythonLanguage language) {
        return new CallUnaryArithmeticRootNode(language, this);
    }

    static interface CreateUnaryOp {
        public UnaryOpNode create();
    }

    static final class CallUnaryArithmeticRootNode
    extends CallArithmeticRootNode {
        private static final Signature SIGNATURE_UNARY = new Signature(1, false, -1, false, PythonUtils.tsArray("$self"), null);
        @Node.Child
        private UnaryOpNode callUnaryNode;
        private final UnaryArithmetic unaryOperator;

        CallUnaryArithmeticRootNode(PythonLanguage language, UnaryArithmetic unaryOperator) {
            super(language);
            this.unaryOperator = unaryOperator;
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE_UNARY;
        }

        @Override
        protected Object doCall(VirtualFrame frame) {
            if (this.callUnaryNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callUnaryNode = (UnaryOpNode)this.insert(this.unaryOperator.create());
            }
            return this.callUnaryNode.executeCached(frame, PArguments.getArgument((Frame)frame, 0));
        }
    }

    @GenerateCached
    public static abstract class GenericUnaryArithmeticNode
    extends UnaryArithmeticNode {
        private final TruffleString specialMethodName;

        protected GenericUnaryArithmeticNode(TruffleString specialMethodName) {
            this.specialMethodName = specialMethodName;
        }

        @Override
        public final Object execute(VirtualFrame frame, Node inliningTarget, Object value) {
            return this.execute(frame, value);
        }

        protected abstract Object execute(VirtualFrame var1, Object var2);

        @Specialization
        public Object doGeneric(VirtualFrame frame, Object arg, @Cached(value="createCallNode()") LookupAndCallUnaryNode callNode) {
            return callNode.executeObject(frame, arg);
        }

        @NeverDefault
        protected LookupAndCallUnaryNode createCallNode() {
            return GenericUnaryArithmeticNode.createCallNode(this.specialMethodName, GenericUnaryArithmeticNode.createHandler(this.specialMethodName.toString()));
        }

        @NeverDefault
        public static GenericUnaryArithmeticNode create(TruffleString specialMethodName) {
            return UnaryArithmeticFactory.GenericUnaryArithmeticNodeGen.create(specialMethodName);
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    public static abstract class InvertNode
    extends UnaryArithmeticNode {
        public static final Supplier<LookupAndCallUnaryNode.NoAttributeHandler> NOT_IMPLEMENTED = InvertNode.createHandler("~");

        @Specialization
        public static int invert(boolean arg) {
            return ~(arg ? 1 : 0);
        }

        @Specialization
        public static int invert(int arg) {
            return ~arg;
        }

        @Specialization
        public static long invert(long arg) {
            return arg ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object arg, @Cached(value="createCallNode(T___INVERT__, NOT_IMPLEMENTED)", inline=false) LookupAndCallUnaryNode callNode) {
            return callNode.executeObject(frame, arg);
        }

        @NeverDefault
        public static InvertNode create() {
            return UnaryArithmeticFactory.InvertNodeGen.create();
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    public static abstract class NegNode
    extends UnaryArithmeticNode {
        public static final Supplier<LookupAndCallUnaryNode.NoAttributeHandler> NOT_IMPLEMENTED = NegNode.createHandler("-");

        @Specialization(rewriteOn={ArithmeticException.class})
        public static int neg(int arg) {
            return Math.negateExact(arg);
        }

        @Specialization
        public static long negOvf(int arg) {
            return -((long)arg);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public static long neg(long arg) {
            return Math.negateExact(arg);
        }

        @Specialization
        public static double neg(double arg) {
            return -arg;
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object arg, @Cached(value="createCallNode(T___NEG__, NOT_IMPLEMENTED)", inline=false) LookupAndCallUnaryNode callNode) {
            return callNode.executeObject(frame, arg);
        }

        @NeverDefault
        public static NegNode create() {
            return UnaryArithmeticFactory.NegNodeGen.create();
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    public static abstract class PosNode
    extends UnaryArithmeticNode {
        public static final Supplier<LookupAndCallUnaryNode.NoAttributeHandler> NOT_IMPLEMENTED = PosNode.createHandler("+");

        @Specialization
        public static int pos(int arg) {
            return arg;
        }

        @Specialization
        public static long pos(long arg) {
            return arg;
        }

        @Specialization
        public static double pos(double arg) {
            return arg;
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object arg, @Cached(value="createCallNode(T___POS__, NOT_IMPLEMENTED)", inline=false) LookupAndCallUnaryNode callNode) {
            return callNode.executeObject(frame, arg);
        }

        @NeverDefault
        public static PosNode create() {
            return UnaryArithmeticFactory.PosNodeGen.create();
        }
    }

    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class UnaryArithmeticNode
    extends UnaryOpNode {
        static Supplier<LookupAndCallUnaryNode.NoAttributeHandler> createHandler(final String operator) {
            return () -> new LookupAndCallUnaryNode.NoAttributeHandler(){
                @Node.Child
                private PRaiseNode raiseNode = PRaiseNode.create();

                @Override
                public Object execute(Object receiver) {
                    throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.BAD_OPERAND_FOR, "unary ", operator, receiver);
                }
            };
        }

        @NeverDefault
        public static LookupAndCallUnaryNode createCallNode(TruffleString name, Supplier<LookupAndCallUnaryNode.NoAttributeHandler> handler) {
            return LookupAndCallUnaryNode.create(name, handler);
        }
    }
}

