/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.lib.PyOSFSPathNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(value=false)
public abstract class PyUnicodeFSDecoderNode
extends PNodeWithContext {
    public abstract TruffleString execute(Frame var1, Object var2);

    @Specialization
    TruffleString doString(TruffleString object, @Cached.Shared(value="byteIndexOfCP") @Cached TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode) {
        return PyUnicodeFSDecoderNode.checkString(this, object, byteIndexOfCodePointNode);
    }

    @Specialization
    static TruffleString doPString(PString object, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode cast, @Cached.Shared(value="byteIndexOfCP") @Cached TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode) {
        return PyUnicodeFSDecoderNode.checkString(inliningTarget, cast.execute(inliningTarget, object), byteIndexOfCodePointNode);
    }

    @Specialization(limit="1")
    TruffleString doBytes(PBytes object, @CachedLibrary(value="object") PythonBufferAccessLibrary bufferLib, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared(value="byteIndexOfCP") @Cached TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode) {
        TruffleString utf8 = fromByteArrayNode.execute(bufferLib.getCopiedByteArray(object), TruffleString.Encoding.UTF_8, false);
        return PyUnicodeFSDecoderNode.checkString(this, switchEncodingNode.execute((AbstractTruffleString)utf8, PythonUtils.TS_ENCODING), byteIndexOfCodePointNode);
    }

    @Fallback
    static TruffleString doPathLike(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached PyOSFSPathNode fspathNode, @Cached PyUnicodeFSDecoderNode recursive) {
        Object path = fspathNode.execute((Frame)frame, inliningTarget, object);
        assert (path instanceof TruffleString || path instanceof PString || path instanceof PBytes);
        return recursive.execute((Frame)frame, path);
    }

    private static TruffleString checkString(Node raisingNode, TruffleString str, TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode) {
        if (byteIndexOfCodePointNode.execute((AbstractTruffleString)str, 0, 0, str.byteLength(PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0) {
            throw PRaiseNode.raiseUncached(raisingNode, PythonBuiltinClassType.ValueError, ErrorMessages.EMBEDDED_NULL_BYTE);
        }
        return str;
    }
}

