/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.traceback;

import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.nodes.bytecode.FrameInfo;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;

public class LazyTraceback {
    private final PFrame.Reference frameInfo;
    private final PFrame frame;
    private final PException exception;
    private final LazyTraceback nextChain;
    private PTraceback traceback;
    private boolean materialized;

    public LazyTraceback(PFrame.Reference frameInfo, PException exception, LazyTraceback nextChain) {
        this.frame = null;
        this.frameInfo = frameInfo;
        this.exception = exception;
        this.nextChain = nextChain;
        this.materialized = false;
    }

    public LazyTraceback(PFrame frame, PException exception, LazyTraceback nextChain) {
        this.frame = frame;
        this.frameInfo = null;
        this.exception = exception;
        this.nextChain = nextChain;
        this.materialized = false;
    }

    public LazyTraceback(PTraceback traceback) {
        this.traceback = traceback;
        this.frameInfo = null;
        this.frame = null;
        this.nextChain = null;
        this.exception = null;
        this.materialized = true;
    }

    public PFrame.Reference getFrameInfo() {
        return this.frameInfo;
    }

    public PFrame getFrame() {
        return this.frame;
    }

    public PException getException() {
        return this.exception;
    }

    public LazyTraceback getNextChain() {
        return this.nextChain;
    }

    public PTraceback getTraceback() {
        return this.traceback;
    }

    public void setTraceback(PTraceback traceback) {
        this.traceback = traceback;
        this.materialized = true;
    }

    @CompilerDirectives.TruffleBoundary
    public static int getSourceLineNoOrDefault(PException exception, int defaultValue) {
        SourceSection sourceSection;
        Node location = exception.getLocation();
        if (location != null && (sourceSection = location.getSourceSection()) != null) {
            return sourceSection.getStartLine();
        }
        return defaultValue;
    }

    public int getLineNo() {
        if (this.exception != null) {
            return LazyTraceback.getSourceLineNoOrDefault(this.exception, -2);
        }
        return -2;
    }

    public boolean isMaterialized() {
        return this.materialized;
    }

    public boolean isEmptySegment() {
        if (this.materialized) {
            return this.traceback == null;
        }
        int count = this.exception.getTracebackFrameCount();
        if (this.catchingFrameWantedForTraceback()) {
            ++count;
        }
        return count <= 0;
    }

    public static boolean elementWantedForTraceback(TruffleStackTraceElement element) {
        Object info;
        Frame frame = element.getFrame();
        if (frame != null && (info = frame.getFrameDescriptor().getInfo()) instanceof FrameInfo) {
            return ((FrameInfo)info).getRootNode().frameIsVisibleToPython();
        }
        return false;
    }

    public boolean catchingFrameWantedForTraceback() {
        return (this.frame != null || this.frameInfo != null) && this.exception != null && this.exception.catchingFrameWantedForTraceback();
    }
}

