/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.PZipLongest;
import com.oracle.graal.python.builtins.objects.itertools.ZipLongestBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PZipLongest})
public final class ZipLongestBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ZipLongestBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(PZipLongest self, Object state) {
            self.setFillValue(state);
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PZipLongest self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClass, @Cached InlinedConditionProfile noFillValueProfile, @Cached InlinedLoopConditionProfile loopProfile, @Cached InlinedConditionProfile noItProfile, @Cached PythonObjectFactory factory) {
            Object fillValue = self.getFillValue();
            if (noFillValueProfile.profile(inliningTarget, fillValue == null)) {
                fillValue = PNone.NONE;
            }
            Object type = getClass.execute(inliningTarget, self);
            Object[] its = new Object[self.getItTuple().length];
            loopProfile.profileCounted(inliningTarget, (long)its.length);
            int i = 0;
            while (loopProfile.profile(inliningTarget, i < its.length)) {
                Object it = self.getItTuple()[i];
                its[i] = noItProfile.profile(inliningTarget, it == PNone.NONE) ? factory.createEmptyTuple() : it;
                ++i;
            }
            PTuple tuple = factory.createTuple(its);
            return factory.createTuple(new Object[]{type, tuple, fillValue});
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"zeroSize(self)"})
        static Object nextNoFillValue(VirtualFrame frame, PZipLongest self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raiseStopIteration();
        }

        @Specialization(guards={"!zeroSize(self)"})
        static Object next(VirtualFrame frame, PZipLongest self, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.NextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIterationProfile, @Cached InlinedConditionProfile noItProfile, @Cached InlinedConditionProfile noActiveProfile, @Cached InlinedLoopConditionProfile loopProfile, @Cached InlinedConditionProfile isNullFillProfile, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object fillValue = isNullFillProfile.profile(inliningTarget, NextNode.isNullFillValue(self)) ? PNone.NONE : self.getFillValue();
            return NextNode.next(frame, inliningTarget, self, fillValue, nextNode, isStopIterationProfile, loopProfile, noItProfile, noActiveProfile, factory, raiseNode);
        }

        private static Object next(VirtualFrame frame, Node inliningTarget, PZipLongest self, Object fillValue, BuiltinFunctions.NextNode nextNode, BuiltinClassProfiles.IsBuiltinObjectProfile isStopIterationProfile, InlinedLoopConditionProfile loopProfile, InlinedConditionProfile noItProfile, InlinedConditionProfile noActiveProfile, PythonObjectFactory factory, PRaiseNode.Lazy raiseNode) {
            Object[] result = new Object[self.getItTuple().length];
            loopProfile.profileCounted(inliningTarget, (long)result.length);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < result.length)) {
                Object item;
                Object it = self.getItTuple()[i];
                if (noItProfile.profile(inliningTarget, it == PNone.NONE)) {
                    item = fillValue;
                } else {
                    try {
                        item = nextNode.execute(frame, it, PNone.NO_VALUE);
                    }
                    catch (PException e) {
                        if (isStopIterationProfile.profileException(inliningTarget, e, PythonBuiltinClassType.StopIteration)) {
                            self.setNumActive(self.getNumActive() - 1);
                            if (noActiveProfile.profile(inliningTarget, self.getNumActive() == 0)) {
                                throw raiseNode.get(inliningTarget).raiseStopIteration();
                            }
                            item = fillValue;
                            self.getItTuple()[i] = PNone.NONE;
                        }
                        self.setNumActive(0);
                        throw e;
                    }
                }
                result[i] = item;
                ++i;
            }
            return factory.createTuple(result);
        }

        protected static boolean isNullFillValue(PZipLongest self) {
            return self.getFillValue() == null;
        }

        protected static boolean zeroSize(PZipLongest self) {
            return self.getItTuple().length == 0 || self.getNumActive() == 0;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PZipLongest self) {
            return self;
        }
    }
}

