/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.getsetdescriptor;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorBuiltins;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptorTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptorTypeBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.IndexedSlotDescriptor;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSet;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.GetSetDescriptor})
public final class GetSetDescriptorTypeBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = GetSetDescriptorTypeBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GetSetDescriptorTypeBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_descr_set, isComplex=true)
    @GenerateNodeFactory
    static abstract class DescrSet
    extends TpSlotDescrSet.DescrSetBuiltinNode {
        DescrSet() {
        }

        @Specialization(guards={"!isNoValue(value)"})
        static void doDescriptorSet(VirtualFrame frame, Object descr, Object obj, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile isGetSetDescrProfile, @Cached.Shared @Cached DescriptorBuiltins.DescriptorCheckNode descriptorCheckNode, @Cached DescriptorBuiltins.DescrSetNode setNode) {
            TruffleString name;
            Object type;
            if (isGetSetDescrProfile.profile(inliningTarget, descr instanceof GetSetDescriptor)) {
                GetSetDescriptor getSet = (GetSetDescriptor)descr;
                type = getSet.getType();
                name = getSet.getName();
            } else if (descr instanceof IndexedSlotDescriptor) {
                IndexedSlotDescriptor hidden = (IndexedSlotDescriptor)descr;
                type = hidden.getType();
                name = hidden.getName();
            } else {
                throw CompilerDirectives.shouldNotReachHere((String)"Not a GetSetDescriptor nor IndexedSlotDescriptor");
            }
            descriptorCheckNode.execute(inliningTarget, type, name, obj);
            setNode.execute(frame, descr, obj, value);
        }

        @Specialization(guards={"isNoValue(value)"})
        static void doDescriptorDel(VirtualFrame frame, Object descr, Object obj, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile isGetSetDescrProfile, @Cached.Shared @Cached DescriptorBuiltins.DescriptorCheckNode descriptorCheckNode, @Cached DescriptorBuiltins.DescrDeleteNode deleteNode) {
            TruffleString name;
            Object type;
            if (isGetSetDescrProfile.profile(inliningTarget, descr instanceof GetSetDescriptor)) {
                GetSetDescriptor getSet = (GetSetDescriptor)descr;
                type = getSet.getType();
                name = getSet.getName();
            } else if (descr instanceof IndexedSlotDescriptor) {
                IndexedSlotDescriptor hidden = (IndexedSlotDescriptor)descr;
                type = hidden.getType();
                name = hidden.getName();
            } else {
                throw CompilerDirectives.shouldNotReachHere((String)"Not a GetSetDescriptor nor IndexedSlotDescriptor");
            }
            descriptorCheckNode.execute(inliningTarget, type, name, obj);
            deleteNode.execute(frame, descr, obj);
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_get, isComplex=true)
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class GetSetGetNode
    extends TpSlotDescrGet.DescrGetBuiltinNode {
        GetSetGetNode() {
        }

        @Specialization(guards={"isNoValue(obj)"})
        static Object doNone(Object descr, Object obj, Object type) {
            return descr;
        }

        @Specialization(guards={"!isNoValue(obj)"})
        static Object doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor descr, Object obj, Object type, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached DescriptorBuiltins.DescriptorCheckNode descriptorCheckNode, @Cached.Shared @Cached DescriptorBuiltins.DescrGetNode getNode) {
            descriptorCheckNode.execute(inliningTarget, descr.getType(), descr.getName(), obj);
            return getNode.execute(frame, descr, obj);
        }

        @Specialization(guards={"!isNoValue(obj)"})
        static Object doIndexedSlotDescriptor(VirtualFrame frame, IndexedSlotDescriptor descr, Object obj, Object type, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached DescriptorBuiltins.DescriptorCheckNode descriptorCheckNode, @Cached.Shared @Cached DescriptorBuiltins.DescrGetNode getNode) {
            descriptorCheckNode.execute(inliningTarget, descr.getType(), descr.getName(), obj);
            return getNode.execute(frame, descr, obj);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetSetReprNode
    extends PythonUnaryBuiltinNode {
        GetSetReprNode() {
        }

        @Specialization
        TruffleString repr(GetSetDescriptor descr, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="gerName") @Cached TypeNodes.GetNameNode getName, @Cached.Shared(value="format") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<attribute '%s' of '%s' objects>", descr.getName(), getName.execute(inliningTarget, descr.getType()));
        }

        @Specialization
        TruffleString repr(IndexedSlotDescriptor descr, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="gerName") @Cached TypeNodes.GetNameNode getName, @Cached.Shared(value="format") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<attribute '%s' of '%s' objects>", descr.getName(), getName.execute(inliningTarget, descr.getType()));
        }
    }

    @Builtin(name="__objclass__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class ObjclassNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGetSetDescriptor(GetSetDescriptor self) {
            return self.getType();
        }

        @Specialization
        static Object doIndexedSlotDescriptor(IndexedSlotDescriptor self) {
            return self.getType();
        }
    }
}

