/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.builtins.objects.common.SequenceNodesFactory;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ForeignSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

public abstract class SequenceNodes {

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CheckIsSequenceNode
    extends Node {
        public abstract void execute(Node var1, Object var2);

        @Specialization
        static void check(Node inliningTarget, Object obj, @Cached PySequenceCheckNode sequenceCheckNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (!sequenceCheckNode.execute(inliningTarget, obj)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.IS_NOT_A_SEQUENCE, obj);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetSequenceStorageNode
    extends Node {
        public abstract void execute(Node var1, PSequence var2, SequenceStorage var3);

        public static void executeUncached(PSequence s, SequenceStorage storage) {
            SequenceNodesFactory.SetSequenceStorageNodeGen.getUncached().execute(null, s, storage);
        }

        @Specialization(guards={"s.getClass() == cachedClass"}, limit="1")
        static void doSpecial(PSequence s, SequenceStorage storage, @Cached(value="s.getClass()") Class<? extends PSequence> cachedClass) {
            cachedClass.cast(s).setSequenceStorage(storage);
        }

        @Specialization(replaces={"doSpecial"})
        @CompilerDirectives.TruffleBoundary
        static void doGeneric(PSequence s, SequenceStorage storage) {
            s.setSequenceStorage(storage);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CachedGetObjectArrayNode
    extends Node {
        public abstract Object[] execute(Object var1);

        @Specialization
        Object[] doIt(Object seq, @Cached GetObjectArrayNode node) {
            return node.execute(this, seq);
        }

        public static CachedGetObjectArrayNode create() {
            return SequenceNodesFactory.CachedGetObjectArrayNodeGen.create();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetObjectArrayNode
    extends Node {
        public abstract Object[] execute(Node var1, Object var2);

        public static Object[] executeUncached(Object seq) {
            return SequenceNodesFactory.GetObjectArrayNodeGen.getUncached().execute(null, seq);
        }

        @Specialization
        static Object[] doGeneric(Node inliningTarget, Object seq, @Cached GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.ToArrayNode toArrayNode) {
            return toArrayNode.execute(inliningTarget, getSequenceStorageNode.execute(inliningTarget, seq));
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class GetSequenceStorageNode
    extends PNodeWithContext {
        public abstract SequenceStorage execute(Node var1, Object var2);

        public static SequenceStorage executeUncached(Object seq) {
            return SequenceNodesFactory.GetSequenceStorageNodeGen.getUncached().execute(null, seq);
        }

        public final SequenceStorage executeCached(Object seq) {
            return this.execute(this, seq);
        }

        @Specialization(guards={"seq.getClass() == cachedClass"}, limit="2")
        static SequenceStorage doSequenceCached(PSequence seq, @Cached(value="seq.getClass()") Class<? extends PSequence> cachedClass) {
            return ((PSequence)CompilerDirectives.castExact((Object)seq, cachedClass)).getSequenceStorage();
        }

        @Specialization(replaces={"doSequenceCached"})
        static SequenceStorage doSequence(PSequence seq) {
            return seq.getSequenceStorage();
        }

        @Specialization(guards={"isForeignObjectNode.execute(inliningTarget, seq)", "interop.hasArrayElements(seq)"}, limit="1")
        static SequenceStorage doForeign(Node inliningTarget, Object seq, @Cached IsForeignObjectNode isForeignObjectNode, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached InlinedBranchProfile errorProfile) {
            try {
                long size = interop.getArraySize(seq);
                return new ForeignSequenceStorage(seq, PInt.long2int(inliningTarget, size, errorProfile));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Fallback
        static SequenceStorage doFallback(Node inliningTarget, Object seq, @Cached PRaiseNode.Lazy raiseNode) {
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.IS_NOT_A_SEQUENCE, seq);
        }

        @NeverDefault
        public static GetSequenceStorageNode create() {
            return SequenceNodesFactory.GetSequenceStorageNodeGen.create();
        }

        @NeverDefault
        public static GetSequenceStorageNode getUncached() {
            return SequenceNodesFactory.GetSequenceStorageNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class IsInBoundsNode
    extends Node {
        public abstract boolean execute(Node var1, PSequence var2, long var3);

        @Specialization
        static boolean doString(PString str, long idx, @Cached(inline=false) StringNodes.StringLenNode lenNode) {
            int length = lenNode.execute(str);
            return 0L <= idx && idx < (long)length;
        }

        @Specialization(guards={"!isPString(seq)"})
        static boolean doWithStorage(Node inliningTarget, PSequence seq, long idx, @Cached GetSequenceStorageNode getStorage) {
            int length = getStorage.execute(inliningTarget, seq).length();
            return 0L <= idx && idx < (long)length;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class LenNode
    extends Node {
        public abstract int execute(Node var1, PSequence var2);

        public static int executeUncached(PSequence seq) {
            return SequenceNodesFactory.LenNodeGen.getUncached().execute(null, seq);
        }

        @Specialization
        static int doPString(PString str, @Cached(inline=false) StringNodes.StringLenNode lenNode) {
            return lenNode.execute(str);
        }

        @Specialization(guards={"!isPString(seq)"})
        static int doWithStorage(Node inliningTarget, PSequence seq, @Cached GetSequenceStorageNode getStorage) {
            return getStorage.execute(inliningTarget, seq).length();
        }
    }
}

