/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.functools;

import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;

public final class PPartial
extends PythonBuiltinObject {
    private Object fn;
    private Object[] args;
    private PTuple argsTuple;
    private PDict kw;

    public PPartial(Object cls, Shape instanceShape, Object fn, Object[] args, PDict kw) {
        super(cls, instanceShape);
        this.fn = fn;
        this.args = args;
        this.kw = kw;
    }

    public Object getFn() {
        return this.fn;
    }

    public void setFn(Object fn) {
        this.fn = fn;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public PTuple getArgsTuple(PythonObjectFactory factory) {
        if (this.argsTuple == null) {
            this.argsTuple = factory.createTuple(this.args);
        }
        return this.argsTuple;
    }

    public void setArgs(Node inliningTarget, PTuple args, SequenceNodes.GetSequenceStorageNode storageNode, SequenceStorageNodes.ToArrayNode arrayNode) {
        this.argsTuple = args;
        this.args = arrayNode.execute(inliningTarget, storageNode.execute(inliningTarget, args));
    }

    public PDict getKw() {
        return this.kw;
    }

    public PDict getOrCreateKw(PythonObjectFactory factory) {
        if (this.kw == null) {
            this.kw = factory.createDict();
        }
        return this.kw;
    }

    public PDict getKwCopy(Node inliningTarget, PythonObjectFactory factory, HashingStorageNodes.HashingStorageCopy copyNode) {
        assert (this.kw != null);
        return factory.createDict(copyNode.execute(inliningTarget, this.kw.getDictStorage()));
    }

    public boolean hasKw(Node inliningTarget, HashingStorageNodes.HashingStorageLen lenNode) {
        return lenNode.execute(inliningTarget, this.kw.getDictStorage()) > 0;
    }

    public void setKw(PDict kwArgs) {
        this.kw = kwArgs;
    }
}

