/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.thread.AbstractPythonLock;
import com.oracle.graal.python.builtins.objects.thread.PLock;
import com.oracle.graal.python.builtins.objects.thread.PRLock;
import com.oracle.graal.python.builtins.objects.thread.PThread;
import com.oracle.graal.python.builtins.objects.thread.PThreadLocal;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.WriteUnraisableNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonThreadKillException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleThreadBuilder;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.ref.WeakReference;
import java.util.List;

@CoreFunctions(defineModule="_thread")
public final class ThreadModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ThreadModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("error", (Object)core.lookupType(PythonBuiltinClassType.RuntimeError));
        this.addBuiltinConstant("TIMEOUT_MAX", (Object)AbstractPythonLock.TIMEOUT_MAX);
        core.lookupBuiltinModule(BuiltinNames.T__THREAD).setModuleState(0);
        super.initialize(core);
    }

    @Builtins(value={@Builtin(name="exit"), @Builtin(name="exit_thread")})
    @GenerateNodeFactory
    static abstract class ExitThreadNode
    extends PythonBuiltinNode {
        ExitThreadNode() {
        }

        @Specialization
        static Object exit(@Cached PRaiseNode raiseNode) {
            throw raiseNode.raiseSystemExit(PNone.NONE);
        }
    }

    @Builtin(name="interrupt_main", parameterNames={"signum"}, doc="interrupt_main()\n\nRaise a KeyboardInterrupt in the main thread.\nA subthread can use this function to interrupt the main thread.")
    @ArgumentClinic(name="signum", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="SIGINT")
    @GenerateNodeFactory
    static abstract class InterruptMainThreadNode
    extends PythonUnaryClinicBuiltinNode {
        static final int SIGINT = 2;

        InterruptMainThreadNode() {
        }

        @Specialization
        Object getCount(int signum) {
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ThreadModuleBuiltinsClinicProviders.InterruptMainThreadNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="_set_sentinel", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class SetSentinelNode
    extends PythonBuiltinNode {
        SetSentinelNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object setSentinel() {
            PLock sentinelLock = PythonObjectFactory.getUncached().createLock();
            PythonContext.get(this).setSentinelLockWeakref(new WeakReference<PLock>(sentinelLock));
            return sentinelLock;
        }
    }

    @Builtins(value={@Builtin(name="start_new_thread", minNumOfPositionalArgs=3, maxNumOfPositionalArgs=4, constructsClass=PythonBuiltinClassType.PThread), @Builtin(name="start_new", minNumOfPositionalArgs=3, maxNumOfPositionalArgs=4)})
    @GenerateNodeFactory
    static abstract class StartNewThreadNode
    extends PythonBuiltinNode {
        private static final TruffleString IN_THREAD_STARTED_BY = PythonUtils.tsLiteral("in thread started by");

        StartNewThreadNode() {
        }

        @Specialization
        long start(VirtualFrame frame, Object cls, Object callable, Object args, Object kwargs, @Bind(value="this") Node inliningTarget, @Cached CallNode callNode, @Cached ExecutePositionalStarargsNode getArgsNode, @Cached ExpandKeywordStarargsNode getKwArgsNode, @Cached PythonObjectFactory factory) {
            PythonContext context = this.getContext();
            TruffleLanguage.Env env = context.getEnv();
            PythonModule threadModule = context.lookupBuiltinModule(BuiltinNames.T__THREAD);
            Object[] arguments = getArgsNode.executeWith((Frame)frame, args);
            PKeyword[] keywords = getKwArgsNode.execute(frame, inliningTarget, kwargs);
            TruffleThreadBuilder threadBuilder = env.newTruffleThreadBuilder(() -> {
                block16: {
                    try (GilNode.UncachedAcquire gil = GilNode.uncachedAcquire();){
                        int curCount = threadModule.getModuleState(Integer.class);
                        threadModule.setModuleState(curCount + 1);
                        try {
                            callNode.execute((Frame)null, callable, arguments, keywords);
                        }
                        catch (PythonThreadKillException e) {
                            curCount = threadModule.getModuleState(Integer.class);
                            threadModule.setModuleState(curCount - 1);
                            if (gil != null) {
                                gil.close();
                            }
                            return;
                        }
                        catch (PException e) {
                            if (!BuiltinClassProfiles.IsBuiltinObjectProfile.profileObjectUncached(e.getUnreifiedException(), PythonBuiltinClassType.SystemExit)) {
                                WriteUnraisableNode.getUncached().execute(e.getUnreifiedException(), IN_THREAD_STARTED_BY, callable);
                            }
                            break block16;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            finally {
                                curCount = threadModule.getModuleState(Integer.class);
                                threadModule.setModuleState(curCount - 1);
                            }
                        }
                        curCount = threadModule.getModuleState(Integer.class);
                        threadModule.setModuleState(curCount - 1);
                    }
                }
            }).context(env.getContext()).threadGroup(context.getThreadGroup());
            PThread pThread = factory.createPythonThread(cls, threadBuilder.build());
            pThread.start();
            return pThread.getId();
        }
    }

    @Builtin(name="stack_size", minNumOfPositionalArgs=0, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class GetThreadStackSizeNode
    extends PythonUnaryBuiltinNode {
        GetThreadStackSizeNode() {
        }

        @Specialization
        long getStackSize(PNone stackSize) {
            return this.getContext().getPythonThreadStackSize();
        }

        @Specialization
        static long getStackSize(long stackSize, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            if (stackSize < 0L) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.SIZE_MUST_BE_D_OR_S, 0, "a positive value");
            }
            return PythonContext.get(inliningTarget).getAndSetPythonsThreadStackSize(stackSize);
        }
    }

    @Builtin(name="_count", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class GetThreadCountNode
    extends PythonUnaryBuiltinNode {
        GetThreadCountNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        long getCount(PythonModule self) {
            return self.getModuleState(Integer.class).intValue();
        }
    }

    @Builtin(name="get_native_id", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetNativeIdNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public static long getId() {
            return PThread.getThreadId(Thread.currentThread());
        }
    }

    @Builtin(name="get_ident", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetCurrentThreadIdNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public static long getId() {
            return PThread.getThreadId(Thread.currentThread());
        }
    }

    @Builtin(name="RLock", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.PRLock)
    @GenerateNodeFactory
    static abstract class ConstructRLockNode
    extends PythonUnaryBuiltinNode {
        ConstructRLockNode() {
        }

        @Specialization
        PRLock construct(Object cls, @Cached PythonObjectFactory factory) {
            return factory.createRLock(cls);
        }
    }

    @Builtin(name="LockType", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.PLock)
    @GenerateNodeFactory
    static abstract class ConstructLockNode
    extends PythonUnaryBuiltinNode {
        ConstructLockNode() {
        }

        @Specialization
        PLock construct(Object cls, @Cached PythonObjectFactory factory) {
            return factory.createLock(cls);
        }
    }

    @Builtin(name="allocate_lock", maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class AllocateLockNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        PLock construct(Object self, Object unused, @Cached PythonObjectFactory factory) {
            return factory.createLock((Object)PythonBuiltinClassType.PLock);
        }
    }

    @Builtin(name="_local", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PThreadLocal)
    @GenerateNodeFactory
    static abstract class ThreadLocalNode
    extends PythonBuiltinNode {
        ThreadLocalNode() {
        }

        @Specialization
        PThreadLocal construct(Object cls, Object[] args, PKeyword[] keywordArgs, @Cached PythonObjectFactory factory) {
            return factory.createThreadLocal(cls, args, keywordArgs);
        }
    }
}

