/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.JavaModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.interop.InteropByteArray;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="java")
public final class JavaModuleBuiltins
extends PythonBuiltins {
    private static final TruffleString T_JAR = PythonUtils.tsLiteral(".jar");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return JavaModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("__path__", (Object)"java!");
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule javaModule = core.lookupBuiltinModule(StringLiterals.T_JAVA);
        javaModule.setAttribute(SpecialMethodNames.T___GETATTR__, javaModule.getAttribute(GetAttrNode.T_JAVA_GETATTR));
    }

    @Builtin(name="java_getattr", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class GetAttrNode
    extends PythonBuiltinNode {
        protected static final String J_JAVA_GETATTR = "java_getattr";
        protected static final TruffleString T_JAVA_GETATTR = PythonUtils.tsLiteral("java_getattr");
        private static final TruffleString T_JAVA_PKG_LOADER = PythonUtils.tsLiteral("JavaPackageLoader");
        private static final TruffleString T_MAKE_GETATTR = PythonUtils.tsLiteral("_make_getattr");
        @CompilerDirectives.CompilationFinal
        protected Object getAttr;

        GetAttrNode() {
        }

        private Object getAttr(VirtualFrame frame, PythonModule mod) {
            if (this.getAttr == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object javaLoader = PyObjectGetAttr.getUncached().execute((Frame)frame, null, mod, T_JAVA_PKG_LOADER);
                this.getAttr = PyObjectCallMethodObjArgs.executeUncached((Frame)frame, javaLoader, T_MAKE_GETATTR, StringLiterals.T_JAVA);
            }
            return this.getAttr;
        }

        @Specialization
        Object none(VirtualFrame frame, PythonModule mod, Object name, @Cached CallNode callNode) {
            return callNode.execute((Frame)frame, this.getAttr(frame, mod), name);
        }
    }

    @ExportLibrary(value=InteropLibrary.class, delegateTo="delegate")
    static final class PUnsignedBytesWrapper
    implements TruffleObject {
        final PBytesLike delegate;

        PUnsignedBytesWrapper(PBytesLike delegate) {
            this.delegate = delegate;
        }

        @ExportMessage
        boolean hasArrayElements(@CachedLibrary(value="this.delegate") InteropLibrary delegateLib) {
            return delegateLib.hasArrayElements((Object)this.delegate);
        }

        @ExportMessage
        boolean isArrayElementReadable(long index, @CachedLibrary(value="this.delegate") InteropLibrary delegateLib) {
            return delegateLib.isArrayElementReadable((Object)this.delegate, index);
        }

        @ExportMessage
        long getArraySize(@CachedLibrary(value="this.delegate") InteropLibrary delegateLib) throws UnsupportedMessageException {
            return delegateLib.getArraySize((Object)this.delegate);
        }

        @ExportMessage
        Object readArrayElement(long index, @CachedLibrary(value="this.delegate") InteropLibrary delegateLib, @CachedLibrary(limit="1") InteropLibrary elementLib, @Cached GilNode gil) throws InvalidArrayIndexException, UnsupportedMessageException {
            boolean mustRelease = gil.acquire();
            try {
                Object element = delegateLib.readArrayElement((Object)this.delegate, index);
                if (elementLib.fitsInLong(element)) {
                    long i = elementLib.asLong(element);
                    if (PUnsignedBytesWrapper.compareUnsigned(i, 127L) <= 0) {
                        Byte by = (byte)i;
                        return by;
                    }
                    if (PUnsignedBytesWrapper.compareUnsigned(i, 255L) <= 0) {
                        Byte by = (byte)(-(-i & 0xFFL));
                        return by;
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"bytes object contains non-byte values");
            }
            finally {
                gil.release(mustRelease);
            }
        }

        private static int compare(long x, long y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        private static int compareUnsigned(long x, long y) {
            return PUnsignedBytesWrapper.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
        }
    }

    @Builtin(name="as_java_byte_array", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AsJavaByteArrayNode
    extends PythonUnaryBuiltinNode {
        AsJavaByteArrayNode() {
        }

        @Specialization
        static Object doBytesByteStorage(PBytesLike object) {
            return new PUnsignedBytesWrapper(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isBytes(object)"}, limit="3")
        static Object doBuffer(VirtualFrame frame, Object object, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="object") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            Object buffer = acquireLib.acquireReadonly(object, frame, indirectCallData);
            try {
                InteropByteArray interopByteArray = new InteropByteArray(bufferLib.getCopiedByteArray(object));
                return interopByteArray;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="instanceof", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class InstanceOfNode
    extends PythonBinaryBuiltinNode {
        InstanceOfNode() {
        }

        @Specialization(guards={"!isForeign1.execute(inliningTarget, object)", "isForeign2.execute(inliningTarget, klass)"})
        static boolean check(Object object, Object klass, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isForeign1") @Cached IsForeignObjectNode isForeign1, @Cached.Shared(value="isForeign2") @Cached IsForeignObjectNode isForeign2, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            TruffleLanguage.Env env = PythonContext.get(inliningTarget).getEnv();
            try {
                Object hostKlass = env.asHostObject(klass);
                if (hostKlass instanceof Class) {
                    return ((Class)hostKlass).isInstance(object);
                }
            }
            catch (ClassCastException cce) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.KLASS_ARG_IS_NOT_HOST_OBJ, klass);
            }
            return false;
        }

        @Specialization(guards={"isForeign1.execute(inliningTarget, object)", "isForeign2.execute(inliningTarget, klass)"})
        static boolean checkForeign(Object object, Object klass, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isForeign1") @Cached IsForeignObjectNode isForeign1, @Cached.Shared(value="isForeign2") @Cached IsForeignObjectNode isForeign2, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            TruffleLanguage.Env env = PythonContext.get(inliningTarget).getEnv();
            try {
                Object hostObject = env.asHostObject(object);
                Object hostKlass = env.asHostObject(klass);
                if (hostKlass instanceof Class) {
                    return ((Class)hostKlass).isInstance(hostObject);
                }
            }
            catch (ClassCastException cce) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.OBJ_OR_KLASS_ARGS_IS_NOT_HOST_OBJ, object, klass);
            }
            return false;
        }

        @Fallback
        static boolean fallback(Object object, Object klass, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.UNSUPPORTED_INSTANCEOF, object, klass);
        }
    }

    @Builtin(name="is_type", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsTypeNode
    extends PythonUnaryBuiltinNode {
        IsTypeNode() {
        }

        @Specialization
        boolean isType(Object object) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            return env.isHostObject(object) && env.asHostObject(object) instanceof Class;
        }
    }

    @Builtin(name="is_symbol", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsSymbolNode
    extends PythonUnaryBuiltinNode {
        IsSymbolNode() {
        }

        @Specialization
        boolean check(Object object) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            return env.isHostSymbol(object);
        }
    }

    @Builtin(name="is_object", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsObjectNode
    extends PythonUnaryBuiltinNode {
        IsObjectNode() {
        }

        @Specialization
        boolean check(Object object) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            return env.isHostObject(object);
        }
    }

    @Builtin(name="is_function", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsFunctionNode
    extends PythonUnaryBuiltinNode {
        IsFunctionNode() {
        }

        @Specialization
        boolean check(Object object) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            return env.isHostFunction(object);
        }
    }

    @Builtin(name="add_to_classpath", takesVarArgs=true, doc="Add all arguments to the classpath.")
    @GenerateNodeFactory
    static abstract class AddToClassPathNode
    extends PythonBuiltinNode {
        AddToClassPathNode() {
        }

        @Specialization
        static PNone add(Object[] args, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToString, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleLanguage.Env env = PythonContext.get(inliningTarget).getEnv();
            if (!env.isHostLookupAllowed()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.NotImplementedError, ErrorMessages.HOST_ACCESS_NOT_ALLOWED);
            }
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                TruffleString entry = null;
                try {
                    entry = castToString.execute(inliningTarget, arg);
                    env.addToHostClassPath(PythonContext.get(inliningTarget).getPublicTruffleFileRelaxed(entry, T_JAR));
                    continue;
                }
                catch (CannotCastException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CLASSPATH_ARG_MUST_BE_STRING, i + 1, arg);
                }
                catch (SecurityException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.INVALD_OR_UNREADABLE_CLASSPATH, entry, e);
                }
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="type", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TypeNode
    extends PythonUnaryBuiltinNode {
        TypeNode() {
        }

        @Specialization(guards={"isPString(name) || isTruffleString(name)"})
        static Object type(Object name, @Bind(value="this") Node inliningTarget, @Cached CastToJavaStringNode castToStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object hostValue;
            TruffleLanguage.Env env = PythonContext.get(inliningTarget).getEnv();
            if (!env.isHostLookupAllowed()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.NotImplementedError, ErrorMessages.HOST_LOOKUP_NOT_ALLOWED);
            }
            String javaString = castToStringNode.execute(name);
            try {
                hostValue = env.lookupHostSymbol(javaString);
            }
            catch (RuntimeException e) {
                hostValue = null;
            }
            if (hostValue == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.KeyError, ErrorMessages.HOST_SYM_NOT_DEFINED, javaString);
            }
            return hostValue;
        }

        @Fallback
        static Object doError(Object object, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_P, object);
        }
    }
}

