/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.modules.BinasciiModuleBuiltins;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.function.builtins.clinic.JavaIntConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.JavaIntToBooleanConverterNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.JavaLongConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ReadableBufferConversionNode;

public class BinasciiModuleBuiltinsClinicProviders {

    public static final class Crc32NodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final Crc32NodeClinicProviderGen INSTANCE = new Crc32NodeClinicProviderGen();

        private Crc32NodeClinicProviderGen() {
            super(0, 2, 0, 0, 3);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return ReadableBufferConversionNode.create(false);
                }
                case 1: {
                    return JavaLongConversionNode.create(0L, false);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class B2aHexNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final B2aHexNodeClinicProviderGen INSTANCE = new B2aHexNodeClinicProviderGen();

        private B2aHexNodeClinicProviderGen() {
            super(2, 6, 2, 2, 5);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return ReadableBufferConversionNode.create(false);
                }
                case 2: {
                    return JavaIntConversionNode.create(1, false);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class B2aBase64NodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final B2aBase64NodeClinicProviderGen INSTANCE = new B2aBase64NodeClinicProviderGen();

        private B2aBase64NodeClinicProviderGen() {
            super(0, 2, 0, 0, 3);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return ReadableBufferConversionNode.create(false);
                }
                case 1: {
                    return JavaIntConversionNode.create(1, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class CrcHqxNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final CrcHqxNodeClinicProviderGen INSTANCE = new CrcHqxNodeClinicProviderGen();

        private CrcHqxNodeClinicProviderGen() {
            super(0, 2, 0, 0, 3);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return ReadableBufferConversionNode.create(false);
                }
                case 1: {
                    return JavaLongConversionNode.create(false);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class A2bBase64NodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final A2bBase64NodeClinicProviderGen INSTANCE = new A2bBase64NodeClinicProviderGen();

        private A2bBase64NodeClinicProviderGen() {
            super(2, 0, 0, 0, 3);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return BinasciiModuleBuiltins.AsciiBufferConverter.create();
                }
                case 1: {
                    return JavaIntToBooleanConverterNode.create(false, false);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class UnhexlifyNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final UnhexlifyNodeClinicProviderGen INSTANCE = new UnhexlifyNodeClinicProviderGen();

        private UnhexlifyNodeClinicProviderGen() {
            super(0, 0, 0, 0, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return BinasciiModuleBuiltins.AsciiBufferConverter.create();
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class A2bHexNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final A2bHexNodeClinicProviderGen INSTANCE = new A2bHexNodeClinicProviderGen();

        private A2bHexNodeClinicProviderGen() {
            super(0, 0, 0, 0, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return BinasciiModuleBuiltins.AsciiBufferConverter.create();
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class HexlifyNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final HexlifyNodeClinicProviderGen INSTANCE = new HexlifyNodeClinicProviderGen();

        private HexlifyNodeClinicProviderGen() {
            super(2, 6, 2, 2, 5);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return ReadableBufferConversionNode.create(false);
                }
                case 2: {
                    return JavaIntConversionNode.create(1, false);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }
}

