/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ArrayModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.ArrayModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.array.ArrayBuiltins;
import com.oracle.graal.python.builtins.objects.array.ArrayNodes;
import com.oracle.graal.python.builtins.objects.array.PArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.range.PIntRange;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.SplitArgsNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;
import java.util.List;

@CoreFunctions(defineModule="array")
public final class ArrayModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ArrayModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule arrayModule = core.lookupBuiltinModule(BuiltinNames.T_ARRAY);
        arrayModule.setAttribute(PythonUtils.tsLiteral("ArrayType"), core.lookupType(PythonBuiltinClassType.PArray));
        arrayModule.setAttribute(PythonUtils.tsLiteral("typecodes"), PythonUtils.tsLiteral("bBuhHiIlLqQfd"));
    }

    @Builtin(name="_array_reconstructor", minNumOfPositionalArgs=4, numOfPositionalOnlyArgs=4, parameterNames={"arrayType", "typeCode", "mformatCode", "items"})
    @ArgumentsClinic(value={@ArgumentClinic(name="typeCode", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="mformatCode", conversion=ArgumentClinic.ClinicConversion.Index)})
    @GenerateNodeFactory
    static abstract class ArrayReconstructorNode
    extends PythonClinicBuiltinNode {
        ArrayReconstructorNode() {
        }

        @Specialization(guards={"mformatCode == cachedCode"}, limit="3")
        static Object reconstructCached(VirtualFrame frame, Object arrayType, TruffleString typeCode, int mformatCode, PBytes bytes, @Bind(value="this") Node inliningTarget, @Cached(value="mformatCode") int cachedCode, @Cached(value="createIdentityProfile()", inline=false) ValueProfile formatProfile, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callDecode, @Cached.Exclusive @Cached ArrayBuiltins.FromBytesNode fromBytesNode, @Cached.Exclusive @Cached ArrayBuiltins.FromUnicodeNode fromUnicodeNode, @Cached.Exclusive @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached ArrayBuiltins.ByteSwapNode byteSwapNode, @Cached.Exclusive @Cached TruffleString.CodePointLengthNode lengthNode, @Cached.Exclusive @Cached TruffleString.CodePointAtIndexNode atIndexNode, @Cached.Exclusive @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            BufferFormat format = BufferFormat.forArray(typeCode, lengthNode, atIndexNode);
            if (format == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.BAD_TYPECODE);
            }
            return ArrayReconstructorNode.doReconstruct(frame, inliningTarget, arrayType, typeCode, cachedCode, bytes, callDecode, fromBytesNode, fromUnicodeNode, isSubtypeNode, byteSwapNode, (BufferFormat)((Object)formatProfile.profile((Object)format)), factory, raiseNode);
        }

        @Specialization(replaces={"reconstructCached"})
        static Object reconstruct(VirtualFrame frame, Object arrayType, TruffleString typeCode, int mformatCode, PBytes bytes, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callDecode, @Cached.Exclusive @Cached ArrayBuiltins.FromBytesNode fromBytesNode, @Cached.Exclusive @Cached ArrayBuiltins.FromUnicodeNode fromUnicodeNode, @Cached.Exclusive @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached ArrayBuiltins.ByteSwapNode byteSwapNode, @Cached.Exclusive @Cached TruffleString.CodePointLengthNode lengthNode, @Cached.Exclusive @Cached TruffleString.CodePointAtIndexNode atIndexNode, @Cached.Exclusive @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            BufferFormat format = BufferFormat.forArray(typeCode, lengthNode, atIndexNode);
            if (format == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.BAD_TYPECODE);
            }
            return ArrayReconstructorNode.doReconstruct(frame, inliningTarget, arrayType, typeCode, mformatCode, bytes, callDecode, fromBytesNode, fromUnicodeNode, isSubtypeNode, byteSwapNode, format, factory, raiseNode);
        }

        private static Object doReconstruct(VirtualFrame frame, Node inliningTarget, Object arrayType, TruffleString typeCode, int mformatCode, PBytes bytes, PyObjectCallMethodObjArgs callDecode, ArrayBuiltins.FromBytesNode fromBytesNode, ArrayBuiltins.FromUnicodeNode fromUnicodeNode, IsSubtypeNode isSubtypeNode, ArrayBuiltins.ByteSwapNode byteSwapNode, BufferFormat format, PythonObjectFactory factory, PRaiseNode.Lazy raiseNode) {
            if (!isSubtypeNode.execute(frame, arrayType, (Object)PythonBuiltinClassType.PArray)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.N_NOT_SUBTYPE_OF_ARRAY, arrayType);
            }
            PArray.MachineFormat machineFormat = PArray.MachineFormat.fromCode(mformatCode);
            if (machineFormat != null) {
                PArray array;
                if (machineFormat == PArray.MachineFormat.forFormat(format)) {
                    array = factory.createArray(arrayType, typeCode, machineFormat.format);
                    fromBytesNode.executeWithoutClinic(frame, array, bytes);
                } else {
                    TruffleString newTypeCode = machineFormat.format == format ? typeCode : machineFormat.format.baseTypeCode;
                    array = factory.createArray(arrayType, newTypeCode, machineFormat.format);
                    if (machineFormat.unicodeEncoding != null) {
                        Object decoded = callDecode.execute((Frame)frame, inliningTarget, bytes, SpecialMethodNames.T_DECODE, machineFormat.unicodeEncoding);
                        fromUnicodeNode.execute(frame, array, decoded);
                    } else {
                        fromBytesNode.executeWithoutClinic(frame, array, bytes);
                        if (machineFormat.order != ByteOrder.nativeOrder()) {
                            byteSwapNode.execute(frame, array);
                        }
                    }
                }
                return array;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.THIRD_ARG_MUST_BE_A_VALID_MACHINE_CODE_FMT);
        }

        @Specialization(guards={"!isPBytes(value)"})
        static Object error(Object arrayType, TruffleString typeCode, int mformatCode, Object value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.FOURTH_ARG_SHOULD_BE_BYTES, value);
        }

        protected static boolean isPBytes(Object obj) {
            return obj instanceof PBytes;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ArrayModuleBuiltinsClinicProviders.ArrayReconstructorNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="array", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.PArray, takesVarArgs=true, takesVarKeywordArgs=true, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class ArrayNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private SplitArgsNode splitArgsNode;

        ArrayNode() {
        }

        @Specialization(guards={"args.length == 1 || args.length == 2"})
        static Object array2(VirtualFrame frame, Object cls, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile hasInitializerProfile, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isNotSubtypeProfile, @Cached StringNodes.CastToTruffleStringCheckedNode cast, @Cached ArrayNodeInternal arrayNodeInternal, @Cached PRaiseNode.Lazy raise) {
            if (isNotSubtypeProfile.profileClass(inliningTarget, cls, PythonBuiltinClassType.PArray) && kwargs.length != 0) {
                throw raise.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, "array.array()");
            }
            PNone initializer = hasInitializerProfile.profile(inliningTarget, args.length == 2) ? args[1] : PNone.NO_VALUE;
            return arrayNodeInternal.execute(frame, inliningTarget, cls, cast.cast(inliningTarget, args[0], ErrorMessages.ARG_1_MUST_BE_UNICODE_NOT_P, args[0]), initializer);
        }

        @Fallback
        Object error(Object cls, Object[] args, PKeyword[] kwargs) {
            if (args.length < 2) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.S_TAKES_AT_LEAST_D_ARGUMENTS_D_GIVEN, BuiltinNames.T_ARRAY, 2, args.length);
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.S_TAKES_AT_MOST_D_ARGUMENTS_D_GIVEN, BuiltinNames.T_ARRAY, 3, args.length);
        }

        @Override
        public final Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            if (this.splitArgsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.splitArgsNode = (SplitArgsNode)this.insert(SplitArgsNode.create());
            }
            return this.execute(frame, arguments[0], this.splitArgsNode.executeCached(arguments), keywords);
        }

        @ImportStatic(value={PGuards.class})
        @GenerateInline
        @GenerateCached(value=false)
        static abstract class ArrayNodeInternal
        extends Node {
            ArrayNodeInternal() {
            }

            public abstract PArray execute(VirtualFrame var1, Node var2, Object var3, TruffleString var4, Object var5);

            @Specialization(guards={"isNoValue(initializer)"})
            static PArray array(Node inliningTarget, Object cls, TruffleString typeCode, PNone initializer, @Cached.Shared @Cached GetFormatCheckedNode getFormatCheckedNode, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
                BufferFormat format = getFormatCheckedNode.execute(inliningTarget, typeCode);
                return factory.createArray(cls, typeCode, format);
            }

            @Specialization
            @HostCompilerDirectives.InliningCutoff
            static PArray arrayWithRangeInitializer(Node inliningTarget, Object cls, TruffleString typeCode, PIntRange range, @Cached.Shared @Cached GetFormatCheckedNode getFormatCheckedNode, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory, @Cached.Exclusive @Cached ArrayNodes.PutValueNode putValueNode) {
                PArray array;
                BufferFormat format = getFormatCheckedNode.execute(inliningTarget, typeCode);
                try {
                    array = factory.createArray(cls, typeCode, format, range.getIntLength());
                }
                catch (OverflowException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.MemoryError);
                }
                int start = range.getIntStart();
                int step = range.getIntStep();
                int len = range.getIntLength();
                int index = 0;
                int value = start;
                while (index < len) {
                    putValueNode.execute(null, inliningTarget, array, index, value);
                    ++index;
                    value += step;
                }
                return array;
            }

            @Specialization
            static PArray arrayWithBytesInitializer(VirtualFrame frame, Node inliningTarget, Object cls, TruffleString typeCode, PBytesLike bytes, @Cached.Shared @Cached GetFormatCheckedNode getFormatCheckedNode, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory, @Cached(inline=false) ArrayBuiltins.FromBytesNode fromBytesNode) {
                BufferFormat format = getFormatCheckedNode.execute(inliningTarget, typeCode);
                PArray array = factory.createArray(cls, typeCode, format);
                fromBytesNode.executeWithoutClinic(frame, array, bytes);
                return array;
            }

            @Specialization(guards={"isString(initializer)"})
            @HostCompilerDirectives.InliningCutoff
            static PArray arrayWithStringInitializer(VirtualFrame frame, Node inliningTarget, Object cls, TruffleString typeCode, Object initializer, @Cached.Shared @Cached GetFormatCheckedNode getFormatCheckedNode, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory, @Cached(inline=false) ArrayBuiltins.FromUnicodeNode fromUnicodeNode, @Cached PRaiseNode.Lazy raise) {
                BufferFormat format = getFormatCheckedNode.execute(inliningTarget, typeCode);
                if (format != BufferFormat.UNICODE) {
                    throw raise.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_USE_STR_TO_INITIALIZE_ARRAY, typeCode);
                }
                PArray array = factory.createArray(cls, typeCode, format);
                fromUnicodeNode.execute(frame, array, initializer);
                return array;
            }

            @Specialization
            @HostCompilerDirectives.InliningCutoff
            static PArray arrayArrayInitializer(VirtualFrame frame, Node inliningTarget, Object cls, TruffleString typeCode, PArray initializer, @Cached.Shared @Cached GetFormatCheckedNode getFormatCheckedNode, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory, @Cached.Exclusive @Cached ArrayNodes.PutValueNode putValueNode, @Cached ArrayNodes.GetValueNode getValueNode) {
                BufferFormat format = getFormatCheckedNode.execute(inliningTarget, typeCode);
                try {
                    int length = initializer.getLength();
                    PArray array = factory.createArray(cls, typeCode, format, length);
                    for (int i = 0; i < length; ++i) {
                        putValueNode.execute(frame, inliningTarget, array, i, getValueNode.execute(inliningTarget, initializer, i));
                    }
                    return array;
                }
                catch (OverflowException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.MemoryError);
                }
            }

            @Specialization(guards={"!isBytes(initializer)"})
            @HostCompilerDirectives.InliningCutoff
            static PArray arraySequenceInitializer(VirtualFrame frame, Node inliningTarget, Object cls, TruffleString typeCode, PSequence initializer, @Cached.Shared @Cached GetFormatCheckedNode getFormatCheckedNode, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory, @Cached.Exclusive @Cached ArrayNodes.PutValueNode putValueNode, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode) {
                BufferFormat format = getFormatCheckedNode.execute(inliningTarget, typeCode);
                SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, initializer);
                int length = storage.length();
                try {
                    PArray array = factory.createArray(cls, typeCode, format, length);
                    for (int i = 0; i < length; ++i) {
                        putValueNode.execute(frame, inliningTarget, array, i, getItemNode.execute(inliningTarget, storage, i));
                    }
                    return array;
                }
                catch (OverflowException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.MemoryError);
                }
            }

            @Specialization(guards={"!isBytes(initializer)", "!isString(initializer)", "!isPSequence(initializer)"})
            @HostCompilerDirectives.InliningCutoff
            static PArray arrayIteratorInitializer(VirtualFrame frame, Node inliningTarget, Object cls, TruffleString typeCode, Object initializer, @Cached PyObjectGetIter getIter, @Cached.Shared @Cached GetFormatCheckedNode getFormatCheckedNode, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory, @Cached.Exclusive @Cached ArrayNodes.PutValueNode putValueNode, @Cached(inline=false) GetNextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached ArrayNodes.SetLengthNode setLengthNode, @Cached ArrayNodes.EnsureCapacityNode ensureCapacityNode) {
                Object iter = getIter.execute((Frame)frame, inliningTarget, initializer);
                BufferFormat format = getFormatCheckedNode.execute(inliningTarget, typeCode);
                PArray array = factory.createArray(cls, typeCode, format);
                int length = 0;
                while (true) {
                    Object nextValue;
                    try {
                        nextValue = nextNode.execute((Frame)frame, iter);
                    }
                    catch (PException e) {
                        e.expectStopIteration(inliningTarget, errorProfile);
                        break;
                    }
                    try {
                        length = PythonUtils.addExact(length, 1);
                        ensureCapacityNode.execute(inliningTarget, array, length);
                    }
                    catch (OverflowException e) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.MemoryError);
                    }
                    putValueNode.execute(frame, inliningTarget, array, length - 1, nextValue);
                }
                setLengthNode.execute(inliningTarget, array, length);
                return array;
            }

            @GenerateInline
            @GenerateCached(value=false)
            static abstract class GetFormatCheckedNode
            extends Node {
                GetFormatCheckedNode() {
                }

                abstract BufferFormat execute(Node var1, TruffleString var2);

                @Specialization
                static BufferFormat get(Node inliningTarget, TruffleString typeCode, @Cached(inline=false) TruffleString.CodePointLengthNode lengthNode, @Cached(inline=false) TruffleString.CodePointAtIndexNode atIndexNode, @Cached PRaiseNode.Lazy raise, @Cached(value="createIdentityProfile()", inline=false) ValueProfile valueProfile) {
                    if (lengthNode.execute((AbstractTruffleString)typeCode, PythonUtils.TS_ENCODING) != 1) {
                        throw raise.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ARRAY_ARG_1_MUST_BE_UNICODE);
                    }
                    BufferFormat format = BufferFormat.forArray(typeCode, lengthNode, atIndexNode);
                    if (format == null) {
                        throw raise.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.BAD_TYPECODE);
                    }
                    return (BufferFormat)((Object)valueProfile.profile((Object)format));
                }
            }
        }
    }
}

