/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.util;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.nodes.PNodeWithRaiseAndIndirectCall;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;

public final class ByteArrayBuilder {
    private byte[] data;
    private int size;

    public ByteArrayBuilder() {
        this(8);
    }

    public ByteArrayBuilder(int capacity) {
        this.data = new byte[capacity];
    }

    public void add(byte item) {
        this.ensureCanAppend(1);
        this.data[this.size++] = item;
    }

    public void add(byte[] bytes, int len) {
        this.ensureCanAppend(len);
        PythonUtils.arraycopy(bytes, 0, this.data, this.size, len);
        this.size += len;
    }

    public int get(int index) {
        assert (index >= 0 && index < this.size);
        return this.data[index];
    }

    public byte[] toArray() {
        return ByteArrayBuilder.arrayCopyOf(this.data, this.size);
    }

    public int size() {
        return this.size;
    }

    private static byte[] arrayCopyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        PythonUtils.arraycopy(original, 0, copy, 0, Math.min(newLength, original.length));
        return copy;
    }

    private void ensureCanAppend(int bytesToAdd) {
        try {
            int sizeTimes2;
            int newSize = PythonUtils.addExact(this.size, bytesToAdd);
            if (newSize > this.data.length && newSize < (sizeTimes2 = PythonUtils.multiplyExact(this.size, 2))) {
                newSize = sizeTimes2;
            }
            this.data = ByteArrayBuilder.arrayCopyOf(this.data, newSize);
        }
        catch (OverflowException e) {
            CompilerDirectives.transferToInterpreter();
            throw new OutOfMemoryError();
        }
    }

    public static abstract class AppendBytesNode
    extends PNodeWithRaiseAndIndirectCall {
        public abstract void execute(VirtualFrame var1, ByteArrayBuilder var2, Object var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        void appendBytes(VirtualFrame frame, ByteArrayBuilder builder, Object data, @CachedLibrary(value="data") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="3") @Cached.Shared PythonBufferAccessLibrary bufferLib) {
            Object dataBuffer = bufferAcquireLib.acquireReadonly(data, frame, this.getContext(), this.getLanguage(), this);
            try {
                int len = bufferLib.getBufferLength(dataBuffer);
                byte[] src = bufferLib.getInternalOrCopiedByteArray(dataBuffer);
                builder.add(src, len);
            }
            finally {
                bufferLib.release(dataBuffer, frame, this);
            }
        }
    }
}

