/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStoreException;
import com.oracle.graal.python.runtime.sequence.storage.TypedSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import java.util.Arrays;

public final class IntSequenceStorage
extends TypedSequenceStorage {
    private int[] values;

    public IntSequenceStorage() {
        this.values = new int[0];
    }

    public IntSequenceStorage(int[] elements) {
        this.values = elements;
        this.capacity = this.values.length;
        this.length = elements.length;
    }

    public IntSequenceStorage(int[] elements, int length) {
        this.values = elements;
        this.capacity = this.values.length;
        this.length = length;
    }

    public IntSequenceStorage(int capacity) {
        this.values = new int[capacity];
        this.capacity = capacity;
        this.length = 0;
    }

    @Override
    protected void increaseCapacityExactWithCopy(int newCapacity) {
        this.values = Arrays.copyOf(this.values, newCapacity);
        this.capacity = this.values.length;
    }

    @Override
    protected void increaseCapacityExact(int newCapacity) {
        this.values = new int[newCapacity];
        this.capacity = this.values.length;
    }

    @Override
    public SequenceStorage copy() {
        return new IntSequenceStorage(PythonUtils.arrayCopyOf(this.values, this.length));
    }

    @Override
    public SequenceStorage createEmpty(int newCapacity) {
        return new IntSequenceStorage(newCapacity);
    }

    @Override
    public Object[] getInternalArray() {
        Object[] boxed = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            boxed[i] = this.values[i];
        }
        return boxed;
    }

    public int[] getInternalIntArray() {
        return this.values;
    }

    @Override
    public Object getItemNormalized(int idx) {
        return this.getIntItemNormalized(idx);
    }

    public int getIntItemNormalized(int idx) {
        return this.values[idx];
    }

    @Override
    public void setItemNormalized(int idx, Object value) throws SequenceStoreException {
        if (!(value instanceof Integer)) {
            throw new SequenceStoreException(value);
        }
        this.setIntItemNormalized(idx, (Integer)value);
    }

    public void setIntItemNormalized(int idx, int value) {
        this.values[idx] = value;
    }

    @Override
    public void insertItem(int idx, Object value) throws SequenceStoreException {
        if (!(value instanceof Integer)) {
            throw new SequenceStoreException(value);
        }
        this.insertIntItem(idx, (Integer)value);
    }

    public void insertIntItem(int idx, int value) {
        this.ensureCapacity(this.length + 1);
        for (int i = this.values.length - 1; i > idx; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[idx] = value;
        this.incLength();
    }

    @Override
    public void copyItem(int idxTo, int idxFrom) {
        this.values[idxTo] = this.values[idxFrom];
    }

    @Override
    public IntSequenceStorage getSliceInBound(int start, int stop, int step, int sliceLength) {
        int[] newArray = new int[sliceLength];
        if (step == 1) {
            PythonUtils.arraycopy(this.values, start, newArray, 0, sliceLength);
            return new IntSequenceStorage(newArray);
        }
        int i = start;
        for (int j = 0; j < sliceLength; ++j) {
            newArray[j] = this.values[i];
            i += step;
        }
        return new IntSequenceStorage(newArray);
    }

    public int indexOfInt(int value) {
        for (int i = 0; i < this.length; ++i) {
            if (this.values[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void reverse() {
        if (this.length > 0) {
            int head = 0;
            int tail = this.length - 1;
            int middle = (this.length - 1) / 2;
            while (head <= middle) {
                int temp = this.values[head];
                this.values[head] = this.values[tail];
                this.values[tail] = temp;
                ++head;
                --tail;
            }
        }
    }

    @Override
    public Object getIndicativeValue() {
        return 0;
    }

    @Override
    public boolean equals(SequenceStorage other) {
        if (other.length() != this.length() || !(other instanceof IntSequenceStorage)) {
            return false;
        }
        int[] otherArray = ((IntSequenceStorage)other).getInternalIntArray();
        for (int i = 0; i < this.length(); ++i) {
            if (this.values[i] == otherArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return Arrays.copyOf(this.values, this.length);
    }

    @Override
    public Object[] getCopyOfInternalArray() {
        return this.getInternalArray();
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        this.values = (int[])arrayObject;
    }

    @Override
    public SequenceStorage.ListStorageType getElementType() {
        return SequenceStorage.ListStorageType.Int;
    }
}

