/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.argument.ReadIndexedArgumentNode;
import com.oracle.graal.python.nodes.argument.ReadVarArgsNode;
import com.oracle.graal.python.nodes.argument.ReadVarKeywordsNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.BuiltinCallNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonSenaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.WrapBinaryfuncR;
import com.oracle.graal.python.nodes.function.builtins.WrapTpNew;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class BuiltinFunctionRootNode
extends PRootNode {
    public static final TruffleString T_DOLLAR_DECL_TYPE = PythonUtils.tsLiteral("$decl_type");
    private static final TruffleString T_DOLLAR_CLS = PythonUtils.tsLiteral("$cls");
    private static final TruffleString T_DOLLAR_SELF = PythonUtils.tsLiteral("$self");
    private final Signature signature;
    private final Builtin builtin;
    private final String name;
    private final NodeFactory<? extends PythonBuiltinBaseNode> factory;
    private final boolean declaresExplicitSelf;
    @Node.Child
    private BuiltinCallNode body;
    @Node.Child
    private ExecutionContext.CalleeContext calleeContext = ExecutionContext.CalleeContext.create();
    private final PythonBuiltinClassType constructsClass;

    public BuiltinFunctionRootNode(PythonLanguage language, Signature signature, Builtin builtin, NodeFactory<? extends PythonBuiltinBaseNode> factory, boolean declaresExplicitSelf, PythonBuiltinClassType constructsClass) {
        super(language);
        CompilerAsserts.neverPartOfCompilation();
        this.signature = signature;
        this.builtin = builtin;
        this.name = builtin.name();
        this.factory = factory;
        this.declaresExplicitSelf = declaresExplicitSelf;
        this.constructsClass = constructsClass;
        if (builtin.alwaysNeedsCallerFrame()) {
            this.setNeedsCallerFrame();
        }
    }

    public BuiltinFunctionRootNode(PythonLanguage language, Builtin builtin, NodeFactory<? extends PythonBuiltinBaseNode> factory, boolean declaresExplicitSelf, PythonBuiltinClassType constructsClass) {
        this(language, BuiltinFunctionRootNode.createSignature(factory, builtin, declaresExplicitSelf, constructsClass != PythonBuiltinClassType.nil), builtin, factory, declaresExplicitSelf, constructsClass);
    }

    public BuiltinFunctionRootNode(PythonLanguage language, Builtin builtin, NodeFactory<? extends PythonBuiltinBaseNode> factory, boolean declaresExplicitSelf) {
        this(language, builtin, factory, declaresExplicitSelf, builtin.constructsClass());
    }

    private static Signature createSignature(NodeFactory<? extends PythonBuiltinBaseNode> factory, Builtin builtin, boolean declaresExplicitSelf, boolean constructsClass) {
        TruffleString[] parameterNames = PythonUtils.toTruffleStringArrayUncached(builtin.parameterNames());
        int maxNumPosArgs = Math.max(builtin.minNumOfPositionalArgs(), parameterNames.length);
        if (builtin.maxNumOfPositionalArgs() >= 0) {
            maxNumPosArgs = builtin.maxNumOfPositionalArgs();
            assert (parameterNames.length == 0) : "either give all parameter names explicitly, or define the max number: " + builtin.name() + " - " + String.join((CharSequence)",", builtin.parameterNames()) + " vs " + builtin.maxNumOfPositionalArgs() + " - " + factory.toString();
        }
        assert (BuiltinFunctionRootNode.validateBuiltin(factory, builtin));
        if (constructsClass && maxNumPosArgs == 0) {
            maxNumPosArgs = 1;
        }
        int posOnlyArgs = builtin.numOfPositionalOnlyArgs();
        if (parameterNames.length == 0) {
            posOnlyArgs = maxNumPosArgs;
        }
        if (!declaresExplicitSelf) {
            ++maxNumPosArgs;
            ++posOnlyArgs;
        }
        if (maxNumPosArgs > 0) {
            if (parameterNames.length == 0) {
                parameterNames = new TruffleString[maxNumPosArgs];
                int i = 0;
                if (constructsClass) {
                    if (!declaresExplicitSelf) {
                        parameterNames[i++] = T_DOLLAR_DECL_TYPE;
                    }
                    parameterNames[i++] = T_DOLLAR_CLS;
                } else {
                    parameterNames[i++] = T_DOLLAR_SELF;
                }
                int p = 97;
                while (i < parameterNames.length) {
                    parameterNames[i] = TruffleString.fromCodePointUncached((int)p, (TruffleString.Encoding)PythonUtils.TS_ENCODING);
                    ++i;
                    ++p;
                }
            } else if (declaresExplicitSelf) {
                assert (parameterNames.length == maxNumPosArgs) : "not enough parameter ids on " + factory;
            } else {
                assert (parameterNames.length + 1 == maxNumPosArgs) : "not enough parameter ids on " + factory;
                parameterNames = Arrays.copyOf(parameterNames, parameterNames.length + 1);
                PythonUtils.arraycopy(parameterNames, 0, parameterNames, 1, parameterNames.length - 1);
                TruffleString truffleString = parameterNames[0] = constructsClass ? T_DOLLAR_DECL_TYPE : T_DOLLAR_SELF;
            }
        }
        assert (BuiltinFunctionRootNode.canUseSpecialBuiltinNode(builtin) || !BuiltinFunctionRootNode.usesSpecialBuiltinNode(factory.getNodeClass())) : factory.getNodeClass().getName() + " must not use PythonUnary/Binary/Ternary/QuaternaryBultinNode";
        return new Signature(posOnlyArgs, builtin.takesVarKeywordArgs(), builtin.takesVarArgs() ? parameterNames.length : -1, builtin.varArgsMarker(), parameterNames, PythonUtils.toTruffleStringArrayUncached(builtin.keywordOnlyNames()), false, PythonUtils.toTruffleStringUncached(builtin.raiseErrorName()));
    }

    private static boolean validateBuiltin(NodeFactory<? extends PythonBuiltinBaseNode> factory, Builtin builtin) {
        Class nodeClass = factory.getNodeClass();
        if (PythonUnaryBuiltinNode.class.isAssignableFrom(nodeClass)) {
            BuiltinFunctionRootNode.validateBuiltinForArity(builtin, nodeClass, 1);
        } else if (PythonBinaryBuiltinNode.class.isAssignableFrom(nodeClass)) {
            BuiltinFunctionRootNode.validateBuiltinForArity(builtin, nodeClass, 2);
        } else if (PythonTernaryBuiltinNode.class.isAssignableFrom(nodeClass)) {
            BuiltinFunctionRootNode.validateBuiltinForArity(builtin, nodeClass, 3);
        } else if (PythonQuaternaryBuiltinNode.class.isAssignableFrom(nodeClass)) {
            BuiltinFunctionRootNode.validateBuiltinForArity(builtin, nodeClass, 4);
        } else if (PythonVarargsBuiltinNode.class.isAssignableFrom(nodeClass)) {
            assert (builtin.takesVarArgs()) : "PythonVararagsBuiltin subclass must take varargs, builtin " + nodeClass.getName();
            assert (builtin.takesVarKeywordArgs()) : "PythonVararagsBuiltin subclass must take varkwargs, builtin " + nodeClass.getName();
        }
        return true;
    }

    private static void validateBuiltinForArity(Builtin builtin, Class<? extends PythonBuiltinBaseNode> nodeClass, int arity) {
        int minNumPosArgs = builtin.minNumOfPositionalArgs();
        int maxNumPosArgs = builtin.maxNumOfPositionalArgs();
        if (builtin.parameterNames().length > 0) {
            assert (builtin.parameterNames().length == arity) : "Mismatch in parameter list length and arity for n-ary builtin " + nodeClass.getName();
            maxNumPosArgs = builtin.parameterNames().length;
        } else if (maxNumPosArgs == -1) {
            maxNumPosArgs = minNumPosArgs;
        }
        assert (minNumPosArgs <= arity && minNumPosArgs <= maxNumPosArgs) : "Invalid number of min arguments for a n-ary builtin " + nodeClass.getName();
        assert (maxNumPosArgs == arity) : "Invalid number of max arguments for a n-ary builtin " + nodeClass.getName();
        assert (!builtin.takesVarArgs() && !builtin.takesVarKeywordArgs()) : "Invalid varargs declaration for a n-ary builtin " + nodeClass.getName();
    }

    private static boolean canUseSpecialBuiltinNode(Builtin builtin) {
        return !builtin.takesVarArgs() && !builtin.takesVarKeywordArgs() && !builtin.varArgsMarker() && builtin.keywordOnlyNames().length == 0;
    }

    private static boolean usesSpecialBuiltinNode(Class<? extends PythonBuiltinBaseNode> clazz) {
        return PythonUnaryBuiltinNode.class.isAssignableFrom(clazz) || PythonBinaryBuiltinNode.class.isAssignableFrom(clazz) || PythonTernaryBuiltinNode.class.isAssignableFrom(clazz) || PythonQuaternaryBuiltinNode.class.isAssignableFrom(clazz);
    }

    private static ReadArgumentNode[] createArgumentsList(Builtin builtin, boolean needsExplicitSelf) {
        ArrayList<ReadArgumentNode> args = new ArrayList<ReadArgumentNode>();
        String[] parameterNames = builtin.parameterNames();
        int maxNumPosArgs = Math.max(builtin.minNumOfPositionalArgs(), parameterNames.length);
        if (builtin.maxNumOfPositionalArgs() >= 0) {
            maxNumPosArgs = builtin.maxNumOfPositionalArgs();
            assert (parameterNames.length == 0) : "either give all parameter names explicitly, or define the max number: " + builtin.name();
        }
        int skip = needsExplicitSelf ? 0 : 1;
        for (int i = 0; i < maxNumPosArgs; ++i) {
            args.add(ReadIndexedArgumentNode.create(i + skip));
        }
        if (builtin.takesVarArgs()) {
            args.add(ReadVarArgsNode.create(true));
        }
        int keywordCount = builtin.keywordOnlyNames().length;
        for (int i = 0; i < keywordCount; ++i) {
            args.add(ReadIndexedArgumentNode.create(i + maxNumPosArgs + skip));
        }
        if (builtin.takesVarKeywordArgs()) {
            args.add(ReadVarKeywordsNode.create());
        }
        return args.toArray(new ReadArgumentNode[args.size()]);
    }

    @Override
    public boolean isCloningAllowed() {
        return true;
    }

    @Override
    public boolean isCaptureFramesForTrace() {
        return false;
    }

    public boolean isInternal() {
        return true;
    }

    @Override
    public boolean setsUpCalleeContext() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(VirtualFrame frame) {
        if (this.body == null) {
            BuiltinCallNode newBody;
            CompilerDirectives.transferToInterpreterAndInvalidate();
            ReadArgumentNode[] argumentsList = BuiltinFunctionRootNode.createArgumentsList(this.builtin, this.declaresExplicitSelf);
            if (PythonBuiltinNode.class.isAssignableFrom(this.factory.getNodeClass())) {
                newBody = new BuiltinCallNode.BuiltinAnyCallNode((PythonBuiltinNode)this.factory.createNode(new Object[]{argumentsList}));
            } else {
                PythonBuiltinBaseNode node = (PythonBuiltinBaseNode)this.factory.createNode(new Object[0]);
                if (node instanceof PythonUnaryBuiltinNode) {
                    assert (argumentsList.length == 1) : "mismatch in number of arguments for " + node.getClass().getName() + ", expected 1, got " + argumentsList.length;
                    newBody = new BuiltinCallNode.BuiltinUnaryCallNode((PythonUnaryBuiltinNode)node, argumentsList[0]);
                } else if (node instanceof PythonBinaryBuiltinNode) {
                    assert (argumentsList.length == 2) : "mismatch in number of arguments for " + node.getClass().getName() + ", expected 2, got " + argumentsList.length;
                    newBody = new BuiltinCallNode.BuiltinBinaryCallNode((PythonBinaryBuiltinNode)node, argumentsList[0], argumentsList[1]);
                } else if (node instanceof PythonTernaryBuiltinNode) {
                    assert (argumentsList.length == 3) : "mismatch in number of arguments for " + node.getClass().getName() + ", expected 3, got " + argumentsList.length;
                    newBody = new BuiltinCallNode.BuiltinTernaryCallNode((PythonTernaryBuiltinNode)node, argumentsList[0], argumentsList[1], argumentsList[2]);
                } else if (node instanceof PythonQuaternaryBuiltinNode) {
                    assert (argumentsList.length == 4) : "mismatch in number of arguments for " + node.getClass().getName() + ", expected 4, got " + argumentsList.length;
                    newBody = new BuiltinCallNode.BuiltinQuaternaryCallNode((PythonQuaternaryBuiltinNode)node, argumentsList[0], argumentsList[1], argumentsList[2], argumentsList[3]);
                } else if (node instanceof PythonSenaryBuiltinNode) {
                    assert (argumentsList.length == 6) : "mismatch in number of arguments for " + node.getClass().getName() + ", expected 6, got " + argumentsList.length;
                    newBody = new BuiltinCallNode.BuiltinSenaryCallNode((PythonSenaryBuiltinNode)node, argumentsList[0], argumentsList[1], argumentsList[2], argumentsList[3], argumentsList[4], argumentsList[5]);
                } else if (node instanceof PythonVarargsBuiltinNode) {
                    assert (argumentsList.length == 3) : "mismatch in number of arguments for " + node.getClass().getName() + ", expected 3, got " + argumentsList.length;
                    assert (argumentsList[0] != null && argumentsList[1] != null && argumentsList[2] != null);
                    newBody = new BuiltinCallNode.BuiltinVarArgsCallNode((PythonVarargsBuiltinNode)node, argumentsList[0], argumentsList[1], argumentsList[2]);
                } else {
                    throw new RuntimeException("unexpected builtin node type: " + node.getClass());
                }
            }
            this.body = this.builtin.reverseOperation() ? (BuiltinCallNode)this.insert(new WrapBinaryfuncR(newBody)) : (this.constructsClass != PythonBuiltinClassType.nil ? (BuiltinCallNode)this.insert(new WrapTpNew(newBody, this.constructsClass)) : (BuiltinCallNode)this.insert(newBody));
        }
        this.calleeContext.enter(frame);
        try {
            Object object = this.body.execute(frame);
            return object;
        }
        finally {
            this.calleeContext.exit(frame, this);
        }
    }

    public String getFunctionName() {
        return this.name;
    }

    public NodeFactory<? extends PythonBuiltinBaseNode> getFactory() {
        return this.factory;
    }

    public Builtin getBuiltin() {
        return this.builtin;
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        Class<?> clazz = this.factory.getNodeClass().getEnclosingClass();
        String context = clazz == null ? "" : clazz.getSimpleName() + ".";
        return "<builtin function " + context + this.name + " at " + Integer.toHexString(((Object)((Object)this)).hashCode()) + ">";
    }

    public String getName() {
        return this.name;
    }

    public boolean declaresExplicitSelf() {
        return this.declaresExplicitSelf;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isPythonInternal() {
        return true;
    }

    protected boolean isCloneUninitializedSupported() {
        return true;
    }

    protected RootNode cloneUninitialized() {
        return new BuiltinFunctionRootNode((PythonLanguage)this.getLanguage(PythonLanguage.class), this.signature, this.builtin, this.factory, this.declaresExplicitSelf, this.constructsClass);
    }

    public static class StandaloneBuiltinFactory<T extends PythonBuiltinBaseNode>
    implements NodeFactory<T> {
        private final T node;

        public StandaloneBuiltinFactory(T node) {
            this.node = node;
        }

        public T createNode(Object ... arguments) {
            return (T)((PythonBuiltinBaseNode)NodeUtil.cloneNode(this.node));
        }

        public Class<T> getNodeClass() {
            return StandaloneBuiltinFactory.determineNodeClass(this.node);
        }

        private static <T> Class<T> determineNodeClass(T node) {
            CompilerAsserts.neverPartOfCompilation();
            Class nodeClass = node.getClass();
            GeneratedBy genBy = nodeClass.getAnnotation(GeneratedBy.class);
            if (genBy != null) {
                nodeClass = genBy.value();
                assert (nodeClass.isAssignableFrom(node.getClass()));
            }
            return nodeClass;
        }

        public List<List<Class<?>>> getNodeSignatures() {
            throw new IllegalAccessError();
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            throw new IllegalAccessError();
        }
    }
}

