/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltins;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectGetItemNodeGen;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
public abstract class PyObjectGetItem
extends PNodeWithContext {
    public static Object executeUncached(Object receiver, Object key) {
        return PyObjectGetItemNodeGen.getUncached().execute(null, null, receiver, key);
    }

    public final Object executeCached(Frame frame, Object object, Object key) {
        return this.execute(frame, this, object, key);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3, Object var4);

    @Specialization(guards={"cannotBeOverriddenForImmutableType(object)"})
    static Object doList(VirtualFrame frame, PList object, Object key, @Cached ListBuiltins.GetItemNode getItemNode) {
        return getItemNode.execute(frame, object, key);
    }

    @Specialization(guards={"cannotBeOverriddenForImmutableType(object)"})
    static Object doTuple(VirtualFrame frame, PTuple object, Object key, @Cached TupleBuiltins.GetItemNode getItemNode) {
        return getItemNode.execute(frame, object, key);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"cannotBeOverriddenForImmutableType(object)"})
    static Object doDict(VirtualFrame frame, PDict object, Object key, @Cached DictBuiltins.GetItemNode getItemNode) {
        return getItemNode.execute(frame, object, key);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(replaces={"doList", "doTuple", "doDict"})
    static Object doGeneric(VirtualFrame frame, Node inliningTarget, Object object, Object key, @Cached GetClassNode getClassNode, @Cached(parameters={"GetItem"}, inline=false) LookupSpecialMethodSlotNode lookupGetItem, @Cached(inline=false) CallBinaryMethodNode callGetItem, @Cached(inline=false) LazyPyObjectGetItemClass getItemClass, @Cached PRaiseNode.Lazy raise) {
        Object type = getClassNode.execute(inliningTarget, object);
        Object getItem = lookupGetItem.execute((Frame)frame, type, object);
        if (getItem != PNone.NO_VALUE) {
            return callGetItem.executeObject((Frame)frame, getItem, object, key);
        }
        Object item = getItemClass.get(inliningTarget).execute((Frame)frame, object, key);
        if (item != PNone.NO_VALUE) {
            return item;
        }
        throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_NOT_SUBSCRIPTABLE, object);
    }

    @NeverDefault
    public static PyObjectGetItem create() {
        return PyObjectGetItemNodeGen.create();
    }

    public static PyObjectGetItem getUncached() {
        return PyObjectGetItemNodeGen.getUncached();
    }

    @GenerateUncached
    @GenerateCached
    @GenerateInline(value=false)
    static abstract class LazyPyObjectGetItemClass
    extends Node {
        LazyPyObjectGetItemClass() {
        }

        public final PyObjectGetItemClass get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        abstract PyObjectGetItemClass execute(Node var1);

        @Specialization
        static PyObjectGetItemClass doIt(@Cached PyObjectGetItemClass node) {
            return node;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class PyObjectGetItemClass
    extends PNodeWithContext {
        PyObjectGetItemClass() {
        }

        public abstract Object execute(Frame var1, Object var2, Object var3);

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object type, Object key, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached PyObjectLookupAttr lookupClassGetItem, @Cached BuiltinClassProfiles.InlineIsBuiltinClassProfile isBuiltinClassProfile, @Cached PythonObjectFactory factory, @Cached CallNode callClassGetItem) {
            if (isTypeNode.execute(inliningTarget, type)) {
                Object classGetitem = lookupClassGetItem.execute((Frame)frame, inliningTarget, type, SpecialMethodNames.T___CLASS_GETITEM__);
                if (classGetitem != PNone.NO_VALUE) {
                    return callClassGetItem.execute((Frame)frame, classGetitem, key);
                }
                if (isBuiltinClassProfile.profileClass(inliningTarget, type, PythonBuiltinClassType.PythonClass)) {
                    return factory.createGenericAlias(type, key);
                }
            }
            return PNone.NO_VALUE;
        }
    }
}

