/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.posix;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.posix.DirEntryBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.posix.DirEntryBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.posix.PDirEntry;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDirEntry})
public final class DirEntryBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DirEntryBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object classGetItem(Object cls, Object key) {
            return this.factory().createGenericAlias(cls, key);
        }
    }

    @Builtin(name="is_dir", minNumOfPositionalArgs=1, parameterNames={"$self"}, varArgsMarker=true, keywordOnlyNames={"follow_symlinks"})
    @ArgumentClinic(name="follow_symlinks", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")
    @GenerateNodeFactory
    static abstract class IsDirNode
    extends PythonClinicBuiltinNode {
        IsDirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DirEntryBuiltinsClinicProviders.IsDirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static boolean isDir(VirtualFrame frame, PDirEntry self, boolean followSymlinks, @Cached(value="createDir()") TestModeNode testModeNode) {
            return testModeNode.execute(frame, self, followSymlinks);
        }
    }

    @Builtin(name="is_file", minNumOfPositionalArgs=1, parameterNames={"$self"}, varArgsMarker=true, keywordOnlyNames={"follow_symlinks"})
    @ArgumentClinic(name="follow_symlinks", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")
    @GenerateNodeFactory
    static abstract class IsFileNode
    extends PythonClinicBuiltinNode {
        IsFileNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DirEntryBuiltinsClinicProviders.IsFileNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static boolean isFile(VirtualFrame frame, PDirEntry self, boolean followSymlinks, @Cached(value="createReg()") TestModeNode testModeNode) {
            return testModeNode.execute(frame, self, followSymlinks);
        }
    }

    @Builtin(name="is_symlink", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsSymlinkNode
    extends PythonUnaryBuiltinNode {
        IsSymlinkNode() {
        }

        abstract boolean executeBoolean(VirtualFrame var1, PDirEntry var2);

        @Specialization
        static boolean isSymlink(VirtualFrame frame, PDirEntry self, @Cached(value="createLnk()") TestModeNode testModeNode) {
            return testModeNode.execute(frame, self, false);
        }
    }

    static abstract class TestModeNode
    extends Node {
        private final long expectedMode;
        private final int expectedDirEntryType;
        private StatHelperNode statHelperNode;

        protected TestModeNode(long expectedMode, int expectedDirEntryType) {
            this.expectedMode = expectedMode;
            this.expectedDirEntryType = expectedDirEntryType;
        }

        abstract boolean execute(VirtualFrame var1, PDirEntry var2, boolean var3);

        @Specialization(guards={"followSymlinks"})
        boolean testModeUsingStat(VirtualFrame frame, PDirEntry self, boolean followSymlinks) {
            PTuple statResult = this.getStatHelperNode().execute(frame, self, followSymlinks, true);
            if (statResult == null) {
                return false;
            }
            long mode = (Long)statResult.getSequenceStorage().getItemNormalized(0) & (long)PosixConstants.S_IFMT.value;
            return mode == this.expectedMode;
        }

        @Specialization(guards={"!followSymlinks"})
        boolean useTypeIfKnown(VirtualFrame frame, PDirEntry self, boolean followSymlinks, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            int entryType = posixLib.dirEntryGetType(PosixSupport.get(this), self.dirEntryData);
            if (entryType != PosixConstants.DT_UNKNOWN.value) {
                return entryType == this.expectedDirEntryType;
            }
            return this.testModeUsingStat(frame, self, false);
        }

        private StatHelperNode getStatHelperNode() {
            if (this.statHelperNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.statHelperNode = (StatHelperNode)this.insert(DirEntryBuiltinsFactory.StatHelperNodeGen.create());
            }
            return this.statHelperNode;
        }

        @NeverDefault
        static TestModeNode create(long expectedMode, int expectedDirEntryType) {
            return DirEntryBuiltinsFactory.TestModeNodeGen.create(expectedMode, expectedDirEntryType);
        }

        @NeverDefault
        static TestModeNode createLnk() {
            return TestModeNode.create(PosixConstants.S_IFLNK.value, PosixConstants.DT_LNK.value);
        }

        @NeverDefault
        static TestModeNode createReg() {
            return TestModeNode.create(PosixConstants.S_IFREG.value, PosixConstants.DT_REG.value);
        }

        @NeverDefault
        static TestModeNode createDir() {
            return TestModeNode.create(PosixConstants.S_IFDIR.value, PosixConstants.DT_DIR.value);
        }
    }

    @GenerateInline(value=false)
    static abstract class StatHelperNode
    extends StatHelperSimpleNode {
        StatHelperNode() {
        }

        @Specialization(guards={"followSymlinks", "self.statCache == null", "!isSymlink"}, limit="1")
        static PTuple uncachedStatWithSymlink(VirtualFrame frame, PDirEntry self, boolean followSymlinks, boolean catchNoent, @Cached IsSymlinkNode isSymlinkNode, @Bind(value="isSymlinkNode.executeBoolean(frame, self)") boolean isSymlink, @Cached StatHelperSimpleNode recursiveNode) {
            PTuple res = recursiveNode.execute(frame, self, false, catchNoent);
            self.setStatCache(followSymlinks, res);
            return res;
        }
    }

    @GenerateInline(value=false)
    static abstract class StatHelperSimpleNode
    extends Node {
        StatHelperSimpleNode() {
        }

        abstract PTuple execute(VirtualFrame var1, PDirEntry var2, boolean var3, boolean var4);

        @Specialization(guards={"followSymlinks", "self.statCache != null"})
        static PTuple cachedStat(PDirEntry self, boolean followSymlinks, boolean catchNoent) {
            return self.statCache;
        }

        @Specialization(guards={"!followSymlinks", "self.lstatCache != null"})
        static PTuple cachedLStat(PDirEntry self, boolean followSymlinks, boolean catchNoent) {
            return self.lstatCache;
        }

        @Specialization(guards={"followSymlinks", "self.statCache == null", "isSymlink"}, limit="1")
        static PTuple uncachedStatWithSymlink(VirtualFrame frame, PDirEntry self, boolean followSymlinks, boolean catchNoent, @Bind(value="this") Node inliningTarget, @Cached IsSymlinkNode isSymlinkNode, @Bind(value="isSymlinkNode.executeBoolean(frame, self)") boolean isSymlink, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared(value="cachedPosixPathNode") @Cached CachedPosixPathNode cachedPosixPathNode, @Cached.Shared(value="positiveLongProfile") @Cached InlinedConditionProfile positiveLongProfile, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return StatHelperSimpleNode.uncachedLStatWithSymlink(frame, self, followSymlinks, catchNoent, inliningTarget, posixLib, cachedPosixPathNode, positiveLongProfile, constructAndRaiseNode, factory);
        }

        @Specialization(guards={"!followSymlinks", "self.lstatCache == null"})
        static PTuple uncachedLStatWithSymlink(VirtualFrame frame, PDirEntry self, boolean followSymlinks, boolean catchNoent, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared(value="cachedPosixPathNode") @Cached CachedPosixPathNode cachedPosixPathNode, @Cached.Shared(value="positiveLongProfile") @Cached InlinedConditionProfile positiveLongProfile, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            PTuple res;
            int dirFd = self.scandirPath instanceof PosixModuleBuiltins.PosixFd ? ((PosixModuleBuiltins.PosixFd)self.scandirPath).fd : PosixConstants.AT_FDCWD.value;
            PosixModuleBuiltins.PosixPath posixPath = cachedPosixPathNode.execute(frame, inliningTarget, self);
            try {
                long[] rawStat = posixLib.fstatat(PosixSupport.get(inliningTarget), dirFd, posixPath.value, followSymlinks);
                res = PosixModuleBuiltins.createStatResult(inliningTarget, factory, positiveLongProfile, rawStat);
            }
            catch (PosixSupportLibrary.PosixException e) {
                if (catchNoent && e.getErrorCode() == OSErrorEnum.ENOENT.getNumber()) {
                    return null;
                }
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, posixPath.originalObject);
            }
            self.setStatCache(followSymlinks, res);
            return res;
        }
    }

    @Builtin(name="stat", minNumOfPositionalArgs=1, parameterNames={"$self"}, varArgsMarker=true, keywordOnlyNames={"follow_symlinks"}, doc="return stat_result object for the entry; cached per entry")
    @ArgumentClinic(name="follow_symlinks", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")
    @GenerateNodeFactory
    static abstract class StatNode
    extends PythonClinicBuiltinNode {
        StatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DirEntryBuiltinsClinicProviders.StatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object stat(VirtualFrame frame, PDirEntry self, boolean followSymlinks, @Cached StatHelperNode statHelperNode) {
            return statHelperNode.execute(frame, self, followSymlinks, false);
        }
    }

    @Builtin(name="inode", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class InodeNode
    extends PythonUnaryBuiltinNode {
        InodeNode() {
        }

        @Specialization
        long inode(VirtualFrame frame, PDirEntry self, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.dirEntryGetInode(this.getPosixSupport(), self.dirEntryData);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="__fspath__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FspathNode
    extends PythonUnaryBuiltinNode {
        FspathNode() {
        }

        @Specialization
        static Object fspath(VirtualFrame frame, PDirEntry self, @Cached PathNode pathNode) {
            return pathNode.execute(frame, self);
        }
    }

    @Builtin(name="path", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class PathNode
    extends PythonUnaryBuiltinNode {
        PathNode() {
        }

        @Specialization
        static Object path(VirtualFrame frame, PDirEntry self, @Bind(value="this") Node inliningTarget, @Cached CachedPosixPathNode cachedPosixPathNode) {
            return cachedPosixPathNode.execute((VirtualFrame)frame, (Node)inliningTarget, (PDirEntry)self).originalObject;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CachedPosixPathNode
    extends Node {
        CachedPosixPathNode() {
        }

        abstract PosixModuleBuiltins.PosixPath execute(VirtualFrame var1, Node var2, PDirEntry var3);

        @Specialization(guards={"self.pathCache != null"})
        static PosixModuleBuiltins.PosixPath cached(PDirEntry self) {
            return self.pathCache;
        }

        @Specialization(guards={"self.pathCache == null"})
        static PosixModuleBuiltins.PosixPath createBytes(VirtualFrame frame, Node inliningTarget, PDirEntry self, @Cached InlinedConditionProfile produceBytesProfile, @Cached InlinedConditionProfile posixPathProfile, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PythonObjectFactory.Lazy factory, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            Object opaquePath;
            try {
                opaquePath = posixPathProfile.profile(inliningTarget, self.scandirPath instanceof PosixModuleBuiltins.PosixPath) ? posixLib.dirEntryGetPath(PosixSupport.get(inliningTarget), self.dirEntryData, ((PosixModuleBuiltins.PosixPath)self.scandirPath).value) : posixLib.dirEntryGetName(PosixSupport.get(inliningTarget), self.dirEntryData);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            self.pathCache = produceBytesProfile.profile(inliningTarget, self.produceBytes()) ? new PosixModuleBuiltins.PosixPath(PosixModuleBuiltins.opaquePathToBytes(opaquePath, posixLib, PosixSupport.get(inliningTarget), factory.get(inliningTarget)), opaquePath, true) : new PosixModuleBuiltins.PosixPath(posixLib.getPathAsString(PosixSupport.get(inliningTarget), opaquePath), opaquePath, false);
            return self.pathCache;
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(VirtualFrame frame, PDirEntry self, @Bind(value="this") Node inliningTarget, @Cached NameNode nameNode, @Cached(value="create(Repr)") LookupAndCallUnaryNode reprNode, @Cached CastToTruffleStringNode castToStringNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<DirEntry %s>", castToStringNode.execute(inliningTarget, reprNode.executeObject(frame, nameNode.execute(frame, self))));
        }
    }

    @Builtin(name="name", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class NameNode
    extends PythonUnaryBuiltinNode {
        NameNode() {
        }

        @Specialization
        Object nameAsBytes(VirtualFrame frame, PDirEntry self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile produceBytesProfile, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                if (produceBytesProfile.profile(inliningTarget, self.produceBytes())) {
                    return PosixModuleBuiltins.opaquePathToBytes(posixLib.dirEntryGetName(this.getPosixSupport(), self.dirEntryData), posixLib, this.getPosixSupport(), this.factory());
                }
                return posixLib.getPathAsString(this.getPosixSupport(), posixLib.dirEntryGetName(this.getPosixSupport(), self.dirEntryData));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }
}

