/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.generator;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.PrepareExceptionNode;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.builtins.objects.generator.ThrowData;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.bytecode.FrameInfo;
import com.oracle.graal.python.nodes.bytecode.GeneratorReturnException;
import com.oracle.graal.python.nodes.bytecode.GeneratorYieldResult;
import com.oracle.graal.python.nodes.call.CallTargetInvokeNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCoroutine, PythonBuiltinClassType.PGenerator})
public final class CommonGeneratorBuiltins
extends PythonBuiltins {
    private static Object[] prepareArguments(PGenerator self) {
        Object[] generatorArguments = self.getArguments();
        Object[] arguments = new Object[generatorArguments.length];
        PythonUtils.arraycopy(generatorArguments, 0, arguments, 0, arguments.length);
        return arguments;
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CommonGeneratorBuiltinsFactory.getFactories();
    }

    private static void checkResumable(PythonBuiltinBaseNode node, PGenerator self) {
        if (self.isFinished()) {
            if (self.isAsyncGen()) {
                throw node.raise(PythonBuiltinClassType.StopAsyncIteration);
            }
            if (self.isCoroutine()) {
                throw node.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.CANNOT_REUSE_CORO);
            }
            throw node.raiseStopIteration();
        }
        if (self.isRunning()) {
            throw node.raise(PythonErrorType.ValueError, ErrorMessages.GENERATOR_ALREADY_EXECUTING);
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object close(VirtualFrame frame, PGenerator self, @Bind(value="this") Node inliningTarget, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isGeneratorExit, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIteration, @Cached ResumeGeneratorNode resumeGeneratorNode, @Cached InlinedConditionProfile isStartedPorfile) {
            if (self.isRunning()) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.GENERATOR_ALREADY_EXECUTING);
            }
            if (isStartedPorfile.profile(inliningTarget, self.isStarted() && !self.isFinished())) {
                PBaseException pythonException = this.factory().createBaseException((Object)PythonBuiltinClassType.GeneratorExit);
                boolean withJavaStacktrace = PythonOptions.isPExceptionWithJavaStacktrace(this.getLanguage());
                try {
                    resumeGeneratorNode.execute(frame, inliningTarget, self, new ThrowData(pythonException, withJavaStacktrace));
                }
                catch (PException pe) {
                    if (isGeneratorExit.profileException(inliningTarget, pe, PythonBuiltinClassType.GeneratorExit) || isStopIteration.profileException(inliningTarget, pe, PythonErrorType.StopIteration)) {
                        PNone pNone = PNone.NONE;
                        return pNone;
                    }
                    throw pe;
                }
                finally {
                    self.markAsFinished();
                }
                throw this.raise(PythonErrorType.RuntimeError, ErrorMessages.GENERATOR_IGNORED_EXIT);
            }
            self.markAsFinished();
            return PNone.NONE;
        }
    }

    @Builtin(name="throw", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=4)
    @GenerateNodeFactory
    public static abstract class ThrowNode
    extends PythonQuaternaryBuiltinNode {
        @Specialization
        Object sendThrow(VirtualFrame frame, PGenerator self, Object typ, Object val, Object tb, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile hasTbProfile, @Cached InlinedConditionProfile startedProfile, @Cached InlinedBranchProfile invalidTbProfile, @Cached InlinedBranchProfile runningProfile, @Cached PrepareExceptionNode prepareExceptionNode, @Cached ResumeGeneratorNode resumeGeneratorNode, @Cached ExceptionNodes.GetTracebackNode getTracebackNode, @Cached ExceptionNodes.SetTracebackNode setTracebackNode, @Cached ExceptionNodes.SetContextNode setContextNode) {
            PTraceback existingTraceback;
            boolean hasTb = hasTbProfile.profile(inliningTarget, !(tb instanceof PNone));
            if (hasTb && !(tb instanceof PTraceback)) {
                invalidTbProfile.enter(inliningTarget);
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.THROW_THIRD_ARG_MUST_BE_TRACEBACK);
            }
            if (self.isRunning()) {
                runningProfile.enter(inliningTarget);
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.GENERATOR_ALREADY_EXECUTING);
            }
            Object instance = prepareExceptionNode.execute(frame, typ, val);
            if (hasTb) {
                setTracebackNode.execute(inliningTarget, instance, tb);
            }
            PythonLanguage language = this.getLanguage();
            setContextNode.execute(inliningTarget, instance, PNone.NONE);
            if (self.isCoroutine() && self.isFinished()) {
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.CANNOT_REUSE_CORO);
            }
            if (startedProfile.profile(inliningTarget, self.isStarted() && !self.isFinished())) {
                return resumeGeneratorNode.execute(frame, inliningTarget, self, new ThrowData(instance, PythonOptions.isPExceptionWithJavaStacktrace(language)));
            }
            self.markAsFinished();
            RootNode location = self.getCurrentCallTarget().getRootNode();
            MaterializedFrame generatorFrame = PArguments.getGeneratorFrame(self.getArguments());
            PFrame pFrame = MaterializeFrameNode.materializeGeneratorFrame((Node)location, generatorFrame, PFrame.Reference.EMPTY, this.factory());
            FrameInfo info = (FrameInfo)generatorFrame.getFrameDescriptor().getInfo();
            pFrame.setLine(info.getRootNode().getFirstLineno());
            Object existingTracebackObj = getTracebackNode.execute(inliningTarget, instance);
            PTraceback newTraceback = this.factory().createTraceback(pFrame, pFrame.getLine(), existingTracebackObj instanceof PTraceback ? (existingTraceback = (PTraceback)existingTracebackObj) : null);
            setTracebackNode.execute(inliningTarget, instance, newTraceback);
            throw PException.fromObject(instance, (Node)location, PythonOptions.isPExceptionWithJavaStacktrace(language));
        }
    }

    @Builtin(name="send", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SendNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object send(VirtualFrame frame, PGenerator self, Object value, @Bind(value="this") Node inliningTarget, @Cached ResumeGeneratorNode resumeGeneratorNode) {
            CommonGeneratorBuiltins.checkResumable(this, self);
            if (!self.isStarted() && value != PNone.NONE) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.SEND_NON_NONE_TO_UNSTARTED_GENERATOR);
            }
            return resumeGeneratorNode.execute(frame, inliningTarget, self, value);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class, PythonOptions.class})
    static abstract class ResumeGeneratorNode
    extends Node {
        ResumeGeneratorNode() {
        }

        public abstract Object execute(VirtualFrame var1, Node var2, PGenerator var3, Object var4);

        @Specialization(guards={"sameCallTarget(self.getCurrentCallTarget(), call.getCallTarget())"}, limit="getCallSiteInlineCacheMaxDepth()")
        static Object cached(VirtualFrame frame, Node inliningTarget, PGenerator self, Object sendValue, @Cached(value="createDirectCall(self.getCurrentCallTarget())", inline=false) CallTargetInvokeNode call, @Cached.Exclusive @Cached InlinedBranchProfile returnProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            GeneratorYieldResult result;
            self.setRunning(true);
            Object[] arguments = CommonGeneratorBuiltins.prepareArguments(self);
            if (sendValue != null) {
                PArguments.setSpecialArgument(arguments, sendValue);
            }
            try {
                result = (GeneratorYieldResult)call.execute(frame, null, null, null, arguments);
            }
            catch (PException e) {
                throw ResumeGeneratorNode.handleException(self, inliningTarget, errorProfile, raiseNode, e);
            }
            catch (GeneratorReturnException e) {
                returnProfile.enter(inliningTarget);
                throw ResumeGeneratorNode.handleReturn(self, e, raiseNode.get(inliningTarget));
            }
            finally {
                self.setRunning(false);
            }
            return ResumeGeneratorNode.handleResult(inliningTarget, self, result);
        }

        @Specialization(replaces={"cached"})
        @ReportPolymorphism.Megamorphic
        static Object generic(VirtualFrame frame, Node inliningTarget, PGenerator self, Object sendValue, @Cached InlinedConditionProfile hasFrameProfile, @Cached(inline=false) GenericInvokeNode call, @Cached.Exclusive @Cached InlinedBranchProfile returnProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            GeneratorYieldResult result;
            self.setRunning(true);
            Object[] arguments = CommonGeneratorBuiltins.prepareArguments(self);
            if (sendValue != null) {
                PArguments.setSpecialArgument(arguments, sendValue);
            }
            try {
                result = hasFrameProfile.profile(inliningTarget, frame != null) ? (GeneratorYieldResult)call.execute(frame, self.getCurrentCallTarget(), arguments) : (GeneratorYieldResult)call.execute(self.getCurrentCallTarget(), arguments);
            }
            catch (PException e) {
                throw ResumeGeneratorNode.handleException(self, inliningTarget, errorProfile, raiseNode, e);
            }
            catch (GeneratorReturnException e) {
                returnProfile.enter(inliningTarget);
                throw ResumeGeneratorNode.handleReturn(self, e, raiseNode.get(inliningTarget));
            }
            finally {
                self.setRunning(false);
            }
            return ResumeGeneratorNode.handleResult(inliningTarget, self, result);
        }

        private static PException handleException(PGenerator self, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile profile, PRaiseNode.Lazy raiseNode, PException e) {
            self.markAsFinished();
            if (self.isAsyncGen() && profile.profileException(inliningTarget, e, PythonBuiltinClassType.StopAsyncIteration)) {
                throw raiseNode.get(inliningTarget).raiseWithCause(PythonErrorType.RuntimeError, e.getEscapedException(), ErrorMessages.ASYNCGEN_RAISED_ASYNCSTOPITER, new Object[0]);
            }
            e.expectStopIteration(inliningTarget, profile);
            throw raiseNode.get(inliningTarget).raiseWithCause(PythonErrorType.RuntimeError, e.getEscapedException(), ErrorMessages.GENERATOR_RAISED_STOPITER, new Object[0]);
        }

        private static Object handleResult(Node node, PGenerator self, GeneratorYieldResult result) {
            self.handleResult(PythonLanguage.get(node), result);
            return result.yieldValue;
        }

        private static PException handleReturn(PGenerator self, GeneratorReturnException e, PRaiseNode raiseNode) {
            self.markAsFinished();
            if (self.isAsyncGen()) {
                throw raiseNode.raise(PythonBuiltinClassType.StopAsyncIteration);
            }
            if (e.value != PNone.NONE) {
                throw raiseNode.raise(PythonErrorType.StopIteration, new Object[]{e.value});
            }
            throw raiseNode.raise(PythonErrorType.StopIteration);
        }

        protected static CallTargetInvokeNode createDirectCall(CallTarget target) {
            return CallTargetInvokeNode.create(target, false, true);
        }

        protected static boolean sameCallTarget(RootCallTarget target1, CallTarget target2) {
            return target1 == target2;
        }
    }
}

