/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.ConditionProfile;

@ExportLibrary(value=InteropLibrary.class)
public final class PythonObjectNativeWrapper
extends PythonNativeWrapper {
    public PythonObjectNativeWrapper(PythonAbstractObject object) {
        super(object);
    }

    public static PythonNativeWrapper wrap(PythonAbstractObject obj, ConditionProfile noWrapperProfile) {
        PythonNativeWrapper nativeWrapper = obj.getNativeWrapper();
        if (noWrapperProfile.profile(nativeWrapper == null)) {
            nativeWrapper = new PythonObjectNativeWrapper(obj);
            obj.setNativeWrapper(nativeWrapper);
        }
        return nativeWrapper;
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return PythonUtils.formatJString("PythonObjectNativeWrapper(%s, isNative=%s)", this.getDelegate(), this.isNative());
    }

    @ExportMessage
    protected boolean isNull() {
        return this.getDelegate() == PNone.NO_VALUE;
    }

    @ExportMessage
    protected boolean isPointer() {
        return this.getDelegate() == PNone.NO_VALUE || this.isNative();
    }

    @ExportMessage
    protected long asPointer() {
        return this.getDelegate() == PNone.NO_VALUE ? 0L : this.getNativePointer();
    }

    @ExportMessage
    protected void toNative() {
        if (this.getDelegate() != PNone.NO_VALUE && !this.isNative()) {
            CApiTransitions.firstToNative(this);
        }
    }
}

