/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.utilities.TriState;

@ExportLibrary(value=InteropLibrary.class)
public final class PrimitiveNativeWrapper
extends PythonNativeWrapper {
    public static final byte PRIMITIVE_STATE_BOOL = 1;
    public static final byte PRIMITIVE_STATE_INT = 4;
    public static final byte PRIMITIVE_STATE_LONG = 8;
    public static final byte PRIMITIVE_STATE_DOUBLE = 16;
    private final byte state;
    private final long value;
    private final double dvalue;

    private PrimitiveNativeWrapper(byte state, long value) {
        assert (state != 16);
        this.state = state;
        this.value = value;
        this.dvalue = 0.0;
    }

    private PrimitiveNativeWrapper(double dvalue) {
        this.state = (byte)16;
        this.value = 0L;
        this.dvalue = dvalue;
    }

    public byte getState() {
        return this.state;
    }

    public boolean getBool() {
        return this.value != 0L;
    }

    public int getInt() {
        return (int)this.value;
    }

    public long getLong() {
        return this.value;
    }

    public double getDouble() {
        return this.dvalue;
    }

    public boolean isBool() {
        return this.state == 1;
    }

    public boolean isInt() {
        return this.state == 4;
    }

    public boolean isLong() {
        return this.state == 8;
    }

    public boolean isDouble() {
        return this.state == 16;
    }

    public boolean isIntLike() {
        return (this.state & 0xC) != 0;
    }

    public boolean isSubtypeOfInt() {
        return !this.isDouble();
    }

    public Object getMaterializedObject() {
        return this.getDelegate();
    }

    public void setMaterializedObject(Object materializedPrimitive) {
        this.setDelegate(materializedPrimitive);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompilerAsserts.neverPartOfCompilation();
        PrimitiveNativeWrapper other = (PrimitiveNativeWrapper)obj;
        if (other.state == this.state && other.value == this.value && other.dvalue == this.dvalue) {
            return this.getNativePointer() == other.getNativePointer();
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.value) ^ Long.hashCode(Double.doubleToRawLongBits(this.dvalue)) ^ this.state;
    }

    public String toString() {
        String typeName = this.isIntLike() ? "int" : (this.isDouble() ? "float" : (this.isBool() ? "bool" : "unknown"));
        return "PrimitiveNativeWrapper(" + typeName + "(" + this.value + "))";
    }

    public static PrimitiveNativeWrapper createBool(boolean val) {
        return new PrimitiveNativeWrapper(1, PInt.intValue(val));
    }

    public static PrimitiveNativeWrapper createInt(int val) {
        return new PrimitiveNativeWrapper(4, val);
    }

    public static PrimitiveNativeWrapper createLong(long val) {
        return new PrimitiveNativeWrapper(8, val);
    }

    public static PrimitiveNativeWrapper createDouble(double val) {
        return new PrimitiveNativeWrapper(val);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    int identityHashCode() {
        int val = Byte.hashCode(this.state) ^ Long.hashCode(this.value);
        if (Double.isNaN(this.dvalue)) {
            return val;
        }
        return val ^ Double.hashCode(this.dvalue);
    }

    @ExportMessage
    TriState isIdenticalOrUndefined(Object obj) {
        if (obj instanceof PrimitiveNativeWrapper) {
            PrimitiveNativeWrapper other = (PrimitiveNativeWrapper)obj;
            if (other.state == this.state && other.value == this.value && (other.dvalue == this.dvalue || Double.isNaN(this.dvalue) && Double.isNaN(other.dvalue))) {
                return TriState.valueOf((this.getNativePointer() == other.getNativePointer() ? 1 : 0) != 0);
            }
            return TriState.FALSE;
        }
        return TriState.UNDEFINED;
    }

    @ExportMessage
    protected boolean isPointer() {
        return this.isNative();
    }

    @ExportMessage
    protected void toNative() {
        if (!this.isNative()) {
            CApiTransitions.firstToNative(this);
        }
    }

    @ExportMessage
    static abstract class AsPointer {
        AsPointer() {
        }

        @Specialization(guards={"obj.isBool()", "!obj.isNative()"})
        static long doBoolNotNative(PrimitiveNativeWrapper obj, @Cached CExtNodes.MaterializeDelegateNode materializeNode) {
            PInt boxed = (PInt)materializeNode.execute(obj);
            assert (obj.getNativePointer() == boxed.getNativeWrapper().getNativePointer());
            return obj.getNativePointer();
        }

        @Specialization(guards={"!obj.isBool() || obj.isNative()"})
        static long doBoolNative(PrimitiveNativeWrapper obj) {
            return obj.getNativePointer();
        }
    }
}

