/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArrayBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCArray})
public final class PyCArrayBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PyCArrayBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object classGetItem(Object cls, Object key) {
            return this.factory().createGenericAlias(cls, key);
        }
    }

    @Builtin(name="__len__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        LenNode() {
        }

        @Specialization
        static int Array_length(CDataObject self) {
            return self.b_length;
        }
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class PyCArrayGetItemNode
    extends PythonBinaryBuiltinNode {
        PyCArrayGetItemNode() {
        }

        protected static boolean isInvalid(CDataObject self, int index) {
            return index < 0 || index >= self.b_length;
        }

        @Specialization(guards={"!isInvalid(self, index)"})
        Object Array_item(CDataObject self, int index, @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode) {
            StgDictObject stgdict = pyObjectStgDictNode.execute(self);
            assert (stgdict != null) : "Cannot be NULL for array object instances";
            int size = stgdict.size / stgdict.length;
            int offset = index * size;
            return pyCDataGetNode.execute(stgdict.proto, stgdict.getfunc, self, index, size, self.b_ptr.withOffset(offset));
        }

        @Specialization(limit="1")
        Object Array_subscript(CDataObject self, PSlice slice, @CachedLibrary(value="self") PythonBufferAccessLibrary bufferLib, @Bind(value="this") Node inliningTarget, @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached SliceNodes.SliceUnpack sliceUnpack, @Cached SliceNodes.AdjustIndices adjustIndices, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            StgDictObject stgdict = pyObjectStgDictNode.execute(self);
            assert (stgdict != null) : "Cannot be NULL for array object instances";
            Object proto = stgdict.proto;
            StgDictObject itemdict = pyTypeStgDictNode.execute(proto);
            assert (itemdict != null) : "proto is the item type of the array, a ctypes type, so this cannot be NULL";
            PSlice.SliceInfo sliceInfo = adjustIndices.execute(inliningTarget, self.b_length, sliceUnpack.execute(inliningTarget, slice));
            int slicelen = sliceInfo.sliceLength;
            if (itemdict.getfunc == FFIType.FieldDesc.c.getfunc) {
                byte[] ptr = bufferLib.getInternalOrCopiedByteArray(self);
                if (slicelen <= 0) {
                    return this.factory().createBytes(PythonUtils.EMPTY_BYTE_ARRAY);
                }
                if (sliceInfo.step == 1) {
                    return this.factory().createBytes(ptr, sliceInfo.start, slicelen);
                }
                byte[] dest = new byte[slicelen];
                int cur = sliceInfo.start;
                for (int i = 0; i < slicelen; ++i) {
                    dest[i] = ptr[cur];
                    cur += sliceInfo.step;
                }
                return this.factory().createBytes(dest);
            }
            if (itemdict.getfunc == FFIType.FieldDesc.u.getfunc) {
                byte[] ptr = bufferLib.getInternalOrCopiedByteArray(self);
                if (slicelen <= 0) {
                    return StringLiterals.T_EMPTY_STRING;
                }
                if (sliceInfo.step == 1) {
                    byte[] bytes = PythonUtils.arrayCopyOfRange(ptr, sliceInfo.start, slicelen);
                    return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(bytes, TruffleString.Encoding.UTF_8), PythonUtils.TS_ENCODING);
                }
                byte[] dest = new byte[slicelen];
                int cur = sliceInfo.start;
                for (int i = 0; i < slicelen; ++i) {
                    dest[i] = ptr[cur];
                    cur += sliceInfo.step;
                }
                return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(dest, TruffleString.Encoding.UTF_8), PythonUtils.TS_ENCODING);
            }
            Object[] np = new Object[slicelen];
            int cur = sliceInfo.start;
            for (int i = 0; i < slicelen; ++i) {
                np[i] = this.Array_item(self, cur, pyCDataGetNode, pyObjectStgDictNode);
                cur += sliceInfo.step;
            }
            return this.factory().createList(np);
        }

        @Specialization(guards={"!isPSlice(item)"})
        Object Array_item(VirtualFrame frame, CDataObject self, Object item, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode) {
            if (!indexCheckNode.execute(inliningTarget, item)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.INDICES_MUST_BE_INTEGERS);
            }
            Object idx = indexNode.execute((Frame)frame, inliningTarget, item);
            int index = asSizeNode.executeExact((Frame)frame, inliningTarget, idx);
            if (index < 0) {
                index += self.b_length;
            }
            if (PyCArrayGetItemNode.isInvalid(self, index)) {
                throw this.raise(PythonErrorType.IndexError, ErrorMessages.INVALID_INDEX);
            }
            return this.Array_item(self, index, pyCDataGetNode, pyObjectStgDictNode);
        }
    }

    @Builtin(name="__setitem__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class PyCArraySetItemNode
    extends PythonTernaryBuiltinNode {
        PyCArraySetItemNode() {
        }

        @Specialization(guards={"!isPNone(value)"})
        Object Array_ass_item(VirtualFrame frame, CDataObject self, int index, Object value, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached CDataTypeBuiltins.PyCDataSetNode pyCDataSetNode) {
            StgDictObject stgdict = pyObjectStgDictNode.execute(self);
            assert (stgdict != null) : "Cannot be NULL for array object instances";
            if (index < 0 || index >= stgdict.length) {
                throw this.raise(PythonErrorType.IndexError, ErrorMessages.INVALID_INDEX);
            }
            int size = stgdict.size / stgdict.length;
            int offset = index * size;
            pyCDataSetNode.execute(frame, self, stgdict.proto, stgdict.setfunc, value, index, size, self.b_ptr.withOffset(offset));
            return PNone.NONE;
        }

        @Specialization(guards={"!isPNone(value)", "!isPSlice(item)"})
        Object Array_ass_subscript(VirtualFrame frame, CDataObject self, Object item, Object value, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSint, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached CDataTypeBuiltins.PyCDataSetNode pyCDataSetNode) {
            int i;
            if (indexCheckNode.execute(inliningTarget, item)) {
                i = asSint.executeExact((Frame)frame, inliningTarget, item, PythonErrorType.IndexError);
                if (i < 0) {
                    i += self.b_length;
                }
            } else {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.INDICES_MUST_BE_INTEGER);
            }
            this.Array_ass_item(frame, self, i, value, pyObjectStgDictNode, pyCDataSetNode);
            return PNone.NONE;
        }

        @Specialization(guards={"!isPNone(value)"})
        Object Array_ass_subscript(VirtualFrame frame, CDataObject self, PSlice slice, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectSizeNode pySequenceLength, @Cached PyObjectGetItem pySequenceGetItem, @Cached SliceNodes.SliceUnpack sliceUnpack, @Cached SliceNodes.AdjustIndices adjustIndices, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached CDataTypeBuiltins.PyCDataSetNode pyCDataSetNode) {
            PSlice.SliceInfo sliceInfo = adjustIndices.execute(inliningTarget, self.b_length, sliceUnpack.execute(inliningTarget, slice));
            int start = sliceInfo.start;
            int stop = sliceInfo.stop;
            int step = sliceInfo.step;
            int slicelen = sliceInfo.sliceLength;
            int otherlen = pySequenceLength.execute((Frame)frame, inliningTarget, value);
            if (otherlen != slicelen) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.CAN_ONLY_ASSIGN_SEQUENCE_OF_SAME_SIZE);
            }
            int cur = start;
            for (int i = 0; i < otherlen; ++i) {
                this.Array_ass_item(frame, self, cur, pySequenceGetItem.execute((Frame)frame, inliningTarget, value, i), pyObjectStgDictNode, pyCDataSetNode);
                cur += step;
            }
            return PNone.NONE;
        }

        @Specialization
        Object error(CDataObject self, Object item, PNone value) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.ARRAY_DOES_NOT_SUPPORT_ITEM_DELETION);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class InitNode
    extends PythonBuiltinNode {
        protected InitNode() {
        }

        @Specialization
        Object Array_init(VirtualFrame frame, CDataObject self, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetItem pySequenceSetItem) {
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                pySequenceSetItem.execute((Frame)frame, inliningTarget, self, i, args[i]);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends PythonBuiltinNode {
        protected NewNode() {
        }

        @Specialization
        protected Object newCData(Object type, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CtypesNodes.GenericPyCDataNewNode newNode2) {
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(type, this.getRaiseNode());
            return newNode2.execute(inliningTarget, type, dict);
        }
    }
}

