/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.WeakRefModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.referencetype.PReferenceType;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.WriteUnraisableNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToDynamicObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;

@CoreFunctions(defineModule="_weakref", isEager=true)
public final class WeakRefModuleBuiltins
extends PythonBuiltins {
    private static final HiddenKey weakRefQueueKey = new HiddenKey("weakRefQueue");
    private final ReferenceQueue<Object> weakRefQueue = new ReferenceQueue();
    public static final HiddenKey __WEAKLIST__ = new HiddenKey("__weaklist__");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return WeakRefModuleBuiltinsFactory.getFactories();
    }

    public static int getBuiltinTypeWeaklistoffset(PythonBuiltinClassType cls) {
        return switch (cls) {
            case PythonBuiltinClassType.PythonObject, PythonBuiltinClassType.PInt, PythonBuiltinClassType.Boolean, PythonBuiltinClassType.PByteArray, PythonBuiltinClassType.PBytes, PythonBuiltinClassType.PList, PythonBuiltinClassType.PNone, PythonBuiltinClassType.PNotImplemented, PythonBuiltinClassType.PTraceback, PythonBuiltinClassType.Super, PythonBuiltinClassType.PRange, PythonBuiltinClassType.PDict, PythonBuiltinClassType.PDictKeysView, PythonBuiltinClassType.PDictValuesView, PythonBuiltinClassType.PDictItemsView, PythonBuiltinClassType.PDictReverseKeyIterator, PythonBuiltinClassType.PDictReverseValueIterator, PythonBuiltinClassType.PDictReverseItemIterator, PythonBuiltinClassType.PString, PythonBuiltinClassType.PSlice, PythonBuiltinClassType.PStaticmethod, PythonBuiltinClassType.PComplex, PythonBuiltinClassType.PFloat, PythonBuiltinClassType.PProperty, PythonBuiltinClassType.PTuple, PythonBuiltinClassType.PEnumerate, PythonBuiltinClassType.PReverseIterator, PythonBuiltinClassType.PFrame, PythonBuiltinClassType.PMappingproxy, PythonBuiltinClassType.GetSetDescriptor, PythonBuiltinClassType.WrapperDescriptor, PythonBuiltinClassType.MethodWrapper, PythonBuiltinClassType.PEllipsis, PythonBuiltinClassType.MemberDescriptor, PythonBuiltinClassType.PSimpleNamespace, PythonBuiltinClassType.Capsule, PythonBuiltinClassType.PCell, PythonBuiltinClassType.PInstancemethod, PythonBuiltinClassType.PBuiltinClassMethod, PythonBuiltinClassType.PBuiltinFunction, PythonBuiltinClassType.PSentinelIterator, PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PCoroutineWrapper, PythonBuiltinClassType.PEncodingMap, PythonBuiltinClassType.PIntInfo, PythonBuiltinClassType.PBaseException, PythonBuiltinClassType.Exception, PythonBuiltinClassType.TypeError, PythonBuiltinClassType.StopAsyncIteration, PythonBuiltinClassType.StopIteration, PythonBuiltinClassType.GeneratorExit, PythonBuiltinClassType.SystemExit, PythonBuiltinClassType.KeyboardInterrupt, PythonBuiltinClassType.ImportError, PythonBuiltinClassType.ModuleNotFoundError, PythonBuiltinClassType.OSError, PythonBuiltinClassType.EOFError, PythonBuiltinClassType.RuntimeError, PythonBuiltinClassType.RecursionError, PythonBuiltinClassType.NotImplementedError, PythonBuiltinClassType.NameError, PythonBuiltinClassType.UnboundLocalError, PythonBuiltinClassType.AttributeError, PythonBuiltinClassType.SyntaxError, PythonBuiltinClassType.IndentationError, PythonBuiltinClassType.TabError, PythonBuiltinClassType.LookupError, PythonBuiltinClassType.IndexError, PythonBuiltinClassType.KeyError, PythonBuiltinClassType.ValueError, PythonBuiltinClassType.UnicodeError, PythonBuiltinClassType.UnicodeEncodeError, PythonBuiltinClassType.UnicodeDecodeError, PythonBuiltinClassType.UnicodeTranslateError, PythonBuiltinClassType.AssertionError, PythonBuiltinClassType.ArithmeticError, PythonBuiltinClassType.FloatingPointError, PythonBuiltinClassType.OverflowError, PythonBuiltinClassType.ZeroDivisionError, PythonBuiltinClassType.SystemError, PythonBuiltinClassType.ReferenceError, PythonBuiltinClassType.MemoryError, PythonBuiltinClassType.BufferError, PythonBuiltinClassType.Warning, PythonBuiltinClassType.UserWarning, PythonBuiltinClassType.DeprecationWarning, PythonBuiltinClassType.PendingDeprecationWarning, PythonBuiltinClassType.SyntaxWarning, PythonBuiltinClassType.RuntimeWarning, PythonBuiltinClassType.FutureWarning, PythonBuiltinClassType.ImportWarning, PythonBuiltinClassType.UnicodeWarning, PythonBuiltinClassType.BytesWarning, PythonBuiltinClassType.ResourceWarning, PythonBuiltinClassType.ConnectionError, PythonBuiltinClassType.BlockingIOError, PythonBuiltinClassType.BrokenPipeError, PythonBuiltinClassType.ChildProcessError, PythonBuiltinClassType.ConnectionAbortedError, PythonBuiltinClassType.ConnectionRefusedError, PythonBuiltinClassType.ConnectionResetError, PythonBuiltinClassType.FileExistsError, PythonBuiltinClassType.FileNotFoundError, PythonBuiltinClassType.IsADirectoryError, PythonBuiltinClassType.NotADirectoryError, PythonBuiltinClassType.InterruptedError, PythonBuiltinClassType.PermissionError, PythonBuiltinClassType.ProcessLookupError, PythonBuiltinClassType.TimeoutError, PythonBuiltinClassType.PFloatInfo, PythonBuiltinClassType.PythonModuleDef, PythonBuiltinClassType.PHashInfo, PythonBuiltinClassType.PVersionInfo, PythonBuiltinClassType.PFlags, PythonBuiltinClassType.PThreadInfo, PythonBuiltinClassType.PMap, PythonBuiltinClassType.PZip, PythonBuiltinClassType.PClassmethod, PythonBuiltinClassType.PBytesIOBuf, PythonBuiltinClassType.PIncrementalNewlineDecoder, PythonBuiltinClassType.PStatResult, PythonBuiltinClassType.PStatvfsResult, PythonBuiltinClassType.PTerminalSize, PythonBuiltinClassType.PScandirIterator, PythonBuiltinClassType.PDirEntry, PythonBuiltinClassType.PUnameResult, PythonBuiltinClassType.PStructTime, PythonBuiltinClassType.PDictItemIterator, PythonBuiltinClassType.PDictKeyIterator, PythonBuiltinClassType.PDictValueIterator, PythonBuiltinClassType.PAccumulate, PythonBuiltinClassType.PCombinations, PythonBuiltinClassType.PCombinationsWithReplacement, PythonBuiltinClassType.PCycle, PythonBuiltinClassType.PDropwhile, PythonBuiltinClassType.PTakewhile, PythonBuiltinClassType.PIslice, PythonBuiltinClassType.PStarmap, PythonBuiltinClassType.PChain, PythonBuiltinClassType.PCompress, PythonBuiltinClassType.PFilterfalse, PythonBuiltinClassType.PCount, PythonBuiltinClassType.PZipLongest, PythonBuiltinClassType.PPermutations, PythonBuiltinClassType.PProduct, PythonBuiltinClassType.PRepeat, PythonBuiltinClassType.PGroupBy, PythonBuiltinClassType.PTeeDataObject, PythonBuiltinClassType.PDefaultDict, PythonBuiltinClassType.PDequeIter, PythonBuiltinClassType.PDequeRevIter, PythonBuiltinClassType.PTupleGetter -> 0;
            case PythonBuiltinClassType.PythonClass -> 368;
            case PythonBuiltinClassType.PSet, PythonBuiltinClassType.PFrozenSet -> 192;
            case PythonBuiltinClassType.PMemoryView, PythonBuiltinClassType.PCode -> 136;
            case PythonBuiltinClassType.PBuiltinFunctionOrMethod, PythonBuiltinClassType.PGenerator, PythonBuiltinClassType.PCoroutine, PythonBuiltinClassType.PythonModule, PythonBuiltinClassType.PThreadLocal, PythonBuiltinClassType.PRLock, PythonBuiltinClassType.PBufferedRWPair, PythonBuiltinClassType.PAsyncGenerator -> 40;
            case PythonBuiltinClassType.PMethod, PythonBuiltinClassType.PFileIO, PythonBuiltinClassType.PTee -> 32;
            case PythonBuiltinClassType.PFunction -> 80;
            case PythonBuiltinClassType.PIOBase, PythonBuiltinClassType.PRawIOBase, PythonBuiltinClassType.PBufferedIOBase, PythonBuiltinClassType.PTextIOBase -> 24;
            case PythonBuiltinClassType.PBytesIO, PythonBuiltinClassType.PPartial -> 48;
            case PythonBuiltinClassType.PStringIO -> 112;
            case PythonBuiltinClassType.PBufferedReader, PythonBuiltinClassType.PBufferedWriter, PythonBuiltinClassType.PBufferedRandom, PythonBuiltinClassType.PLruCacheWrapper -> 144;
            case PythonBuiltinClassType.PTextIOWrapper -> 176;
            default -> -1;
        };
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule weakrefModule = core.lookupBuiltinModule(BuiltinNames.T__WEAKREF);
        weakrefModule.setAttribute(weakRefQueueKey, this.weakRefQueue);
        PythonBuiltinClass refType = core.lookupType(PythonBuiltinClassType.PReferenceType);
        weakrefModule.setAttribute(StringLiterals.T_REF, refType);
        refType.setAttribute(weakRefQueueKey, this.weakRefQueue);
        PythonContext ctx = core.getContext();
        core.getContext().registerAsyncAction(() -> {
            if (!ctx.isGcEnabled()) {
                return null;
            }
            Reference<Object> reference = null;
            if (PythonOptions.AUTOMATIC_ASYNC_ACTIONS) {
                try {
                    reference = this.weakRefQueue.remove();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                reference = this.weakRefQueue.poll();
            }
            ArrayList<PReferenceType.WeakRefStorage> refs = new ArrayList<PReferenceType.WeakRefStorage>();
            do {
                if (!(reference instanceof PReferenceType.WeakRefStorage)) continue;
                refs.add((PReferenceType.WeakRefStorage)reference);
            } while ((reference = this.weakRefQueue.poll()) != null);
            if (!refs.isEmpty()) {
                return new WeakrefCallbackAction(refs.toArray(new PReferenceType.WeakRefStorage[0]));
            }
            return null;
        });
    }

    private static class WeakrefCallbackAction
    extends AsyncHandler.AsyncPythonAction {
        private final PReferenceType.WeakRefStorage[] references;
        private int index;

        public WeakrefCallbackAction(PReferenceType.WeakRefStorage[] weakRefStorages) {
            this.references = weakRefStorages;
            this.index = 0;
        }

        @Override
        public Object callable() {
            return this.references[this.index].getCallback();
        }

        @Override
        public Object[] arguments() {
            return new Object[]{this.references[this.index].getRef()};
        }

        @Override
        public boolean proceed() {
            ++this.index;
            return this.index < this.references.length;
        }

        @Override
        protected void handleException(PException e) {
            WriteUnraisableNode.getUncached().execute(e.getEscapedException(), null, this.callable());
        }
    }

    @Builtin(name="_remove_dead_weakref", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class RemoveDeadWeakRefsNode
    extends PythonBuiltinNode {
        @Specialization
        public Object removeDeadRefs(PDict dict, Object key) {
            return PNone.NONE;
        }
    }

    @Builtin(name="getweakrefs", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetWeakRefsNode
    extends PythonBuiltinNode {
        @Specialization
        public Object getRefs(Object object) {
            return PNone.NONE;
        }
    }

    @Builtin(name="getweakrefcount", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetWeakRefCountNode
    extends PythonBuiltinNode {
        @Specialization
        public Object getCount(PReferenceType pReferenceType) {
            return pReferenceType.getWeakRefCount();
        }

        @Fallback
        public Object getCount(Object none) {
            return 0;
        }
    }

    @Builtin(name="ReferenceType", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3, constructsClass=PythonBuiltinClassType.PReferenceType)
    @GenerateNodeFactory
    public static abstract class ReferenceTypeNode
    extends PythonTernaryBuiltinNode {
        @Node.Child
        private ReadAttributeFromObjectNode readQueue = ReadAttributeFromObjectNode.create();
        @Node.Child
        private CStructAccess.ReadI64Node getTpWeaklistoffsetNode;

        @Specialization(guards={"!isNativeObject(object)"})
        public PReferenceType refType(Object cls, Object object, PNone none, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached ReadAttributeFromObjectNode getAttrNode, @Cached WriteAttributeToDynamicObjectNode setAttrNode) {
            Object obj = object;
            if (object instanceof PythonBuiltinClassType) {
                PythonBuiltinClassType tobj = (PythonBuiltinClassType)((Object)object);
                obj = this.getContext().getCore().lookupType(tobj);
            }
            Object clazz = getClassNode.execute(this, obj);
            boolean allowed = true;
            if (clazz instanceof PythonBuiltinClassType) {
                PythonBuiltinClassType type = (PythonBuiltinClassType)((Object)clazz);
                boolean bl = allowed = type.getWeaklistoffset() != 0;
            }
            if (!allowed) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_WEAK_REFERENCE_TO, obj);
            }
            Object wr = getAttrNode.execute(obj, __WEAKLIST__);
            if (wr != PNone.NO_VALUE) {
                return (PReferenceType)wr;
            }
            PReferenceType ref = this.factory().createReferenceType(cls, obj, null, this.getWeakReferenceQueue());
            setAttrNode.execute(obj, __WEAKLIST__, (Object)ref);
            return ref;
        }

        @Specialization(guards={"!isNativeObject(object)", "!isPNone(callback)"})
        public PReferenceType refTypeWithCallback(Object cls, Object object, Object callback) {
            return this.factory().createReferenceType(cls, object, callback, this.getWeakReferenceQueue());
        }

        @Specialization
        public PReferenceType refType(Object cls, PythonAbstractNativeObject pythonObject, Object callback, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached BuiltinClassProfiles.InlineIsBuiltinClassProfile profile, @Cached TypeNodes.GetMroNode getMroNode) {
            Object actualCallback = callback instanceof PNone ? null : callback;
            Object clazz = getClassNode.execute(inliningTarget, pythonObject);
            boolean allowed = false;
            if (profile.profileClass(inliningTarget, clazz, PythonBuiltinClassType.PythonClass)) {
                allowed = true;
            } else if (PGuards.isNativeClass(clazz) || clazz instanceof PythonClass && ((PythonClass)clazz).needsNativeAllocation()) {
                for (PythonAbstractClass base : getMroNode.execute(inliningTarget, clazz)) {
                    if (PGuards.isNativeClass(base)) {
                        long tpWeaklistoffset;
                        if (this.getTpWeaklistoffsetNode == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.getTpWeaklistoffsetNode = (CStructAccess.ReadI64Node)this.insert(CStructAccess.ReadI64Node.create());
                        }
                        if ((tpWeaklistoffset = this.getTpWeaklistoffsetNode.readFromObj((PythonNativeClass)base, CFields.PyTypeObject__tp_weaklistoffset)) == 0L) continue;
                        allowed = true;
                        break;
                    }
                    if (!(base instanceof PythonClass)) continue;
                    allowed = true;
                    break;
                }
            }
            if (allowed) {
                return this.factory().createReferenceType(cls, pythonObject, actualCallback, this.getWeakReferenceQueue());
            }
            return this.refType(cls, pythonObject, actualCallback);
        }

        @Fallback
        public PReferenceType refType(Object cls, Object object, Object callback) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_WEAK_REFERENCE_TO, object);
        }

        private ReferenceQueue<Object> getWeakReferenceQueue() {
            Object queueObject = this.readQueue.execute(this.getContext().lookupType(PythonBuiltinClassType.PReferenceType), weakRefQueueKey);
            if (queueObject instanceof ReferenceQueue) {
                ReferenceQueue queue = (ReferenceQueue)queueObject;
                return queue;
            }
            if (this.getContext().isCoreInitialized()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("the weak reference queue was modified!");
            }
            return null;
        }
    }
}

