/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff;

import com.oracle.objectfile.pecoff.PECoff;
import com.oracle.objectfile.pecoff.PECoffByteBuffer;
import com.oracle.objectfile.pecoff.PECoffRelocStruct;
import java.nio.ByteBuffer;
import java.util.ArrayList;

final class PECoffRelocTableStruct {
    ArrayList<ArrayList<PECoffRelocStruct>> relocEntries;

    PECoffRelocTableStruct(int numsects) {
        this.relocEntries = new ArrayList(numsects);
        for (int i = 0; i < numsects; ++i) {
            this.relocEntries.add(new ArrayList());
        }
    }

    void createRelocationEntry(int sectindex, int offset, int symno, int type) {
        PECoffRelocStruct entry = new PECoffRelocStruct(offset, symno, type);
        this.relocEntries.get(sectindex).add(entry);
    }

    static int getAlign() {
        return 4;
    }

    int getNumRelocs(int sectionIndex) {
        return this.relocEntries.get(sectionIndex).size();
    }

    byte[] getRelocData(int sectionIndex) {
        int entryCount;
        ArrayList<PECoffRelocStruct> entryList = this.relocEntries.get(sectionIndex);
        int allocCount = entryCount = entryList.size();
        if (entryCount == 0) {
            return null;
        }
        if (entryCount > 65535) {
            ++allocCount;
        }
        ByteBuffer relocData = PECoffByteBuffer.allocate(allocCount * PECoff.IMAGE_RELOCATION.totalsize);
        if (entryCount > 65535) {
            PECoffRelocStruct entry = new PECoffRelocStruct(allocCount, 0, 0);
            relocData.put(entry.getArray());
        }
        for (int i = 0; i < entryCount; ++i) {
            PECoffRelocStruct entry = entryList.get(i);
            relocData.put(entry.getArray());
        }
        return relocData.array();
    }
}

