/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.ExternalStatusCheck;
import org.gitlab4j.api.models.ExternalStatusCheckProtectedBranch;
import org.gitlab4j.api.models.ExternalStatusCheckResult;
import org.gitlab4j.api.models.ExternalStatusCheckStatus;

public class ExternalStatusCheckApi
extends AbstractApi {
    public ExternalStatusCheckApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<ExternalStatusCheck> getExternalStatusChecks(Object projectIdOrPath) throws GitLabApiException {
        return this.getExternalStatusChecks(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<ExternalStatusCheck> getExternalStatusChecks(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<ExternalStatusCheck>(this, ExternalStatusCheck.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "external_status_checks");
    }

    public Stream<ExternalStatusCheck> getExternalStatusChecksStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getExternalStatusChecks(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public ExternalStatusCheck createExternalStatusCheck(Object projectIdOrPath, String name, String externalUrl, List<Long> protectedBranchIds) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("external_url", externalUrl, true).withParam("protected_branch_ids", protectedBranchIds);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "external_status_checks"});
        return (ExternalStatusCheck)response.readEntity(ExternalStatusCheck.class);
    }

    public ExternalStatusCheck createExternalStatusCheck(Object projectIdOrPath, ExternalStatusCheck externalStatusCheck) throws GitLabApiException {
        List protectedBranchIds = externalStatusCheck.getProtectedBranches() == null ? null : externalStatusCheck.getProtectedBranches().stream().map(ExternalStatusCheckProtectedBranch::getId).collect(Collectors.toList());
        GitLabApiForm formData = new GitLabApiForm().withParam("name", externalStatusCheck.getName(), true).withParam("external_url", externalStatusCheck.getExternalUrl(), true).withParam("protected_branch_ids", protectedBranchIds);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "external_status_checks"});
        return (ExternalStatusCheck)response.readEntity(ExternalStatusCheck.class);
    }

    public ExternalStatusCheck updateExternalStatusCheck(Object projectIdOrPath, Long checkId, String name, String externalUrl, List<Long> protectedBranchIds) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("external_url", externalUrl).withParam("protected_branch_ids", protectedBranchIds);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "external_status_checks", checkId});
        return (ExternalStatusCheck)response.readEntity(ExternalStatusCheck.class);
    }

    public ExternalStatusCheck updateExternalStatusCheck(Object projectIdOrPath, ExternalStatusCheck externalStatusCheck) throws GitLabApiException {
        if (externalStatusCheck == null || externalStatusCheck.getId() == null) {
            throw new GitLabApiException("the specified external status check is null or has no id");
        }
        List<Long> protectedBranchIds = this.getProtectedBranchIds(externalStatusCheck);
        GitLabApiForm formData = new GitLabApiForm().withParam("name", externalStatusCheck.getName()).withParam("external_url", externalStatusCheck.getExternalUrl()).withParam("protected_branch_ids", protectedBranchIds);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "external_status_checks", externalStatusCheck.getId()});
        return (ExternalStatusCheck)response.readEntity(ExternalStatusCheck.class);
    }

    private List<Long> getProtectedBranchIds(ExternalStatusCheck externalStatusCheck) {
        if (externalStatusCheck.getProtectedBranches() == null) {
            return null;
        }
        return externalStatusCheck.getProtectedBranches().stream().map(ExternalStatusCheckProtectedBranch::getId).collect(Collectors.toList());
    }

    public void deleteExternalStatusCheck(Object projectIdOrPath, Long checkId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "external_status_checks", checkId);
    }

    public List<ExternalStatusCheckStatus> getExternalStatusCheckStatuses(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getExternalStatusCheckStatuses(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).all();
    }

    public Pager<ExternalStatusCheckStatus> getExternalStatusCheckStatuses(Object projectIdOrPath, Long mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<ExternalStatusCheckStatus>(this, ExternalStatusCheckStatus.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "status_checks");
    }

    public Stream<ExternalStatusCheckStatus> getExternalStatusCheckStatusesStream(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getExternalStatusCheckStatuses(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).stream();
    }

    public ExternalStatusCheckResult setStatusOfExternalStatusCheck(Object projectIdOrPath, Long mergeRequestIid, String sha, Long externalStatusCheckId, ExternalStatusCheckStatus.Status status) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha).withParam("external_status_check_id", externalStatusCheckId).withParam("status", status);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "status_check_responses"});
        return (ExternalStatusCheckResult)response.readEntity(ExternalStatusCheckResult.class);
    }

    public void retryExternalStatusCheck(Object projectIdOrPath, Long mergeRequestIid, Long externalStatusCheckId) throws GitLabApiException {
        this.post(Response.Status.ACCEPTED, (Form)null, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "status_checks", externalStatusCheckId, "retry"});
    }
}

