/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.generator;

import java.util.Random;
import org.geolatte.geom.Box;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.builder.DSL;
import org.geolatte.geom.generator.AbstractGeometryGenerator;
import org.geolatte.geom.generator.PositionGenerator;

class DefaultPolygonGenerator<P extends Position>
extends AbstractGeometryGenerator<P, Polygon<P>> {
    private final int numPoints;

    DefaultPolygonGenerator(int numPoints, Box<P> bbox, Random rnd) {
        super(bbox, rnd);
        this.numPoints = numPoints;
    }

    @Override
    public Polygon<P> generate() {
        Position[] ps = PositionGenerator.nPositionsWithinAndClosed((int)this.numPoints, (Box)this.bbox, (Random)this.rnd);
        LinearRing hull = DSL.ring(this.crs(), (Position[])ps);
        return DSL.polygon(hull, new LinearRing[0]);
    }
}

