/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.Element;
import org.geolatte.geom.codec.db.oracle.Ordinates;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOPoint;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsRegistry;

public class SDOGeometry {
    private static final String SQL_TYPE_NAME = "MDSYS.SDO_GEOMETRY";
    private static final String SQL_POINT_TYPE_NAME = "MDSYS.SDO_POINT_TYPE";
    private final SDOGType gtype;
    private final int srid;
    private final SDOPoint point;
    private final ElemInfo info;
    private final Ordinates ordinates;
    private final List<Element> elements;
    private final CoordinateReferenceSystem<?> crs;

    SDOGeometry(SDOGType gtype, int srid, SDOPoint point, ElemInfo info, Ordinates ordinates) {
        this.gtype = gtype;
        this.srid = srid;
        this.point = point;
        this.info = info;
        this.ordinates = ordinates;
        this.crs = SDOGeometry.determineCrs(srid, gtype);
        this.elements = info != null ? info.interpret(gtype, ordinates.getOrdinateArray()) : new ArrayList<Element>();
    }

    public static String getTypeName() {
        return SQL_TYPE_NAME;
    }

    public static String getPointTypeName() {
        return SQL_POINT_TYPE_NAME;
    }

    static String arrayToString(Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return "()";
        }
        int length = Array.getLength(array);
        StringBuilder stb = new StringBuilder();
        stb.append("(").append(Array.get(array, 0));
        for (int i = 1; i < length; ++i) {
            stb.append(",").append(Array.get(array, i));
        }
        stb.append(")");
        return stb.toString();
    }

    static void shiftOrdinateOffset(ElemInfo elemInfo, int offset) {
        for (int i = 0; i < elemInfo.getNumTriplets(); ++i) {
            int newOffset = elemInfo.getOrdinatesOffset(i) + offset;
            elemInfo.setOrdinatesOffset(i, newOffset);
        }
    }

    public static SDOGeometry load(Struct struct) {
        Object[] data;
        try {
            data = struct.getAttributes();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return new SDOGeometry(SDOGType.parse(data[0]), SDOGeometry.parseSRID(data[1]), data[2] == null ? null : new SDOPoint((Struct)data[2]), new ElemInfo((java.sql.Array)data[3]), new Ordinates((java.sql.Array)data[4]));
    }

    public ElemInfo getInfo() {
        return this.info;
    }

    public SDOGType getGType() {
        return this.gtype;
    }

    public SDOPoint getPoint() {
        return this.point;
    }

    public int getSRID() {
        return this.srid;
    }

    private static int parseSRID(Object datum) {
        if (datum == null) {
            return 0;
        }
        try {
            return ((Number)datum).intValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getDimension() {
        return this.gtype.getDimension();
    }

    public int getLRSDimension() {
        return this.gtype.getLRSDimension();
    }

    public int getZDimension() {
        return this.gtype.getZDimension();
    }

    public CoordinateReferenceSystem<?> getCoordinateReferenceSystem() {
        return this.crs;
    }

    public Ordinates getOrdinates() {
        return this.ordinates;
    }

    public int getNumElements() {
        return this.elements.size();
    }

    public Element getElement(int i) {
        return this.elements.get(i);
    }

    List<Element> getElements() {
        return this.elements;
    }

    public PositionSequence<?> getElementPositions(int i) {
        return this.elements.get(i).linearizedPositions(this.gtype, this.crs);
    }

    private static CoordinateReferenceSystem<?> determineCrs(int srid, SDOGType gtype) {
        CoordinateReferenceSystem<?> crs = CrsRegistry.ifAbsentReturnProjected2D(srid);
        return CoordinateReferenceSystems.adjustTo(crs, gtype.getZDimension() > 0, gtype.getLRSDimension() > 0);
    }

    public String toString() {
        return "(" + this.gtype + "," + this.srid + "," + this.point + "," + this.info + "," + this.ordinates + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SDOGeometry that = (SDOGeometry)o;
        if (this.srid != that.srid) {
            return false;
        }
        if (!Objects.equals(this.gtype, that.gtype)) {
            return false;
        }
        if (!Objects.equals(this.info, that.info)) {
            return false;
        }
        if (!Objects.equals(this.ordinates, that.ordinates)) {
            return false;
        }
        return Objects.equals(this.point, that.point);
    }

    public int hashCode() {
        int result = this.gtype != null ? this.gtype.hashCode() : 0;
        result = 31 * result + this.srid;
        result = 31 * result + (this.point != null ? this.point.hashCode() : 0);
        result = 31 * result + (this.info != null ? this.info.hashCode() : 0);
        result = 31 * result + (this.ordinates != null ? this.ordinates.hashCode() : 0);
        return result;
    }
}

