/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.Element;
import org.geolatte.geom.codec.db.oracle.PolygonSdoDecoder;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SdoGeometryType;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class MultiPolygonSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == SdoGeometryType.MULTIPOLYGON;
    }

    @Override
    Geometry<?> internalDecode() {
        return this.decode(this.nativeGeom.getGType(), this.nativeGeom.getElements(), this.nativeGeom.getCoordinateReferenceSystem());
    }

    @Override
    protected <P extends Position> Geometry<P> decode(SDOGType gtype, List<Element> elements, CoordinateReferenceSystem<P> crs) {
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        ArrayList<Element> rings = new ArrayList<Element>();
        PolygonSdoDecoder decoder = new PolygonSdoDecoder();
        for (Element element : elements) {
            if (element.isExteriorRing() && !rings.isEmpty()) {
                polys.add((Polygon)((AbstractSDODecoder)decoder).decode(gtype, rings, crs));
                rings.clear();
            }
            rings.add(element);
        }
        if (!rings.isEmpty()) {
            polys.add((Polygon)((AbstractSDODecoder)decoder).decode(gtype, rings, crs));
        }
        return polys.isEmpty() ? new MultiPolygon<P>(crs) : new MultiPolygon(polys.toArray(new Polygon[0]));
    }
}

