/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geolatte.geom.codec.WktDecodeException;

class SimpleTokenizer {
    public static final char openListChar = '(';
    public static final char closeListChar = ')';
    public static final char elementSeparator = ',';
    private final CharSequence input;
    private int currentPos = 0;
    private static final long S_MAX = 0x1FFFFFFFFFFFFFL;
    private static final long P_MAX = 22L;

    public SimpleTokenizer(String input) {
        this.input = input;
    }

    public void resetTo(int newPos) {
        if (this.currentPos < newPos) {
            throw new IllegalStateException("Trying to reset to a position beyond current position");
        }
        this.currentPos = newPos;
    }

    public void back(int numPos) {
        if (this.currentPos < numPos) {
            throw new IllegalStateException("Trying to return beyond start of input");
        }
        this.currentPos -= numPos;
    }

    public int currentPos() {
        return this.currentPos;
    }

    public String input() {
        return this.input.toString();
    }

    public void skipWhitespace() {
        while (!this.endOfInput() && Character.isWhitespace(this.currentChar())) {
            ++this.currentPos;
        }
    }

    private boolean endOfInput() {
        return this.currentPos >= this.input.length();
    }

    public boolean hasMoreInput() {
        this.skipWhitespace();
        return !this.endOfInput();
    }

    public double readNumber() {
        this.skipWhitespace();
        StringBuilder stb = new StringBuilder();
        char c = this.currentChar();
        if (c == '-') {
            stb.append(c);
            this.nextChar();
        }
        this.readDigits(stb);
        if (!this.endOfInput() && this.currentChar() == '.') {
            stb.append(this.currentChar());
            this.nextChar();
            this.readDigits(stb);
        }
        try {
            return Double.parseDouble(stb.toString());
        }
        catch (NumberFormatException ex) {
            throw new WktDecodeException("Expected double", ex);
        }
    }

    private void readDigits(StringBuilder stb) {
        if (!this.endOfInput() && !Character.isDigit(this.currentChar())) {
            this.nextChar();
        }
        while (!this.endOfInput() && Character.isDigit(this.currentChar())) {
            stb.append(this.currentChar());
            this.nextChar();
        }
    }

    public String readLiteralText() {
        this.skipWhitespace();
        if (this.currentChar() != '\"') {
            throw new WktDecodeException("Expected quote character");
        }
        StringBuilder builder = new StringBuilder();
        this.nextChar();
        while (this.currentChar() != '\"') {
            builder.append(this.currentChar());
            this.nextChar();
            if (!this.endOfInput()) continue;
            throw new WktDecodeException("Literal text is not terminated");
        }
        this.nextChar();
        return builder.toString();
    }

    public String readText() {
        if (this.hasMoreInput() && !Character.isLetterOrDigit(this.currentChar())) {
            throw new WktDecodeException("Expected a letter or digit");
        }
        StringBuilder builder = new StringBuilder();
        while (!this.endOfInput() && Character.isLetterOrDigit(this.currentChar())) {
            builder.append(this.currentChar());
            this.nextChar();
        }
        return builder.toString();
    }

    public char currentChar() {
        try {
            return this.input.charAt(this.currentPos);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new WktDecodeException("Unexpected end of input at position " + this.currentPos);
        }
    }

    public boolean matchesChar(char c, boolean skipWhitespace) {
        if (skipWhitespace) {
            this.skipWhitespace();
        }
        if (this.currentChar() == c) {
            this.nextChar();
            return true;
        }
        return false;
    }

    public boolean matchPattern(Pattern pattern) {
        this.skipWhitespace();
        Matcher m = pattern.matcher(this.input);
        m.region(this.currentPos, this.input.length());
        if (m.lookingAt()) {
            this.currentPos = m.end();
            return true;
        }
        return false;
    }

    public Optional<String> extractGroupFromPattern(Pattern pattern, int group) {
        this.skipWhitespace();
        Matcher m = pattern.matcher(this.input);
        m.region(this.currentPos, this.input.length());
        if (m.lookingAt()) {
            try {
                this.currentPos = m.end();
                return Optional.of(m.group(group));
            }
            catch (IndexOutOfBoundsException t) {
                throw new WktDecodeException("Attempted to extract non-existent capture group");
            }
        }
        return Optional.empty();
    }

    public Optional<Character> matchesOneOf(char ... choices) {
        this.skipWhitespace();
        for (char c : choices) {
            if (this.currentChar() != c) continue;
            this.nextChar();
            return Optional.of(Character.valueOf(c));
        }
        return Optional.empty();
    }

    public boolean matchesOpenList() {
        return this.matchesChar('(', true);
    }

    public boolean matchesCloseList() {
        return this.matchesChar(')', true);
    }

    public boolean matchElementSeparator() {
        return this.matchesChar(',', true);
    }

    protected double fastReadNumber() {
        this.skipWhitespace();
        int startPos = this.currentPos;
        char c = this.input.charAt(this.currentPos);
        double sign = 1.0;
        if (c == '-') {
            sign = -1.0;
            c = this.input.charAt(++this.currentPos);
        }
        long s = 0L;
        boolean digitsSeen = false;
        boolean decPntSeen = false;
        long decPos = -1L;
        while (true) {
            if (Character.isDigit(c)) {
                s = 10L * s + (long)(c - 48);
                digitsSeen = true;
            } else {
                if (c != '.') break;
                if (decPntSeen) {
                    throw new WktDecodeException("Invalid number format at position " + this.currentPos);
                }
                decPntSeen = true;
            }
            if (decPntSeen) {
                ++decPos;
            }
            this.nextChar();
            if (this.endOfInput()) break;
            c = this.currentChar();
        }
        long exp = 0L;
        long expSign = 1L;
        if (c == 'e' || c == 'E') {
            if ((c = this.input.charAt(++this.currentPos)) == '-') {
                expSign = -1L;
                c = this.input.charAt(++this.currentPos);
            }
            while (Character.isDigit(c)) {
                exp = 10L * exp + (long)(c - 48);
                this.nextChar();
                if (this.endOfInput()) break;
                c = this.currentChar();
            }
        }
        if (!digitsSeen) {
            throw new WktDecodeException("Invalid number format at position " + this.currentPos);
        }
        long p = decPos >= 0L ? expSign * exp - decPos : expSign * exp;
        int endPos = this.currentPos;
        return this.toDouble(sign, s, p, startPos, endPos);
    }

    private double toDouble(double sign, long s, long p, int startPos, int endPos) {
        if (s == 0L) {
            return 0.0;
        }
        if (s > 0L && s <= 0x1FFFFFFFFFFFFFL && Math.abs(p) <= 22L) {
            if (p == 0L) {
                return sign * (double)s;
            }
            if (p < 0L) {
                return sign * ((double)s / Math.pow(10.0, -p));
            }
            return sign * ((double)s * Math.pow(10.0, p));
        }
        return Double.parseDouble(this.input.subSequence(startPos, endPos).toString());
    }

    private void nextChar() {
        ++this.currentPos;
    }
}

