/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.rest;

import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class FormRestUrlBuilder {
    protected String baseUrl = "";

    protected FormRestUrlBuilder() {
    }

    protected FormRestUrlBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String buildUrl(String[] fragments, Object ... arguments) {
        return this.baseUrl + "/" + MessageFormat.format(StringUtils.join((Object[])fragments, (char)'/'), arguments);
    }

    public static FormRestUrlBuilder usingBaseUrl(String baseUrl) {
        if (baseUrl == null) {
            throw new FlowableIllegalArgumentException("baseUrl can not be null");
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return new FormRestUrlBuilder(baseUrl);
    }

    public static FormRestUrlBuilder fromRequest(HttpServletRequest request) {
        return FormRestUrlBuilder.usingBaseUrl(ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)request).build().toUriString());
    }

    public static FormRestUrlBuilder fromCurrentRequest() {
        return FormRestUrlBuilder.usingBaseUrl(ServletUriComponentsBuilder.fromCurrentServletMapping().build().toUriString());
    }
}

