/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.form.api.FormModel;
import org.flowable.form.model.FormContainer;
import org.flowable.form.model.FormField;
import org.flowable.form.model.FormOutcome;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SimpleFormModel
implements FormModel {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String key;
    protected int version;
    protected String description;
    protected List<FormField> fields;
    protected List<FormOutcome> outcomes;
    protected String outcomeVariableName;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<FormField> getFields() {
        return this.fields;
    }

    public void setFields(List<FormField> fields) {
        this.fields = fields;
    }

    public List<FormOutcome> getOutcomes() {
        return this.outcomes;
    }

    public void setOutcomes(List<FormOutcome> outcomes) {
        this.outcomes = outcomes;
    }

    public String getOutcomeVariableName() {
        return this.outcomeVariableName;
    }

    public void setOutcomeVariableName(String outcomeVariableName) {
        this.outcomeVariableName = outcomeVariableName;
    }

    public Map<String, FormField> allFieldsAsMap() {
        HashMap<String, FormField> result = new HashMap<String, FormField>();
        List<FormField> allFields = this.listAllFields();
        if (allFields != null) {
            for (FormField field : allFields) {
                if (result.containsKey(field.getId())) continue;
                result.put(field.getId(), field);
            }
        }
        return result;
    }

    public List<FormField> listAllFields() {
        ArrayList<FormField> listOfAllFields = new ArrayList<FormField>();
        this.collectSubFields(this.fields, listOfAllFields);
        return listOfAllFields;
    }

    protected void collectSubFields(List<FormField> fields, List<FormField> listOfAllFields) {
        if (fields != null && fields.size() > 0) {
            for (FormField field : fields) {
                FormContainer container;
                List<List<FormField>> subFields;
                listOfAllFields.add(field);
                if (!(field instanceof FormContainer) || (subFields = (container = (FormContainer)field).getFields()) == null) continue;
                for (List<FormField> subFieldDefinitions : subFields) {
                    if (subFieldDefinitions == null) continue;
                    this.collectSubFields(subFieldDefinitions, listOfAllFields);
                }
            }
        }
    }
}

