/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.event;

import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.event.AbstractEventHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;

public class MessageEventHandler
extends AbstractEventHandler {
    public static final String EVENT_HANDLER_TYPE = "message";

    @Override
    public String getEventHandlerType() {
        return EVENT_HANDLER_TYPE;
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            String executionId = eventSubscription.getExecutionId();
            ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(executionId);
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createMessageEvent(FlowableEngineEventType.ACTIVITY_MESSAGE_RECEIVED, eventSubscription.getActivityId(), eventSubscription.getEventName(), payload, eventSubscription.getExecutionId(), eventSubscription.getProcessInstanceId(), execution.getProcessDefinitionId()));
        }
        super.handleEvent(eventSubscription, payload, commandContext);
    }
}

