/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.test;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.test.EnsureCleanDbUtils;
import org.flowable.dmn.api.DmnDeploymentBuilder;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.deployer.DmnResourceUtil;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.engine.test.DmnDeployment;
import org.flowable.dmn.engine.test.DmnDeploymentAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DmnTestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnTestHelper.class);
    public static final String EMPTY_LINE = "\n";
    static Map<String, DmnEngine> dmnEngines = new HashMap<String, DmnEngine>();
    private static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = new ArrayList<String>();

    public static String annotationDeploymentSetUp(DmnEngine dmnEngine, Class<?> testClass, String methodName) {
        DmnDeploymentAnnotation deploymentAnnotation2;
        String deploymentId = null;
        Method method = null;
        try {
            method = testClass.getMethod(methodName, null);
        }
        catch (Exception e) {
            LOGGER.warn("Could not get method by reflection. This could happen if you are using @Parameters in combination with annotations.", (Throwable)e);
            return null;
        }
        DmnDeployment deploymentAnnotation = method.getAnnotation(DmnDeployment.class);
        if (deploymentAnnotation != null) {
            deploymentId = DmnTestHelper.deployResourceFromAnnotation(dmnEngine, testClass, methodName, method, deploymentAnnotation.resources());
        }
        if ((deploymentAnnotation2 = method.getAnnotation(DmnDeploymentAnnotation.class)) != null) {
            deploymentId = DmnTestHelper.deployResourceFromAnnotation(dmnEngine, testClass, methodName, method, deploymentAnnotation2.resources());
        }
        return deploymentId;
    }

    public static String annotationDeploymentSetUp(DmnEngine dmnEngine, Class<?> testClass, Method method, DmnDeployment dmnDeploymentAnnotation) {
        String deploymentId = null;
        if (dmnDeploymentAnnotation != null) {
            deploymentId = DmnTestHelper.deployResourceFromAnnotation(dmnEngine, testClass, method.getName(), method, dmnDeploymentAnnotation.resources());
        }
        return deploymentId;
    }

    public static String annotationDeploymentSetUp(DmnEngine dmnEngine, Class<?> testClass, Method method, DmnDeploymentAnnotation dmnDeploymentAnnotation) {
        String deploymentId = null;
        if (dmnDeploymentAnnotation != null) {
            deploymentId = DmnTestHelper.deployResourceFromAnnotation(dmnEngine, testClass, method.getName(), method, dmnDeploymentAnnotation.resources());
        }
        return deploymentId;
    }

    protected static String deployResourceFromAnnotation(DmnEngine dmnEngine, Class<?> testClass, String methodName, Method method, String[] resources) {
        LOGGER.debug("annotation @Deployment creates deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
        if (resources.length == 0) {
            String name = method.getName();
            String resource = DmnTestHelper.getDmnDecisionResource(testClass, name);
            resources = new String[]{resource};
        }
        DmnDeploymentBuilder deploymentBuilder = dmnEngine.getDmnRepositoryService().createDeployment().name(testClass.getSimpleName() + "." + methodName);
        for (String resource : resources) {
            deploymentBuilder.addClasspathResource(resource);
        }
        String deploymentId = deploymentBuilder.deploy().getId();
        return deploymentId;
    }

    public static void annotationDeploymentTearDown(DmnEngine dmnEngine, String deploymentId, Class<?> testClass, String methodName) {
        LOGGER.debug("annotation @Deployment deletes deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
        if (deploymentId != null) {
            try {
                dmnEngine.getDmnRepositoryService().deleteDeployment(deploymentId);
            }
            catch (FlowableObjectNotFoundException flowableObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static String getDmnDecisionResource(Class<?> type, String name) {
        for (String suffix : DmnResourceUtil.DMN_RESOURCE_SUFFIXES) {
            String resource = type.getName().replace('.', '/') + "." + name + "." + suffix;
            InputStream inputStream = DmnTestHelper.class.getClassLoader().getResourceAsStream(resource);
            if (inputStream == null) continue;
            return resource;
        }
        return type.getName().replace('.', '/') + "." + name + "." + DmnResourceUtil.DMN_RESOURCE_SUFFIXES[0];
    }

    public static DmnEngine getDmnEngine(String configurationResource) {
        DmnEngine dmnEngine = dmnEngines.get(configurationResource);
        if (dmnEngine == null) {
            LOGGER.debug("==== BUILDING DMN ENGINE ========================================================================");
            dmnEngine = DmnEngineConfiguration.createDmnEngineConfigurationFromResource(configurationResource).setDatabaseSchemaUpdate("drop-create").buildDmnEngine();
            LOGGER.debug("==== DMN ENGINE CREATED =========================================================================");
            dmnEngines.put(configurationResource, dmnEngine);
        }
        return dmnEngine;
    }

    public static void closeDmnEngines() {
        for (DmnEngine dmnEngine : dmnEngines.values()) {
            dmnEngine.close();
        }
        dmnEngines.clear();
    }

    public static void assertAndEnsureCleanDb(DmnEngine dmnEngine) {
        EnsureCleanDbUtils.assertAndEnsureCleanDb((String)"", (Logger)LOGGER, (AbstractEngineConfiguration)dmnEngine.getDmnEngineConfiguration(), TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK, (boolean)true, (Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                SchemaManager schemaManager = CommandContextUtil.getDmnEngineConfiguration().getSchemaManager();
                schemaManager.schemaDrop();
                schemaManager.schemaCreate();
                return null;
            }
        });
    }

    static {
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_DMN_DATABASECHANGELOG");
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_DMN_DATABASECHANGELOGLOCK");
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_GE_PROPERTY");
    }
}

